<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationsCreditMemo StructType
 * @subpackage Structs
 */
class ApplicationsCreditMemo extends AbstractStructBase
{
    /**
     * The InvoiceApplicationsCreditMemo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\InvoiceApplicationsCreditMemo[]
     */
    public $InvoiceApplicationsCreditMemo;
    /**
     * The SalesInvoiceApplicationCreditMemo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo[]
     */
    public $SalesInvoiceApplicationCreditMemo;
    /**
     * Constructor method for ApplicationsCreditMemo
     * @uses ApplicationsCreditMemo::setInvoiceApplicationsCreditMemo()
     * @uses ApplicationsCreditMemo::setSalesInvoiceApplicationCreditMemo()
     * @param \App\API\SOAP\StructType\InvoiceApplicationsCreditMemo[] $invoiceApplicationsCreditMemo
     * @param \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo[] $salesInvoiceApplicationCreditMemo
     */
    public function __construct(array $invoiceApplicationsCreditMemo = array(), array $salesInvoiceApplicationCreditMemo = array())
    {
        $this
            ->setInvoiceApplicationsCreditMemo($invoiceApplicationsCreditMemo)
            ->setSalesInvoiceApplicationCreditMemo($salesInvoiceApplicationCreditMemo);
    }
    /**
     * Get InvoiceApplicationsCreditMemo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\InvoiceApplicationsCreditMemo[]|null
     */
    public function getInvoiceApplicationsCreditMemo()
    {
        return isset($this->InvoiceApplicationsCreditMemo) ? $this->InvoiceApplicationsCreditMemo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceApplicationsCreditMemo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceApplicationsCreditMemo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceApplicationsCreditMemoForArrayConstraintsFromSetInvoiceApplicationsCreditMemo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicationsCreditMemoInvoiceApplicationsCreditMemoItem) {
            // validation for constraint: itemType
            if (!$applicationsCreditMemoInvoiceApplicationsCreditMemoItem instanceof \App\API\SOAP\StructType\InvoiceApplicationsCreditMemo) {
                $invalidValues[] = is_object($applicationsCreditMemoInvoiceApplicationsCreditMemoItem) ? get_class($applicationsCreditMemoInvoiceApplicationsCreditMemoItem) : sprintf('%s(%s)', gettype($applicationsCreditMemoInvoiceApplicationsCreditMemoItem), var_export($applicationsCreditMemoInvoiceApplicationsCreditMemoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceApplicationsCreditMemo property can only contain items of type \App\API\SOAP\StructType\InvoiceApplicationsCreditMemo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceApplicationsCreditMemo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InvoiceApplicationsCreditMemo[] $invoiceApplicationsCreditMemo
     * @return \App\API\SOAP\StructType\ApplicationsCreditMemo
     */
    public function setInvoiceApplicationsCreditMemo(array $invoiceApplicationsCreditMemo = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceApplicationsCreditMemoArrayErrorMessage = self::validateInvoiceApplicationsCreditMemoForArrayConstraintsFromSetInvoiceApplicationsCreditMemo($invoiceApplicationsCreditMemo))) {
            throw new \InvalidArgumentException($invoiceApplicationsCreditMemoArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceApplicationsCreditMemo) || (is_array($invoiceApplicationsCreditMemo) && empty($invoiceApplicationsCreditMemo))) {
            unset($this->InvoiceApplicationsCreditMemo);
        } else {
            $this->InvoiceApplicationsCreditMemo = $invoiceApplicationsCreditMemo;
        }
        return $this;
    }
    /**
     * Add item to InvoiceApplicationsCreditMemo value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InvoiceApplicationsCreditMemo $item
     * @return \App\API\SOAP\StructType\ApplicationsCreditMemo
     */
    public function addToInvoiceApplicationsCreditMemo(\App\API\SOAP\StructType\InvoiceApplicationsCreditMemo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\InvoiceApplicationsCreditMemo) {
            throw new \InvalidArgumentException(sprintf('The InvoiceApplicationsCreditMemo property can only contain items of type \App\API\SOAP\StructType\InvoiceApplicationsCreditMemo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceApplicationsCreditMemo[] = $item;
        return $this;
    }
    /**
     * Get SalesInvoiceApplicationCreditMemo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo[]|null
     */
    public function getSalesInvoiceApplicationCreditMemo()
    {
        return isset($this->SalesInvoiceApplicationCreditMemo) ? $this->SalesInvoiceApplicationCreditMemo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesInvoiceApplicationCreditMemo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesInvoiceApplicationCreditMemo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesInvoiceApplicationCreditMemoForArrayConstraintsFromSetSalesInvoiceApplicationCreditMemo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicationsCreditMemoSalesInvoiceApplicationCreditMemoItem) {
            // validation for constraint: itemType
            if (!$applicationsCreditMemoSalesInvoiceApplicationCreditMemoItem instanceof \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo) {
                $invalidValues[] = is_object($applicationsCreditMemoSalesInvoiceApplicationCreditMemoItem) ? get_class($applicationsCreditMemoSalesInvoiceApplicationCreditMemoItem) : sprintf('%s(%s)', gettype($applicationsCreditMemoSalesInvoiceApplicationCreditMemoItem), var_export($applicationsCreditMemoSalesInvoiceApplicationCreditMemoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesInvoiceApplicationCreditMemo property can only contain items of type \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesInvoiceApplicationCreditMemo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo[] $salesInvoiceApplicationCreditMemo
     * @return \App\API\SOAP\StructType\ApplicationsCreditMemo
     */
    public function setSalesInvoiceApplicationCreditMemo(array $salesInvoiceApplicationCreditMemo = array())
    {
        // validation for constraint: array
        if ('' !== ($salesInvoiceApplicationCreditMemoArrayErrorMessage = self::validateSalesInvoiceApplicationCreditMemoForArrayConstraintsFromSetSalesInvoiceApplicationCreditMemo($salesInvoiceApplicationCreditMemo))) {
            throw new \InvalidArgumentException($salesInvoiceApplicationCreditMemoArrayErrorMessage, __LINE__);
        }
        if (is_null($salesInvoiceApplicationCreditMemo) || (is_array($salesInvoiceApplicationCreditMemo) && empty($salesInvoiceApplicationCreditMemo))) {
            unset($this->SalesInvoiceApplicationCreditMemo);
        } else {
            $this->SalesInvoiceApplicationCreditMemo = $salesInvoiceApplicationCreditMemo;
        }
        return $this;
    }
    /**
     * Add item to SalesInvoiceApplicationCreditMemo value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo $item
     * @return \App\API\SOAP\StructType\ApplicationsCreditMemo
     */
    public function addToSalesInvoiceApplicationCreditMemo(\App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo) {
            throw new \InvalidArgumentException(sprintf('The SalesInvoiceApplicationCreditMemo property can only contain items of type \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesInvoiceApplicationCreditMemo[] = $item;
        return $this;
    }
}
