<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Allocations StructType
 * @subpackage Structs
 */
class Allocations extends AbstractStructBase
{
    /**
     * The TransferOrderDetailAllocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TransferOrderDetailAllocation[]
     */
    public $TransferOrderDetailAllocation;
    /**
     * The PurchaseReceiptDetailAllocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\PurchaseReceiptDetailAllocation[]
     */
    public $PurchaseReceiptDetailAllocation;
    /**
     * The KitAssemblyStockComponentAllocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\KitAssemblyStockComponentAllocation[]
     */
    public $KitAssemblyStockComponentAllocation;
    /**
     * The ShipmentDetailAllocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShipmentDetailAllocation[]
     */
    public $ShipmentDetailAllocation;
    /**
     * The KitAssemblyAllocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\KitAssemblyAllocation[]
     */
    public $KitAssemblyAllocation;
    /**
     * The SalesOrderDetailAllocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SalesOrderDetailAllocation[]
     */
    public $SalesOrderDetailAllocation;
    /**
     * The InventoryReceiptDetailAllocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\InventoryReceiptDetailAllocation[]
     */
    public $InventoryReceiptDetailAllocation;
    /**
     * Constructor method for Allocations
     * @uses Allocations::setTransferOrderDetailAllocation()
     * @uses Allocations::setPurchaseReceiptDetailAllocation()
     * @uses Allocations::setKitAssemblyStockComponentAllocation()
     * @uses Allocations::setShipmentDetailAllocation()
     * @uses Allocations::setKitAssemblyAllocation()
     * @uses Allocations::setSalesOrderDetailAllocation()
     * @uses Allocations::setInventoryReceiptDetailAllocation()
     * @param \App\API\SOAP\StructType\TransferOrderDetailAllocation[] $transferOrderDetailAllocation
     * @param \App\API\SOAP\StructType\PurchaseReceiptDetailAllocation[] $purchaseReceiptDetailAllocation
     * @param \App\API\SOAP\StructType\KitAssemblyStockComponentAllocation[] $kitAssemblyStockComponentAllocation
     * @param \App\API\SOAP\StructType\ShipmentDetailAllocation[] $shipmentDetailAllocation
     * @param \App\API\SOAP\StructType\KitAssemblyAllocation[] $kitAssemblyAllocation
     * @param \App\API\SOAP\StructType\SalesOrderDetailAllocation[] $salesOrderDetailAllocation
     * @param \App\API\SOAP\StructType\InventoryReceiptDetailAllocation[] $inventoryReceiptDetailAllocation
     */
    public function __construct(array $transferOrderDetailAllocation = array(), array $purchaseReceiptDetailAllocation = array(), array $kitAssemblyStockComponentAllocation = array(), array $shipmentDetailAllocation = array(), array $kitAssemblyAllocation = array(), array $salesOrderDetailAllocation = array(), array $inventoryReceiptDetailAllocation = array())
    {
        $this
            ->setTransferOrderDetailAllocation($transferOrderDetailAllocation)
            ->setPurchaseReceiptDetailAllocation($purchaseReceiptDetailAllocation)
            ->setKitAssemblyStockComponentAllocation($kitAssemblyStockComponentAllocation)
            ->setShipmentDetailAllocation($shipmentDetailAllocation)
            ->setKitAssemblyAllocation($kitAssemblyAllocation)
            ->setSalesOrderDetailAllocation($salesOrderDetailAllocation)
            ->setInventoryReceiptDetailAllocation($inventoryReceiptDetailAllocation);
    }
    /**
     * Get TransferOrderDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TransferOrderDetailAllocation[]|null
     */
    public function getTransferOrderDetailAllocation()
    {
        return isset($this->TransferOrderDetailAllocation) ? $this->TransferOrderDetailAllocation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTransferOrderDetailAllocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransferOrderDetailAllocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransferOrderDetailAllocationForArrayConstraintsFromSetTransferOrderDetailAllocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $allocationsTransferOrderDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsTransferOrderDetailAllocationItem instanceof \App\API\SOAP\StructType\TransferOrderDetailAllocation) {
                $invalidValues[] = is_object($allocationsTransferOrderDetailAllocationItem) ? get_class($allocationsTransferOrderDetailAllocationItem) : sprintf('%s(%s)', gettype($allocationsTransferOrderDetailAllocationItem), var_export($allocationsTransferOrderDetailAllocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransferOrderDetailAllocation property can only contain items of type \App\API\SOAP\StructType\TransferOrderDetailAllocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransferOrderDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\TransferOrderDetailAllocation[] $transferOrderDetailAllocation
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function setTransferOrderDetailAllocation(array $transferOrderDetailAllocation = array())
    {
        // validation for constraint: array
        if ('' !== ($transferOrderDetailAllocationArrayErrorMessage = self::validateTransferOrderDetailAllocationForArrayConstraintsFromSetTransferOrderDetailAllocation($transferOrderDetailAllocation))) {
            throw new \InvalidArgumentException($transferOrderDetailAllocationArrayErrorMessage, __LINE__);
        }
        if (is_null($transferOrderDetailAllocation) || (is_array($transferOrderDetailAllocation) && empty($transferOrderDetailAllocation))) {
            unset($this->TransferOrderDetailAllocation);
        } else {
            $this->TransferOrderDetailAllocation = $transferOrderDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to TransferOrderDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\TransferOrderDetailAllocation $item
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function addToTransferOrderDetailAllocation(\App\API\SOAP\StructType\TransferOrderDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\TransferOrderDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The TransferOrderDetailAllocation property can only contain items of type \App\API\SOAP\StructType\TransferOrderDetailAllocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransferOrderDetailAllocation[] = $item;
        return $this;
    }
    /**
     * Get PurchaseReceiptDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\PurchaseReceiptDetailAllocation[]|null
     */
    public function getPurchaseReceiptDetailAllocation()
    {
        return isset($this->PurchaseReceiptDetailAllocation) ? $this->PurchaseReceiptDetailAllocation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchaseReceiptDetailAllocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchaseReceiptDetailAllocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchaseReceiptDetailAllocationForArrayConstraintsFromSetPurchaseReceiptDetailAllocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $allocationsPurchaseReceiptDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsPurchaseReceiptDetailAllocationItem instanceof \App\API\SOAP\StructType\PurchaseReceiptDetailAllocation) {
                $invalidValues[] = is_object($allocationsPurchaseReceiptDetailAllocationItem) ? get_class($allocationsPurchaseReceiptDetailAllocationItem) : sprintf('%s(%s)', gettype($allocationsPurchaseReceiptDetailAllocationItem), var_export($allocationsPurchaseReceiptDetailAllocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PurchaseReceiptDetailAllocation property can only contain items of type \App\API\SOAP\StructType\PurchaseReceiptDetailAllocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PurchaseReceiptDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PurchaseReceiptDetailAllocation[] $purchaseReceiptDetailAllocation
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function setPurchaseReceiptDetailAllocation(array $purchaseReceiptDetailAllocation = array())
    {
        // validation for constraint: array
        if ('' !== ($purchaseReceiptDetailAllocationArrayErrorMessage = self::validatePurchaseReceiptDetailAllocationForArrayConstraintsFromSetPurchaseReceiptDetailAllocation($purchaseReceiptDetailAllocation))) {
            throw new \InvalidArgumentException($purchaseReceiptDetailAllocationArrayErrorMessage, __LINE__);
        }
        if (is_null($purchaseReceiptDetailAllocation) || (is_array($purchaseReceiptDetailAllocation) && empty($purchaseReceiptDetailAllocation))) {
            unset($this->PurchaseReceiptDetailAllocation);
        } else {
            $this->PurchaseReceiptDetailAllocation = $purchaseReceiptDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to PurchaseReceiptDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PurchaseReceiptDetailAllocation $item
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function addToPurchaseReceiptDetailAllocation(\App\API\SOAP\StructType\PurchaseReceiptDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\PurchaseReceiptDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The PurchaseReceiptDetailAllocation property can only contain items of type \App\API\SOAP\StructType\PurchaseReceiptDetailAllocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PurchaseReceiptDetailAllocation[] = $item;
        return $this;
    }
    /**
     * Get KitAssemblyStockComponentAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\KitAssemblyStockComponentAllocation[]|null
     */
    public function getKitAssemblyStockComponentAllocation()
    {
        return isset($this->KitAssemblyStockComponentAllocation) ? $this->KitAssemblyStockComponentAllocation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKitAssemblyStockComponentAllocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKitAssemblyStockComponentAllocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKitAssemblyStockComponentAllocationForArrayConstraintsFromSetKitAssemblyStockComponentAllocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $allocationsKitAssemblyStockComponentAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsKitAssemblyStockComponentAllocationItem instanceof \App\API\SOAP\StructType\KitAssemblyStockComponentAllocation) {
                $invalidValues[] = is_object($allocationsKitAssemblyStockComponentAllocationItem) ? get_class($allocationsKitAssemblyStockComponentAllocationItem) : sprintf('%s(%s)', gettype($allocationsKitAssemblyStockComponentAllocationItem), var_export($allocationsKitAssemblyStockComponentAllocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KitAssemblyStockComponentAllocation property can only contain items of type \App\API\SOAP\StructType\KitAssemblyStockComponentAllocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KitAssemblyStockComponentAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\KitAssemblyStockComponentAllocation[] $kitAssemblyStockComponentAllocation
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function setKitAssemblyStockComponentAllocation(array $kitAssemblyStockComponentAllocation = array())
    {
        // validation for constraint: array
        if ('' !== ($kitAssemblyStockComponentAllocationArrayErrorMessage = self::validateKitAssemblyStockComponentAllocationForArrayConstraintsFromSetKitAssemblyStockComponentAllocation($kitAssemblyStockComponentAllocation))) {
            throw new \InvalidArgumentException($kitAssemblyStockComponentAllocationArrayErrorMessage, __LINE__);
        }
        if (is_null($kitAssemblyStockComponentAllocation) || (is_array($kitAssemblyStockComponentAllocation) && empty($kitAssemblyStockComponentAllocation))) {
            unset($this->KitAssemblyStockComponentAllocation);
        } else {
            $this->KitAssemblyStockComponentAllocation = $kitAssemblyStockComponentAllocation;
        }
        return $this;
    }
    /**
     * Add item to KitAssemblyStockComponentAllocation value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\KitAssemblyStockComponentAllocation $item
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function addToKitAssemblyStockComponentAllocation(\App\API\SOAP\StructType\KitAssemblyStockComponentAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\KitAssemblyStockComponentAllocation) {
            throw new \InvalidArgumentException(sprintf('The KitAssemblyStockComponentAllocation property can only contain items of type \App\API\SOAP\StructType\KitAssemblyStockComponentAllocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KitAssemblyStockComponentAllocation[] = $item;
        return $this;
    }
    /**
     * Get ShipmentDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShipmentDetailAllocation[]|null
     */
    public function getShipmentDetailAllocation()
    {
        return isset($this->ShipmentDetailAllocation) ? $this->ShipmentDetailAllocation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentDetailAllocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentDetailAllocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentDetailAllocationForArrayConstraintsFromSetShipmentDetailAllocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $allocationsShipmentDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsShipmentDetailAllocationItem instanceof \App\API\SOAP\StructType\ShipmentDetailAllocation) {
                $invalidValues[] = is_object($allocationsShipmentDetailAllocationItem) ? get_class($allocationsShipmentDetailAllocationItem) : sprintf('%s(%s)', gettype($allocationsShipmentDetailAllocationItem), var_export($allocationsShipmentDetailAllocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentDetailAllocation property can only contain items of type \App\API\SOAP\StructType\ShipmentDetailAllocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ShipmentDetailAllocation[] $shipmentDetailAllocation
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function setShipmentDetailAllocation(array $shipmentDetailAllocation = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentDetailAllocationArrayErrorMessage = self::validateShipmentDetailAllocationForArrayConstraintsFromSetShipmentDetailAllocation($shipmentDetailAllocation))) {
            throw new \InvalidArgumentException($shipmentDetailAllocationArrayErrorMessage, __LINE__);
        }
        if (is_null($shipmentDetailAllocation) || (is_array($shipmentDetailAllocation) && empty($shipmentDetailAllocation))) {
            unset($this->ShipmentDetailAllocation);
        } else {
            $this->ShipmentDetailAllocation = $shipmentDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to ShipmentDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ShipmentDetailAllocation $item
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function addToShipmentDetailAllocation(\App\API\SOAP\StructType\ShipmentDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ShipmentDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The ShipmentDetailAllocation property can only contain items of type \App\API\SOAP\StructType\ShipmentDetailAllocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentDetailAllocation[] = $item;
        return $this;
    }
    /**
     * Get KitAssemblyAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\KitAssemblyAllocation[]|null
     */
    public function getKitAssemblyAllocation()
    {
        return isset($this->KitAssemblyAllocation) ? $this->KitAssemblyAllocation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKitAssemblyAllocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKitAssemblyAllocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKitAssemblyAllocationForArrayConstraintsFromSetKitAssemblyAllocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $allocationsKitAssemblyAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsKitAssemblyAllocationItem instanceof \App\API\SOAP\StructType\KitAssemblyAllocation) {
                $invalidValues[] = is_object($allocationsKitAssemblyAllocationItem) ? get_class($allocationsKitAssemblyAllocationItem) : sprintf('%s(%s)', gettype($allocationsKitAssemblyAllocationItem), var_export($allocationsKitAssemblyAllocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KitAssemblyAllocation property can only contain items of type \App\API\SOAP\StructType\KitAssemblyAllocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KitAssemblyAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\KitAssemblyAllocation[] $kitAssemblyAllocation
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function setKitAssemblyAllocation(array $kitAssemblyAllocation = array())
    {
        // validation for constraint: array
        if ('' !== ($kitAssemblyAllocationArrayErrorMessage = self::validateKitAssemblyAllocationForArrayConstraintsFromSetKitAssemblyAllocation($kitAssemblyAllocation))) {
            throw new \InvalidArgumentException($kitAssemblyAllocationArrayErrorMessage, __LINE__);
        }
        if (is_null($kitAssemblyAllocation) || (is_array($kitAssemblyAllocation) && empty($kitAssemblyAllocation))) {
            unset($this->KitAssemblyAllocation);
        } else {
            $this->KitAssemblyAllocation = $kitAssemblyAllocation;
        }
        return $this;
    }
    /**
     * Add item to KitAssemblyAllocation value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\KitAssemblyAllocation $item
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function addToKitAssemblyAllocation(\App\API\SOAP\StructType\KitAssemblyAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\KitAssemblyAllocation) {
            throw new \InvalidArgumentException(sprintf('The KitAssemblyAllocation property can only contain items of type \App\API\SOAP\StructType\KitAssemblyAllocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KitAssemblyAllocation[] = $item;
        return $this;
    }
    /**
     * Get SalesOrderDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation[]|null
     */
    public function getSalesOrderDetailAllocation()
    {
        return isset($this->SalesOrderDetailAllocation) ? $this->SalesOrderDetailAllocation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesOrderDetailAllocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesOrderDetailAllocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesOrderDetailAllocationForArrayConstraintsFromSetSalesOrderDetailAllocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $allocationsSalesOrderDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsSalesOrderDetailAllocationItem instanceof \App\API\SOAP\StructType\SalesOrderDetailAllocation) {
                $invalidValues[] = is_object($allocationsSalesOrderDetailAllocationItem) ? get_class($allocationsSalesOrderDetailAllocationItem) : sprintf('%s(%s)', gettype($allocationsSalesOrderDetailAllocationItem), var_export($allocationsSalesOrderDetailAllocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesOrderDetailAllocation property can only contain items of type \App\API\SOAP\StructType\SalesOrderDetailAllocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesOrderDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesOrderDetailAllocation[] $salesOrderDetailAllocation
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function setSalesOrderDetailAllocation(array $salesOrderDetailAllocation = array())
    {
        // validation for constraint: array
        if ('' !== ($salesOrderDetailAllocationArrayErrorMessage = self::validateSalesOrderDetailAllocationForArrayConstraintsFromSetSalesOrderDetailAllocation($salesOrderDetailAllocation))) {
            throw new \InvalidArgumentException($salesOrderDetailAllocationArrayErrorMessage, __LINE__);
        }
        if (is_null($salesOrderDetailAllocation) || (is_array($salesOrderDetailAllocation) && empty($salesOrderDetailAllocation))) {
            unset($this->SalesOrderDetailAllocation);
        } else {
            $this->SalesOrderDetailAllocation = $salesOrderDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to SalesOrderDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesOrderDetailAllocation $item
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function addToSalesOrderDetailAllocation(\App\API\SOAP\StructType\SalesOrderDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\SalesOrderDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The SalesOrderDetailAllocation property can only contain items of type \App\API\SOAP\StructType\SalesOrderDetailAllocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesOrderDetailAllocation[] = $item;
        return $this;
    }
    /**
     * Get InventoryReceiptDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\InventoryReceiptDetailAllocation[]|null
     */
    public function getInventoryReceiptDetailAllocation()
    {
        return isset($this->InventoryReceiptDetailAllocation) ? $this->InventoryReceiptDetailAllocation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInventoryReceiptDetailAllocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventoryReceiptDetailAllocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryReceiptDetailAllocationForArrayConstraintsFromSetInventoryReceiptDetailAllocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $allocationsInventoryReceiptDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsInventoryReceiptDetailAllocationItem instanceof \App\API\SOAP\StructType\InventoryReceiptDetailAllocation) {
                $invalidValues[] = is_object($allocationsInventoryReceiptDetailAllocationItem) ? get_class($allocationsInventoryReceiptDetailAllocationItem) : sprintf('%s(%s)', gettype($allocationsInventoryReceiptDetailAllocationItem), var_export($allocationsInventoryReceiptDetailAllocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InventoryReceiptDetailAllocation property can only contain items of type \App\API\SOAP\StructType\InventoryReceiptDetailAllocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InventoryReceiptDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InventoryReceiptDetailAllocation[] $inventoryReceiptDetailAllocation
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function setInventoryReceiptDetailAllocation(array $inventoryReceiptDetailAllocation = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryReceiptDetailAllocationArrayErrorMessage = self::validateInventoryReceiptDetailAllocationForArrayConstraintsFromSetInventoryReceiptDetailAllocation($inventoryReceiptDetailAllocation))) {
            throw new \InvalidArgumentException($inventoryReceiptDetailAllocationArrayErrorMessage, __LINE__);
        }
        if (is_null($inventoryReceiptDetailAllocation) || (is_array($inventoryReceiptDetailAllocation) && empty($inventoryReceiptDetailAllocation))) {
            unset($this->InventoryReceiptDetailAllocation);
        } else {
            $this->InventoryReceiptDetailAllocation = $inventoryReceiptDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to InventoryReceiptDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InventoryReceiptDetailAllocation $item
     * @return \App\API\SOAP\StructType\Allocations
     */
    public function addToInventoryReceiptDetailAllocation(\App\API\SOAP\StructType\InventoryReceiptDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\InventoryReceiptDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The InventoryReceiptDetailAllocation property can only contain items of type \App\API\SOAP\StructType\InventoryReceiptDetailAllocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InventoryReceiptDetailAllocation[] = $item;
        return $this;
    }
}
