<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllocationRule StructType
 * @subpackage Structs
 */
class AllocationRule extends Entity
{
    /**
     * The AllocationRuleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AllocationRuleID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * Constructor method for AllocationRule
     * @uses AllocationRule::setAllocationRuleID()
     * @uses AllocationRule::setDescription()
     * @param \App\API\SOAP\StructType\StringValue $allocationRuleID
     * @param \App\API\SOAP\StructType\StringValue $description
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $allocationRuleID = null, \App\API\SOAP\StructType\StringValue $description = null)
    {
        $this
            ->setAllocationRuleID($allocationRuleID)
            ->setDescription($description);
    }
    /**
     * Get AllocationRuleID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAllocationRuleID()
    {
        return isset($this->AllocationRuleID) ? $this->AllocationRuleID : null;
    }
    /**
     * Set AllocationRuleID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $allocationRuleID
     * @return \App\API\SOAP\StructType\AllocationRule
     */
    public function setAllocationRuleID(\App\API\SOAP\StructType\StringValue $allocationRuleID = null)
    {
        if (is_null($allocationRuleID) || (is_array($allocationRuleID) && empty($allocationRuleID))) {
            unset($this->AllocationRuleID);
        } else {
            $this->AllocationRuleID = $allocationRuleID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\AllocationRule
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
}
