<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityHistory StructType
 * @subpackage Structs
 */
class ActivityHistory extends AbstractStructBase
{
    /**
     * The ProjectActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ProjectActivity[]
     */
    public $ProjectActivity;
    /**
     * Constructor method for ActivityHistory
     * @uses ActivityHistory::setProjectActivity()
     * @param \App\API\SOAP\StructType\ProjectActivity[] $projectActivity
     */
    public function __construct(array $projectActivity = array())
    {
        $this
            ->setProjectActivity($projectActivity);
    }
    /**
     * Get ProjectActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ProjectActivity[]|null
     */
    public function getProjectActivity()
    {
        return isset($this->ProjectActivity) ? $this->ProjectActivity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectActivity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectActivity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectActivityForArrayConstraintsFromSetProjectActivity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activityHistoryProjectActivityItem) {
            // validation for constraint: itemType
            if (!$activityHistoryProjectActivityItem instanceof \App\API\SOAP\StructType\ProjectActivity) {
                $invalidValues[] = is_object($activityHistoryProjectActivityItem) ? get_class($activityHistoryProjectActivityItem) : sprintf('%s(%s)', gettype($activityHistoryProjectActivityItem), var_export($activityHistoryProjectActivityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProjectActivity property can only contain items of type \App\API\SOAP\StructType\ProjectActivity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProjectActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ProjectActivity[] $projectActivity
     * @return \App\API\SOAP\StructType\ActivityHistory
     */
    public function setProjectActivity(array $projectActivity = array())
    {
        // validation for constraint: array
        if ('' !== ($projectActivityArrayErrorMessage = self::validateProjectActivityForArrayConstraintsFromSetProjectActivity($projectActivity))) {
            throw new \InvalidArgumentException($projectActivityArrayErrorMessage, __LINE__);
        }
        if (is_null($projectActivity) || (is_array($projectActivity) && empty($projectActivity))) {
            unset($this->ProjectActivity);
        } else {
            $this->ProjectActivity = $projectActivity;
        }
        return $this;
    }
    /**
     * Add item to ProjectActivity value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ProjectActivity $item
     * @return \App\API\SOAP\StructType\ActivityHistory
     */
    public function addToProjectActivity(\App\API\SOAP\StructType\ProjectActivity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ProjectActivity) {
            throw new \InvalidArgumentException(sprintf('The ProjectActivity property can only contain items of type \App\API\SOAP\StructType\ProjectActivity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProjectActivity[] = $item;
        return $this;
    }
}
