<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Activity StructType
 * @subpackage Structs
 */
class Activity extends Entity
{
    /**
     * The Body
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Body;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Internal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Internal;
    /**
     * The NoteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\GuidValue
     */
    public $NoteID;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Owner;
    /**
     * The RelatedEntityDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $RelatedEntityDescription;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Summary;
    /**
     * The Task
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Task;
    /**
     * The TimeActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TimeActivity
     */
    public $TimeActivity;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Type;
    /**
     * The Workgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Workgroup;
    /**
     * Constructor method for Activity
     * @uses Activity::setBody()
     * @uses Activity::setDate()
     * @uses Activity::setInternal()
     * @uses Activity::setNoteID()
     * @uses Activity::setOwner()
     * @uses Activity::setRelatedEntityDescription()
     * @uses Activity::setStatus()
     * @uses Activity::setSummary()
     * @uses Activity::setTask()
     * @uses Activity::setTimeActivity()
     * @uses Activity::setType()
     * @uses Activity::setWorkgroup()
     * @param \App\API\SOAP\StructType\StringValue $body
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @param \App\API\SOAP\StructType\BooleanValue $internal
     * @param \App\API\SOAP\StructType\GuidValue $noteID
     * @param \App\API\SOAP\StructType\StringValue $owner
     * @param \App\API\SOAP\StructType\StringValue $relatedEntityDescription
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\StringValue $summary
     * @param \App\API\SOAP\StructType\StringValue $task
     * @param \App\API\SOAP\StructType\TimeActivity $timeActivity
     * @param \App\API\SOAP\StructType\StringValue $type
     * @param \App\API\SOAP\StructType\StringValue $workgroup
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $body = null, \App\API\SOAP\StructType\DateTimeValue $date = null, \App\API\SOAP\StructType\BooleanValue $internal = null, \App\API\SOAP\StructType\GuidValue $noteID = null, \App\API\SOAP\StructType\StringValue $owner = null, \App\API\SOAP\StructType\StringValue $relatedEntityDescription = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\StringValue $summary = null, \App\API\SOAP\StructType\StringValue $task = null, \App\API\SOAP\StructType\TimeActivity $timeActivity = null, \App\API\SOAP\StructType\StringValue $type = null, \App\API\SOAP\StructType\StringValue $workgroup = null)
    {
        $this
            ->setBody($body)
            ->setDate($date)
            ->setInternal($internal)
            ->setNoteID($noteID)
            ->setOwner($owner)
            ->setRelatedEntityDescription($relatedEntityDescription)
            ->setStatus($status)
            ->setSummary($summary)
            ->setTask($task)
            ->setTimeActivity($timeActivity)
            ->setType($type)
            ->setWorkgroup($workgroup);
    }
    /**
     * Get Body value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBody()
    {
        return isset($this->Body) ? $this->Body : null;
    }
    /**
     * Set Body value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $body
     * @return \App\API\SOAP\StructType\Activity
     */
    public function setBody(\App\API\SOAP\StructType\StringValue $body = null)
    {
        if (is_null($body) || (is_array($body) && empty($body))) {
            unset($this->Body);
        } else {
            $this->Body = $body;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @return \App\API\SOAP\StructType\Activity
     */
    public function setDate(\App\API\SOAP\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Internal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getInternal()
    {
        return isset($this->Internal) ? $this->Internal : null;
    }
    /**
     * Set Internal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $internal
     * @return \App\API\SOAP\StructType\Activity
     */
    public function setInternal(\App\API\SOAP\StructType\BooleanValue $internal = null)
    {
        if (is_null($internal) || (is_array($internal) && empty($internal))) {
            unset($this->Internal);
        } else {
            $this->Internal = $internal;
        }
        return $this;
    }
    /**
     * Get NoteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\GuidValue|null
     */
    public function getNoteID()
    {
        return isset($this->NoteID) ? $this->NoteID : null;
    }
    /**
     * Set NoteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\GuidValue $noteID
     * @return \App\API\SOAP\StructType\Activity
     */
    public function setNoteID(\App\API\SOAP\StructType\GuidValue $noteID = null)
    {
        if (is_null($noteID) || (is_array($noteID) && empty($noteID))) {
            unset($this->NoteID);
        } else {
            $this->NoteID = $noteID;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $owner
     * @return \App\API\SOAP\StructType\Activity
     */
    public function setOwner(\App\API\SOAP\StructType\StringValue $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get RelatedEntityDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getRelatedEntityDescription()
    {
        return isset($this->RelatedEntityDescription) ? $this->RelatedEntityDescription : null;
    }
    /**
     * Set RelatedEntityDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $relatedEntityDescription
     * @return \App\API\SOAP\StructType\Activity
     */
    public function setRelatedEntityDescription(\App\API\SOAP\StructType\StringValue $relatedEntityDescription = null)
    {
        if (is_null($relatedEntityDescription) || (is_array($relatedEntityDescription) && empty($relatedEntityDescription))) {
            unset($this->RelatedEntityDescription);
        } else {
            $this->RelatedEntityDescription = $relatedEntityDescription;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\Activity
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Summary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSummary()
    {
        return isset($this->Summary) ? $this->Summary : null;
    }
    /**
     * Set Summary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $summary
     * @return \App\API\SOAP\StructType\Activity
     */
    public function setSummary(\App\API\SOAP\StructType\StringValue $summary = null)
    {
        if (is_null($summary) || (is_array($summary) && empty($summary))) {
            unset($this->Summary);
        } else {
            $this->Summary = $summary;
        }
        return $this;
    }
    /**
     * Get Task value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTask()
    {
        return isset($this->Task) ? $this->Task : null;
    }
    /**
     * Set Task value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $task
     * @return \App\API\SOAP\StructType\Activity
     */
    public function setTask(\App\API\SOAP\StructType\StringValue $task = null)
    {
        if (is_null($task) || (is_array($task) && empty($task))) {
            unset($this->Task);
        } else {
            $this->Task = $task;
        }
        return $this;
    }
    /**
     * Get TimeActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TimeActivity|null
     */
    public function getTimeActivity()
    {
        return isset($this->TimeActivity) ? $this->TimeActivity : null;
    }
    /**
     * Set TimeActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\TimeActivity $timeActivity
     * @return \App\API\SOAP\StructType\Activity
     */
    public function setTimeActivity(\App\API\SOAP\StructType\TimeActivity $timeActivity = null)
    {
        if (is_null($timeActivity) || (is_array($timeActivity) && empty($timeActivity))) {
            unset($this->TimeActivity);
        } else {
            $this->TimeActivity = $timeActivity;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $type
     * @return \App\API\SOAP\StructType\Activity
     */
    public function setType(\App\API\SOAP\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get Workgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWorkgroup()
    {
        return isset($this->Workgroup) ? $this->Workgroup : null;
    }
    /**
     * Set Workgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $workgroup
     * @return \App\API\SOAP\StructType\Activity
     */
    public function setWorkgroup(\App\API\SOAP\StructType\StringValue $workgroup = null)
    {
        if (is_null($workgroup) || (is_array($workgroup) && empty($workgroup))) {
            unset($this->Workgroup);
        } else {
            $this->Workgroup = $workgroup;
        }
        return $this;
    }
}
