<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountGroup StructType
 * @subpackage Structs
 */
class AccountGroup extends Entity
{
    /**
     * The AccountGroupID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AccountGroupID;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Active;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Attributes
     */
    public $Attributes;
    /**
     * The DefaultAccountID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DefaultAccountID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The Expense
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Expense;
    /**
     * The SortOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShortValue
     */
    public $SortOrder;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for AccountGroup
     * @uses AccountGroup::setAccountGroupID()
     * @uses AccountGroup::setActive()
     * @uses AccountGroup::setAttributes()
     * @uses AccountGroup::setDefaultAccountID()
     * @uses AccountGroup::setDescription()
     * @uses AccountGroup::setExpense()
     * @uses AccountGroup::setSortOrder()
     * @uses AccountGroup::setType()
     * @param \App\API\SOAP\StructType\StringValue $accountGroupID
     * @param \App\API\SOAP\StructType\BooleanValue $active
     * @param \App\API\SOAP\StructType\Attributes $attributes
     * @param \App\API\SOAP\StructType\StringValue $defaultAccountID
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\BooleanValue $expense
     * @param \App\API\SOAP\StructType\ShortValue $sortOrder
     * @param \App\API\SOAP\StructType\StringValue $type
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $accountGroupID = null, \App\API\SOAP\StructType\BooleanValue $active = null, \App\API\SOAP\StructType\Attributes $attributes = null, \App\API\SOAP\StructType\StringValue $defaultAccountID = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\BooleanValue $expense = null, \App\API\SOAP\StructType\ShortValue $sortOrder = null, \App\API\SOAP\StructType\StringValue $type = null)
    {
        $this
            ->setAccountGroupID($accountGroupID)
            ->setActive($active)
            ->setAttributes($attributes)
            ->setDefaultAccountID($defaultAccountID)
            ->setDescription($description)
            ->setExpense($expense)
            ->setSortOrder($sortOrder)
            ->setType($type);
    }
    /**
     * Get AccountGroupID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccountGroupID()
    {
        return isset($this->AccountGroupID) ? $this->AccountGroupID : null;
    }
    /**
     * Set AccountGroupID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $accountGroupID
     * @return \App\API\SOAP\StructType\AccountGroup
     */
    public function setAccountGroupID(\App\API\SOAP\StructType\StringValue $accountGroupID = null)
    {
        if (is_null($accountGroupID) || (is_array($accountGroupID) && empty($accountGroupID))) {
            unset($this->AccountGroupID);
        } else {
            $this->AccountGroupID = $accountGroupID;
        }
        return $this;
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $active
     * @return \App\API\SOAP\StructType\AccountGroup
     */
    public function setActive(\App\API\SOAP\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Attributes $attributes
     * @return \App\API\SOAP\StructType\AccountGroup
     */
    public function setAttributes(\App\API\SOAP\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get DefaultAccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDefaultAccountID()
    {
        return isset($this->DefaultAccountID) ? $this->DefaultAccountID : null;
    }
    /**
     * Set DefaultAccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $defaultAccountID
     * @return \App\API\SOAP\StructType\AccountGroup
     */
    public function setDefaultAccountID(\App\API\SOAP\StructType\StringValue $defaultAccountID = null)
    {
        if (is_null($defaultAccountID) || (is_array($defaultAccountID) && empty($defaultAccountID))) {
            unset($this->DefaultAccountID);
        } else {
            $this->DefaultAccountID = $defaultAccountID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\AccountGroup
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Expense value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getExpense()
    {
        return isset($this->Expense) ? $this->Expense : null;
    }
    /**
     * Set Expense value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $expense
     * @return \App\API\SOAP\StructType\AccountGroup
     */
    public function setExpense(\App\API\SOAP\StructType\BooleanValue $expense = null)
    {
        if (is_null($expense) || (is_array($expense) && empty($expense))) {
            unset($this->Expense);
        } else {
            $this->Expense = $expense;
        }
        return $this;
    }
    /**
     * Get SortOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShortValue|null
     */
    public function getSortOrder()
    {
        return isset($this->SortOrder) ? $this->SortOrder : null;
    }
    /**
     * Set SortOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ShortValue $sortOrder
     * @return \App\API\SOAP\StructType\AccountGroup
     */
    public function setSortOrder(\App\API\SOAP\StructType\ShortValue $sortOrder = null)
    {
        if (is_null($sortOrder) || (is_array($sortOrder) && empty($sortOrder))) {
            unset($this->SortOrder);
        } else {
            $this->SortOrder = $sortOrder;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $type
     * @return \App\API\SOAP\StructType\AccountGroup
     */
    public function setType(\App\API\SOAP\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
