<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDetailsRow StructType
 * @subpackage Structs
 */
class AccountDetailsRow extends Entity
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Account;
    /**
     * The BatchNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BatchNbr;
    /**
     * The BeginingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $BeginingBalance;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Branch;
    /**
     * The CreditAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CreditAmount;
    /**
     * The CurrencyBeginingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CurrencyBeginingBalance;
    /**
     * The CurrencyCreditAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CurrencyCreditAmount;
    /**
     * The CurrencyDebitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CurrencyDebitAmount;
    /**
     * The CurrencyEndingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CurrencyEndingBalance;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The DebitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $DebitAmount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The EndingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $EndingBalance;
    /**
     * The IncludedinReclassHistory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IncludedinReclassHistory;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $LineNbr;
    /**
     * The Module
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Module;
    /**
     * The Period
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Period;
    /**
     * The ReclassBatchNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReclassBatchNbr;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Selected
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Selected;
    /**
     * The Subaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Subaccount;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $TransactionDate;
    /**
     * The VendorOrCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $VendorOrCustomer;
    /**
     * Constructor method for AccountDetailsRow
     * @uses AccountDetailsRow::setAccount()
     * @uses AccountDetailsRow::setBatchNbr()
     * @uses AccountDetailsRow::setBeginingBalance()
     * @uses AccountDetailsRow::setBranch()
     * @uses AccountDetailsRow::setCreditAmount()
     * @uses AccountDetailsRow::setCurrencyBeginingBalance()
     * @uses AccountDetailsRow::setCurrencyCreditAmount()
     * @uses AccountDetailsRow::setCurrencyDebitAmount()
     * @uses AccountDetailsRow::setCurrencyEndingBalance()
     * @uses AccountDetailsRow::setCurrencyID()
     * @uses AccountDetailsRow::setDebitAmount()
     * @uses AccountDetailsRow::setDescription()
     * @uses AccountDetailsRow::setEndingBalance()
     * @uses AccountDetailsRow::setIncludedinReclassHistory()
     * @uses AccountDetailsRow::setInventoryID()
     * @uses AccountDetailsRow::setLineNbr()
     * @uses AccountDetailsRow::setModule()
     * @uses AccountDetailsRow::setPeriod()
     * @uses AccountDetailsRow::setReclassBatchNbr()
     * @uses AccountDetailsRow::setReferenceNbr()
     * @uses AccountDetailsRow::setSelected()
     * @uses AccountDetailsRow::setSubaccount()
     * @uses AccountDetailsRow::setTransactionDate()
     * @uses AccountDetailsRow::setVendorOrCustomer()
     * @param \App\API\SOAP\StructType\StringValue $account
     * @param \App\API\SOAP\StructType\StringValue $batchNbr
     * @param \App\API\SOAP\StructType\DecimalValue $beginingBalance
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @param \App\API\SOAP\StructType\DecimalValue $creditAmount
     * @param \App\API\SOAP\StructType\DecimalValue $currencyBeginingBalance
     * @param \App\API\SOAP\StructType\DecimalValue $currencyCreditAmount
     * @param \App\API\SOAP\StructType\DecimalValue $currencyDebitAmount
     * @param \App\API\SOAP\StructType\DecimalValue $currencyEndingBalance
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @param \App\API\SOAP\StructType\DecimalValue $debitAmount
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\DecimalValue $endingBalance
     * @param \App\API\SOAP\StructType\BooleanValue $includedinReclassHistory
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\IntValue $lineNbr
     * @param \App\API\SOAP\StructType\StringValue $module
     * @param \App\API\SOAP\StructType\StringValue $period
     * @param \App\API\SOAP\StructType\StringValue $reclassBatchNbr
     * @param \App\API\SOAP\StructType\StringValue $referenceNbr
     * @param \App\API\SOAP\StructType\BooleanValue $selected
     * @param \App\API\SOAP\StructType\StringValue $subaccount
     * @param \App\API\SOAP\StructType\DateTimeValue $transactionDate
     * @param \App\API\SOAP\StructType\StringValue $vendorOrCustomer
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $account = null, \App\API\SOAP\StructType\StringValue $batchNbr = null, \App\API\SOAP\StructType\DecimalValue $beginingBalance = null, \App\API\SOAP\StructType\StringValue $branch = null, \App\API\SOAP\StructType\DecimalValue $creditAmount = null, \App\API\SOAP\StructType\DecimalValue $currencyBeginingBalance = null, \App\API\SOAP\StructType\DecimalValue $currencyCreditAmount = null, \App\API\SOAP\StructType\DecimalValue $currencyDebitAmount = null, \App\API\SOAP\StructType\DecimalValue $currencyEndingBalance = null, \App\API\SOAP\StructType\StringValue $currencyID = null, \App\API\SOAP\StructType\DecimalValue $debitAmount = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\DecimalValue $endingBalance = null, \App\API\SOAP\StructType\BooleanValue $includedinReclassHistory = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\IntValue $lineNbr = null, \App\API\SOAP\StructType\StringValue $module = null, \App\API\SOAP\StructType\StringValue $period = null, \App\API\SOAP\StructType\StringValue $reclassBatchNbr = null, \App\API\SOAP\StructType\StringValue $referenceNbr = null, \App\API\SOAP\StructType\BooleanValue $selected = null, \App\API\SOAP\StructType\StringValue $subaccount = null, \App\API\SOAP\StructType\DateTimeValue $transactionDate = null, \App\API\SOAP\StructType\StringValue $vendorOrCustomer = null)
    {
        $this
            ->setAccount($account)
            ->setBatchNbr($batchNbr)
            ->setBeginingBalance($beginingBalance)
            ->setBranch($branch)
            ->setCreditAmount($creditAmount)
            ->setCurrencyBeginingBalance($currencyBeginingBalance)
            ->setCurrencyCreditAmount($currencyCreditAmount)
            ->setCurrencyDebitAmount($currencyDebitAmount)
            ->setCurrencyEndingBalance($currencyEndingBalance)
            ->setCurrencyID($currencyID)
            ->setDebitAmount($debitAmount)
            ->setDescription($description)
            ->setEndingBalance($endingBalance)
            ->setIncludedinReclassHistory($includedinReclassHistory)
            ->setInventoryID($inventoryID)
            ->setLineNbr($lineNbr)
            ->setModule($module)
            ->setPeriod($period)
            ->setReclassBatchNbr($reclassBatchNbr)
            ->setReferenceNbr($referenceNbr)
            ->setSelected($selected)
            ->setSubaccount($subaccount)
            ->setTransactionDate($transactionDate)
            ->setVendorOrCustomer($vendorOrCustomer);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $account
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setAccount(\App\API\SOAP\StructType\StringValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get BatchNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBatchNbr()
    {
        return isset($this->BatchNbr) ? $this->BatchNbr : null;
    }
    /**
     * Set BatchNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $batchNbr
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setBatchNbr(\App\API\SOAP\StructType\StringValue $batchNbr = null)
    {
        if (is_null($batchNbr) || (is_array($batchNbr) && empty($batchNbr))) {
            unset($this->BatchNbr);
        } else {
            $this->BatchNbr = $batchNbr;
        }
        return $this;
    }
    /**
     * Get BeginingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getBeginingBalance()
    {
        return isset($this->BeginingBalance) ? $this->BeginingBalance : null;
    }
    /**
     * Set BeginingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $beginingBalance
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setBeginingBalance(\App\API\SOAP\StructType\DecimalValue $beginingBalance = null)
    {
        if (is_null($beginingBalance) || (is_array($beginingBalance) && empty($beginingBalance))) {
            unset($this->BeginingBalance);
        } else {
            $this->BeginingBalance = $beginingBalance;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setBranch(\App\API\SOAP\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CreditAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCreditAmount()
    {
        return isset($this->CreditAmount) ? $this->CreditAmount : null;
    }
    /**
     * Set CreditAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $creditAmount
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setCreditAmount(\App\API\SOAP\StructType\DecimalValue $creditAmount = null)
    {
        if (is_null($creditAmount) || (is_array($creditAmount) && empty($creditAmount))) {
            unset($this->CreditAmount);
        } else {
            $this->CreditAmount = $creditAmount;
        }
        return $this;
    }
    /**
     * Get CurrencyBeginingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCurrencyBeginingBalance()
    {
        return isset($this->CurrencyBeginingBalance) ? $this->CurrencyBeginingBalance : null;
    }
    /**
     * Set CurrencyBeginingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $currencyBeginingBalance
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setCurrencyBeginingBalance(\App\API\SOAP\StructType\DecimalValue $currencyBeginingBalance = null)
    {
        if (is_null($currencyBeginingBalance) || (is_array($currencyBeginingBalance) && empty($currencyBeginingBalance))) {
            unset($this->CurrencyBeginingBalance);
        } else {
            $this->CurrencyBeginingBalance = $currencyBeginingBalance;
        }
        return $this;
    }
    /**
     * Get CurrencyCreditAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCurrencyCreditAmount()
    {
        return isset($this->CurrencyCreditAmount) ? $this->CurrencyCreditAmount : null;
    }
    /**
     * Set CurrencyCreditAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $currencyCreditAmount
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setCurrencyCreditAmount(\App\API\SOAP\StructType\DecimalValue $currencyCreditAmount = null)
    {
        if (is_null($currencyCreditAmount) || (is_array($currencyCreditAmount) && empty($currencyCreditAmount))) {
            unset($this->CurrencyCreditAmount);
        } else {
            $this->CurrencyCreditAmount = $currencyCreditAmount;
        }
        return $this;
    }
    /**
     * Get CurrencyDebitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCurrencyDebitAmount()
    {
        return isset($this->CurrencyDebitAmount) ? $this->CurrencyDebitAmount : null;
    }
    /**
     * Set CurrencyDebitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $currencyDebitAmount
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setCurrencyDebitAmount(\App\API\SOAP\StructType\DecimalValue $currencyDebitAmount = null)
    {
        if (is_null($currencyDebitAmount) || (is_array($currencyDebitAmount) && empty($currencyDebitAmount))) {
            unset($this->CurrencyDebitAmount);
        } else {
            $this->CurrencyDebitAmount = $currencyDebitAmount;
        }
        return $this;
    }
    /**
     * Get CurrencyEndingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCurrencyEndingBalance()
    {
        return isset($this->CurrencyEndingBalance) ? $this->CurrencyEndingBalance : null;
    }
    /**
     * Set CurrencyEndingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $currencyEndingBalance
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setCurrencyEndingBalance(\App\API\SOAP\StructType\DecimalValue $currencyEndingBalance = null)
    {
        if (is_null($currencyEndingBalance) || (is_array($currencyEndingBalance) && empty($currencyEndingBalance))) {
            unset($this->CurrencyEndingBalance);
        } else {
            $this->CurrencyEndingBalance = $currencyEndingBalance;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setCurrencyID(\App\API\SOAP\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get DebitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getDebitAmount()
    {
        return isset($this->DebitAmount) ? $this->DebitAmount : null;
    }
    /**
     * Set DebitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $debitAmount
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setDebitAmount(\App\API\SOAP\StructType\DecimalValue $debitAmount = null)
    {
        if (is_null($debitAmount) || (is_array($debitAmount) && empty($debitAmount))) {
            unset($this->DebitAmount);
        } else {
            $this->DebitAmount = $debitAmount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EndingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getEndingBalance()
    {
        return isset($this->EndingBalance) ? $this->EndingBalance : null;
    }
    /**
     * Set EndingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $endingBalance
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setEndingBalance(\App\API\SOAP\StructType\DecimalValue $endingBalance = null)
    {
        if (is_null($endingBalance) || (is_array($endingBalance) && empty($endingBalance))) {
            unset($this->EndingBalance);
        } else {
            $this->EndingBalance = $endingBalance;
        }
        return $this;
    }
    /**
     * Get IncludedinReclassHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIncludedinReclassHistory()
    {
        return isset($this->IncludedinReclassHistory) ? $this->IncludedinReclassHistory : null;
    }
    /**
     * Set IncludedinReclassHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $includedinReclassHistory
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setIncludedinReclassHistory(\App\API\SOAP\StructType\BooleanValue $includedinReclassHistory = null)
    {
        if (is_null($includedinReclassHistory) || (is_array($includedinReclassHistory) && empty($includedinReclassHistory))) {
            unset($this->IncludedinReclassHistory);
        } else {
            $this->IncludedinReclassHistory = $includedinReclassHistory;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $lineNbr
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setLineNbr(\App\API\SOAP\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get Module value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getModule()
    {
        return isset($this->Module) ? $this->Module : null;
    }
    /**
     * Set Module value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $module
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setModule(\App\API\SOAP\StructType\StringValue $module = null)
    {
        if (is_null($module) || (is_array($module) && empty($module))) {
            unset($this->Module);
        } else {
            $this->Module = $module;
        }
        return $this;
    }
    /**
     * Get Period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPeriod()
    {
        return isset($this->Period) ? $this->Period : null;
    }
    /**
     * Set Period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $period
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setPeriod(\App\API\SOAP\StructType\StringValue $period = null)
    {
        if (is_null($period) || (is_array($period) && empty($period))) {
            unset($this->Period);
        } else {
            $this->Period = $period;
        }
        return $this;
    }
    /**
     * Get ReclassBatchNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReclassBatchNbr()
    {
        return isset($this->ReclassBatchNbr) ? $this->ReclassBatchNbr : null;
    }
    /**
     * Set ReclassBatchNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $reclassBatchNbr
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setReclassBatchNbr(\App\API\SOAP\StructType\StringValue $reclassBatchNbr = null)
    {
        if (is_null($reclassBatchNbr) || (is_array($reclassBatchNbr) && empty($reclassBatchNbr))) {
            unset($this->ReclassBatchNbr);
        } else {
            $this->ReclassBatchNbr = $reclassBatchNbr;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $referenceNbr
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setReferenceNbr(\App\API\SOAP\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Selected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getSelected()
    {
        return isset($this->Selected) ? $this->Selected : null;
    }
    /**
     * Set Selected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $selected
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setSelected(\App\API\SOAP\StructType\BooleanValue $selected = null)
    {
        if (is_null($selected) || (is_array($selected) && empty($selected))) {
            unset($this->Selected);
        } else {
            $this->Selected = $selected;
        }
        return $this;
    }
    /**
     * Get Subaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSubaccount()
    {
        return isset($this->Subaccount) ? $this->Subaccount : null;
    }
    /**
     * Set Subaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $subaccount
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setSubaccount(\App\API\SOAP\StructType\StringValue $subaccount = null)
    {
        if (is_null($subaccount) || (is_array($subaccount) && empty($subaccount))) {
            unset($this->Subaccount);
        } else {
            $this->Subaccount = $subaccount;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $transactionDate
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setTransactionDate(\App\API\SOAP\StructType\DateTimeValue $transactionDate = null)
    {
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get VendorOrCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getVendorOrCustomer()
    {
        return isset($this->VendorOrCustomer) ? $this->VendorOrCustomer : null;
    }
    /**
     * Set VendorOrCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $vendorOrCustomer
     * @return \App\API\SOAP\StructType\AccountDetailsRow
     */
    public function setVendorOrCustomer(\App\API\SOAP\StructType\StringValue $vendorOrCustomer = null)
    {
        if (is_null($vendorOrCustomer) || (is_array($vendorOrCustomer) && empty($vendorOrCustomer))) {
            unset($this->VendorOrCustomer);
        } else {
            $this->VendorOrCustomer = $vendorOrCustomer;
        }
        return $this;
    }
}
