<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDetailsInquiry StructType
 * @subpackage Structs
 */
class AccountDetailsInquiry extends Entity
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Account;
    /**
     * The BeginingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $BeginingBalance;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Branch;
    /**
     * The EndingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $EndingBalance;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $FromDate;
    /**
     * The FromPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $FromPeriod;
    /**
     * The IncludeReclassified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IncludeReclassified;
    /**
     * The IncludeUnposted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IncludeUnposted;
    /**
     * The IncludeUnreleased
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IncludeUnreleased;
    /**
     * The Ledger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Ledger;
    /**
     * The PeriodEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $PeriodEndDate;
    /**
     * The PeriodStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $PeriodStartDate;
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Results
     */
    public $Results;
    /**
     * The Subaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Subaccount;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $ToDate;
    /**
     * The ToPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ToPeriod;
    /**
     * The Turnover
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Turnover;
    /**
     * Constructor method for AccountDetailsInquiry
     * @uses AccountDetailsInquiry::setAccount()
     * @uses AccountDetailsInquiry::setBeginingBalance()
     * @uses AccountDetailsInquiry::setBranch()
     * @uses AccountDetailsInquiry::setEndingBalance()
     * @uses AccountDetailsInquiry::setFromDate()
     * @uses AccountDetailsInquiry::setFromPeriod()
     * @uses AccountDetailsInquiry::setIncludeReclassified()
     * @uses AccountDetailsInquiry::setIncludeUnposted()
     * @uses AccountDetailsInquiry::setIncludeUnreleased()
     * @uses AccountDetailsInquiry::setLedger()
     * @uses AccountDetailsInquiry::setPeriodEndDate()
     * @uses AccountDetailsInquiry::setPeriodStartDate()
     * @uses AccountDetailsInquiry::setResults()
     * @uses AccountDetailsInquiry::setSubaccount()
     * @uses AccountDetailsInquiry::setToDate()
     * @uses AccountDetailsInquiry::setToPeriod()
     * @uses AccountDetailsInquiry::setTurnover()
     * @param \App\API\SOAP\StructType\StringValue $account
     * @param \App\API\SOAP\StructType\DecimalValue $beginingBalance
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @param \App\API\SOAP\StructType\DecimalValue $endingBalance
     * @param \App\API\SOAP\StructType\DateTimeValue $fromDate
     * @param \App\API\SOAP\StructType\StringValue $fromPeriod
     * @param \App\API\SOAP\StructType\BooleanValue $includeReclassified
     * @param \App\API\SOAP\StructType\BooleanValue $includeUnposted
     * @param \App\API\SOAP\StructType\BooleanValue $includeUnreleased
     * @param \App\API\SOAP\StructType\StringValue $ledger
     * @param \App\API\SOAP\StructType\DateTimeValue $periodEndDate
     * @param \App\API\SOAP\StructType\DateTimeValue $periodStartDate
     * @param \App\API\SOAP\StructType\Results $results
     * @param \App\API\SOAP\StructType\StringValue $subaccount
     * @param \App\API\SOAP\StructType\DateTimeValue $toDate
     * @param \App\API\SOAP\StructType\StringValue $toPeriod
     * @param \App\API\SOAP\StructType\DecimalValue $turnover
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $account = null, \App\API\SOAP\StructType\DecimalValue $beginingBalance = null, \App\API\SOAP\StructType\StringValue $branch = null, \App\API\SOAP\StructType\DecimalValue $endingBalance = null, \App\API\SOAP\StructType\DateTimeValue $fromDate = null, \App\API\SOAP\StructType\StringValue $fromPeriod = null, \App\API\SOAP\StructType\BooleanValue $includeReclassified = null, \App\API\SOAP\StructType\BooleanValue $includeUnposted = null, \App\API\SOAP\StructType\BooleanValue $includeUnreleased = null, \App\API\SOAP\StructType\StringValue $ledger = null, \App\API\SOAP\StructType\DateTimeValue $periodEndDate = null, \App\API\SOAP\StructType\DateTimeValue $periodStartDate = null, \App\API\SOAP\StructType\Results $results = null, \App\API\SOAP\StructType\StringValue $subaccount = null, \App\API\SOAP\StructType\DateTimeValue $toDate = null, \App\API\SOAP\StructType\StringValue $toPeriod = null, \App\API\SOAP\StructType\DecimalValue $turnover = null)
    {
        $this
            ->setAccount($account)
            ->setBeginingBalance($beginingBalance)
            ->setBranch($branch)
            ->setEndingBalance($endingBalance)
            ->setFromDate($fromDate)
            ->setFromPeriod($fromPeriod)
            ->setIncludeReclassified($includeReclassified)
            ->setIncludeUnposted($includeUnposted)
            ->setIncludeUnreleased($includeUnreleased)
            ->setLedger($ledger)
            ->setPeriodEndDate($periodEndDate)
            ->setPeriodStartDate($periodStartDate)
            ->setResults($results)
            ->setSubaccount($subaccount)
            ->setToDate($toDate)
            ->setToPeriod($toPeriod)
            ->setTurnover($turnover);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $account
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setAccount(\App\API\SOAP\StructType\StringValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get BeginingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getBeginingBalance()
    {
        return isset($this->BeginingBalance) ? $this->BeginingBalance : null;
    }
    /**
     * Set BeginingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $beginingBalance
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setBeginingBalance(\App\API\SOAP\StructType\DecimalValue $beginingBalance = null)
    {
        if (is_null($beginingBalance) || (is_array($beginingBalance) && empty($beginingBalance))) {
            unset($this->BeginingBalance);
        } else {
            $this->BeginingBalance = $beginingBalance;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setBranch(\App\API\SOAP\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get EndingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getEndingBalance()
    {
        return isset($this->EndingBalance) ? $this->EndingBalance : null;
    }
    /**
     * Set EndingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $endingBalance
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setEndingBalance(\App\API\SOAP\StructType\DecimalValue $endingBalance = null)
    {
        if (is_null($endingBalance) || (is_array($endingBalance) && empty($endingBalance))) {
            unset($this->EndingBalance);
        } else {
            $this->EndingBalance = $endingBalance;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $fromDate
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setFromDate(\App\API\SOAP\StructType\DateTimeValue $fromDate = null)
    {
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get FromPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getFromPeriod()
    {
        return isset($this->FromPeriod) ? $this->FromPeriod : null;
    }
    /**
     * Set FromPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $fromPeriod
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setFromPeriod(\App\API\SOAP\StructType\StringValue $fromPeriod = null)
    {
        if (is_null($fromPeriod) || (is_array($fromPeriod) && empty($fromPeriod))) {
            unset($this->FromPeriod);
        } else {
            $this->FromPeriod = $fromPeriod;
        }
        return $this;
    }
    /**
     * Get IncludeReclassified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIncludeReclassified()
    {
        return isset($this->IncludeReclassified) ? $this->IncludeReclassified : null;
    }
    /**
     * Set IncludeReclassified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $includeReclassified
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setIncludeReclassified(\App\API\SOAP\StructType\BooleanValue $includeReclassified = null)
    {
        if (is_null($includeReclassified) || (is_array($includeReclassified) && empty($includeReclassified))) {
            unset($this->IncludeReclassified);
        } else {
            $this->IncludeReclassified = $includeReclassified;
        }
        return $this;
    }
    /**
     * Get IncludeUnposted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIncludeUnposted()
    {
        return isset($this->IncludeUnposted) ? $this->IncludeUnposted : null;
    }
    /**
     * Set IncludeUnposted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $includeUnposted
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setIncludeUnposted(\App\API\SOAP\StructType\BooleanValue $includeUnposted = null)
    {
        if (is_null($includeUnposted) || (is_array($includeUnposted) && empty($includeUnposted))) {
            unset($this->IncludeUnposted);
        } else {
            $this->IncludeUnposted = $includeUnposted;
        }
        return $this;
    }
    /**
     * Get IncludeUnreleased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIncludeUnreleased()
    {
        return isset($this->IncludeUnreleased) ? $this->IncludeUnreleased : null;
    }
    /**
     * Set IncludeUnreleased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $includeUnreleased
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setIncludeUnreleased(\App\API\SOAP\StructType\BooleanValue $includeUnreleased = null)
    {
        if (is_null($includeUnreleased) || (is_array($includeUnreleased) && empty($includeUnreleased))) {
            unset($this->IncludeUnreleased);
        } else {
            $this->IncludeUnreleased = $includeUnreleased;
        }
        return $this;
    }
    /**
     * Get Ledger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLedger()
    {
        return isset($this->Ledger) ? $this->Ledger : null;
    }
    /**
     * Set Ledger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $ledger
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setLedger(\App\API\SOAP\StructType\StringValue $ledger = null)
    {
        if (is_null($ledger) || (is_array($ledger) && empty($ledger))) {
            unset($this->Ledger);
        } else {
            $this->Ledger = $ledger;
        }
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getPeriodEndDate()
    {
        return isset($this->PeriodEndDate) ? $this->PeriodEndDate : null;
    }
    /**
     * Set PeriodEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $periodEndDate
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setPeriodEndDate(\App\API\SOAP\StructType\DateTimeValue $periodEndDate = null)
    {
        if (is_null($periodEndDate) || (is_array($periodEndDate) && empty($periodEndDate))) {
            unset($this->PeriodEndDate);
        } else {
            $this->PeriodEndDate = $periodEndDate;
        }
        return $this;
    }
    /**
     * Get PeriodStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getPeriodStartDate()
    {
        return isset($this->PeriodStartDate) ? $this->PeriodStartDate : null;
    }
    /**
     * Set PeriodStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $periodStartDate
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setPeriodStartDate(\App\API\SOAP\StructType\DateTimeValue $periodStartDate = null)
    {
        if (is_null($periodStartDate) || (is_array($periodStartDate) && empty($periodStartDate))) {
            unset($this->PeriodStartDate);
        } else {
            $this->PeriodStartDate = $periodStartDate;
        }
        return $this;
    }
    /**
     * Get Results value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Results|null
     */
    public function getResults()
    {
        return isset($this->Results) ? $this->Results : null;
    }
    /**
     * Set Results value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Results $results
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setResults(\App\API\SOAP\StructType\Results $results = null)
    {
        if (is_null($results) || (is_array($results) && empty($results))) {
            unset($this->Results);
        } else {
            $this->Results = $results;
        }
        return $this;
    }
    /**
     * Get Subaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSubaccount()
    {
        return isset($this->Subaccount) ? $this->Subaccount : null;
    }
    /**
     * Set Subaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $subaccount
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setSubaccount(\App\API\SOAP\StructType\StringValue $subaccount = null)
    {
        if (is_null($subaccount) || (is_array($subaccount) && empty($subaccount))) {
            unset($this->Subaccount);
        } else {
            $this->Subaccount = $subaccount;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $toDate
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setToDate(\App\API\SOAP\StructType\DateTimeValue $toDate = null)
    {
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get ToPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getToPeriod()
    {
        return isset($this->ToPeriod) ? $this->ToPeriod : null;
    }
    /**
     * Set ToPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $toPeriod
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setToPeriod(\App\API\SOAP\StructType\StringValue $toPeriod = null)
    {
        if (is_null($toPeriod) || (is_array($toPeriod) && empty($toPeriod))) {
            unset($this->ToPeriod);
        } else {
            $this->ToPeriod = $toPeriod;
        }
        return $this;
    }
    /**
     * Get Turnover value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTurnover()
    {
        return isset($this->Turnover) ? $this->Turnover : null;
    }
    /**
     * Set Turnover value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $turnover
     * @return \App\API\SOAP\StructType\AccountDetailsInquiry
     */
    public function setTurnover(\App\API\SOAP\StructType\DecimalValue $turnover = null)
    {
        if (is_null($turnover) || (is_array($turnover) && empty($turnover))) {
            unset($this->Turnover);
        } else {
            $this->Turnover = $turnover;
        }
        return $this;
    }
}
