<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountByPeriodInquiry StructType
 * @subpackage Structs
 */
class AccountByPeriodInquiry extends Entity
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Account;
    /**
     * The BranchID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BranchID;
    /**
     * The FinancialYear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $FinancialYear;
    /**
     * The Ledger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Ledger;
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Results
     */
    public $Results;
    /**
     * The Subaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Subaccount;
    /**
     * Constructor method for AccountByPeriodInquiry
     * @uses AccountByPeriodInquiry::setAccount()
     * @uses AccountByPeriodInquiry::setBranchID()
     * @uses AccountByPeriodInquiry::setFinancialYear()
     * @uses AccountByPeriodInquiry::setLedger()
     * @uses AccountByPeriodInquiry::setResults()
     * @uses AccountByPeriodInquiry::setSubaccount()
     * @param \App\API\SOAP\StructType\StringValue $account
     * @param \App\API\SOAP\StructType\StringValue $branchID
     * @param \App\API\SOAP\StructType\StringValue $financialYear
     * @param \App\API\SOAP\StructType\StringValue $ledger
     * @param \App\API\SOAP\StructType\Results $results
     * @param \App\API\SOAP\StructType\StringValue $subaccount
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $account = null, \App\API\SOAP\StructType\StringValue $branchID = null, \App\API\SOAP\StructType\StringValue $financialYear = null, \App\API\SOAP\StructType\StringValue $ledger = null, \App\API\SOAP\StructType\Results $results = null, \App\API\SOAP\StructType\StringValue $subaccount = null)
    {
        $this
            ->setAccount($account)
            ->setBranchID($branchID)
            ->setFinancialYear($financialYear)
            ->setLedger($ledger)
            ->setResults($results)
            ->setSubaccount($subaccount);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $account
     * @return \App\API\SOAP\StructType\AccountByPeriodInquiry
     */
    public function setAccount(\App\API\SOAP\StructType\StringValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get BranchID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBranchID()
    {
        return isset($this->BranchID) ? $this->BranchID : null;
    }
    /**
     * Set BranchID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $branchID
     * @return \App\API\SOAP\StructType\AccountByPeriodInquiry
     */
    public function setBranchID(\App\API\SOAP\StructType\StringValue $branchID = null)
    {
        if (is_null($branchID) || (is_array($branchID) && empty($branchID))) {
            unset($this->BranchID);
        } else {
            $this->BranchID = $branchID;
        }
        return $this;
    }
    /**
     * Get FinancialYear value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getFinancialYear()
    {
        return isset($this->FinancialYear) ? $this->FinancialYear : null;
    }
    /**
     * Set FinancialYear value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $financialYear
     * @return \App\API\SOAP\StructType\AccountByPeriodInquiry
     */
    public function setFinancialYear(\App\API\SOAP\StructType\StringValue $financialYear = null)
    {
        if (is_null($financialYear) || (is_array($financialYear) && empty($financialYear))) {
            unset($this->FinancialYear);
        } else {
            $this->FinancialYear = $financialYear;
        }
        return $this;
    }
    /**
     * Get Ledger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLedger()
    {
        return isset($this->Ledger) ? $this->Ledger : null;
    }
    /**
     * Set Ledger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $ledger
     * @return \App\API\SOAP\StructType\AccountByPeriodInquiry
     */
    public function setLedger(\App\API\SOAP\StructType\StringValue $ledger = null)
    {
        if (is_null($ledger) || (is_array($ledger) && empty($ledger))) {
            unset($this->Ledger);
        } else {
            $this->Ledger = $ledger;
        }
        return $this;
    }
    /**
     * Get Results value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Results|null
     */
    public function getResults()
    {
        return isset($this->Results) ? $this->Results : null;
    }
    /**
     * Set Results value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Results $results
     * @return \App\API\SOAP\StructType\AccountByPeriodInquiry
     */
    public function setResults(\App\API\SOAP\StructType\Results $results = null)
    {
        if (is_null($results) || (is_array($results) && empty($results))) {
            unset($this->Results);
        } else {
            $this->Results = $results;
        }
        return $this;
    }
    /**
     * Get Subaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSubaccount()
    {
        return isset($this->Subaccount) ? $this->Subaccount : null;
    }
    /**
     * Set Subaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $subaccount
     * @return \App\API\SOAP\StructType\AccountByPeriodInquiry
     */
    public function setSubaccount(\App\API\SOAP\StructType\StringValue $subaccount = null)
    {
        if (is_null($subaccount) || (is_array($subaccount) && empty($subaccount))) {
            unset($this->Subaccount);
        } else {
            $this->Subaccount = $subaccount;
        }
        return $this;
    }
}
