<?php

namespace App\API\SOAP\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetBusinessDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\API\SOAP\StructType\SetBusinessDate $parameters
     * @return \App\API\SOAP\StructType\SetBusinessDateResponse|bool
     */
    public function SetBusinessDate(\App\API\SOAP\StructType\SetBusinessDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetBusinessDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\API\SOAP\StructType\SetBusinessDateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
