<?php

namespace App\API\SOAP\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sanity ServiceType
 * @subpackage Services
 */
class Sanity extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SanityCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\API\SOAP\StructType\SanityCheck $parameters
     * @return \App\API\SOAP\StructType\SanityCheckResponse|bool
     */
    public function SanityCheck(\App\API\SOAP\StructType\SanityCheck $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SanityCheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\API\SOAP\StructType\SanityCheckResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
