<?php

namespace App\API\SOAP\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Put ServiceType
 * @subpackage Services
 */
class Put extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Put
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\API\SOAP\StructType\Put $parameters
     * @return \App\API\SOAP\StructType\PutResponse|bool
     */
    public function Put(\App\API\SOAP\StructType\Put $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Put($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PutFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\API\SOAP\StructType\PutFiles $parameters
     * @return \App\API\SOAP\StructType\PutFilesResponse|bool
     */
    public function PutFiles(\App\API\SOAP\StructType\PutFiles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PutFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\API\SOAP\StructType\PutFilesResponse|\App\API\SOAP\StructType\PutResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
