<?php

namespace App\API\SOAP\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Logout ServiceType
 * @subpackage Services
 */
class Logout extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Logout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\API\SOAP\StructType\Logout $parameters
     * @return \App\API\SOAP\StructType\LogoutResponse|bool
     */
    public function Logout(\App\API\SOAP\StructType\Logout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Logout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\API\SOAP\StructType\LogoutResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
