<?php

namespace App\API\SOAP\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Login ServiceType
 * @subpackage Services
 */
class Login extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Login
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\API\SOAP\StructType\Login $parameters
     * @return \App\API\SOAP\StructType\LoginResponse|bool
     */
    public function Login(\App\API\SOAP\StructType\Login $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\API\SOAP\StructType\LoginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
