<?php

namespace App\API\SOAP\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Invoke ServiceType
 * @subpackage Services
 */
class Invoke extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Invoke
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\API\SOAP\StructType\Invoke $parameters
     * @return \App\API\SOAP\StructType\InvokeResponse|bool
     */
    public function Invoke(\App\API\SOAP\StructType\Invoke $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Invoke($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\API\SOAP\StructType\InvokeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
