<?php

namespace App\API\SOAP\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\API\SOAP\StructType\GetList $parameters
     * @return \App\API\SOAP\StructType\GetListResponse|bool
     */
    public function GetList(\App\API\SOAP\StructType\GetList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\API\SOAP\StructType\Get $parameters
     * @return \App\API\SOAP\StructType\GetResponse|bool
     */
    public function Get(\App\API\SOAP\StructType\Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomFieldSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\API\SOAP\StructType\GetCustomFieldSchema $parameters
     * @return \App\API\SOAP\StructType\GetCustomFieldSchemaResponse|bool
     */
    public function GetCustomFieldSchema(\App\API\SOAP\StructType\GetCustomFieldSchema $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomFieldSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\API\SOAP\StructType\GetProcessStatus $parameters
     * @return \App\API\SOAP\StructType\GetProcessStatusResponse|bool
     */
    public function GetProcessStatus(\App\API\SOAP\StructType\GetProcessStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\API\SOAP\StructType\GetFiles $parameters
     * @return \App\API\SOAP\StructType\GetFilesResponse|bool
     */
    public function GetFiles(\App\API\SOAP\StructType\GetFiles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\API\SOAP\StructType\GetCustomFieldSchemaResponse|\App\API\SOAP\StructType\GetFilesResponse|\App\API\SOAP\StructType\GetListResponse|\App\API\SOAP\StructType\GetProcessStatusResponse|\App\API\SOAP\StructType\GetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
