<?php

namespace App\API\SOAP\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ReturnBehavior EnumType
 * @subpackage Enumerations
 */
class ReturnBehavior extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'OnlySystem'
     * @return string 'OnlySystem'
     */
    const VALUE_ONLY_SYSTEM = 'OnlySystem';
    /**
     * Constant for value 'OnlySpecified'
     * @return string 'OnlySpecified'
     */
    const VALUE_ONLY_SPECIFIED = 'OnlySpecified';
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_ALL
     * @uses self::VALUE_NONE
     * @uses self::VALUE_ONLY_SYSTEM
     * @uses self::VALUE_ONLY_SPECIFIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_ALL,
            self::VALUE_NONE,
            self::VALUE_ONLY_SYSTEM,
            self::VALUE_ONLY_SPECIFIED,
        );
    }
}
