<?php

namespace App\API\SOAP\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ProcessStatus EnumType
 * @subpackage Enumerations
 */
class ProcessStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotExists'
     * @return string 'NotExists'
     */
    const VALUE_NOT_EXISTS = 'NotExists';
    /**
     * Constant for value 'InProcess'
     * @return string 'InProcess'
     */
    const VALUE_IN_PROCESS = 'InProcess';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'Aborted'
     * @return string 'Aborted'
     */
    const VALUE_ABORTED = 'Aborted';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_EXISTS
     * @uses self::VALUE_IN_PROCESS
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_ABORTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_EXISTS,
            self::VALUE_IN_PROCESS,
            self::VALUE_COMPLETED,
            self::VALUE_ABORTED,
        );
    }
}
