<?php

namespace App\API\SOAP;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'GetList' => '\\App\\API\\SOAP\\StructType\\GetList',
            'Entity' => '\\App\\API\\SOAP\\StructType\\Entity',
            'LongValue' => '\\App\\API\\SOAP\\StructType\\LongValue',
            'ArrayOfCustomField' => '\\App\\API\\SOAP\\ArrayType\\ArrayOfCustomField',
            'CustomField' => '\\App\\API\\SOAP\\StructType\\CustomField',
            'GetListResponse' => '\\App\\API\\SOAP\\StructType\\GetListResponse',
            'ArrayOfEntity' => '\\App\\API\\SOAP\\ArrayType\\ArrayOfEntity',
            'Get' => '\\App\\API\\SOAP\\StructType\\Get',
            'GetResponse' => '\\App\\API\\SOAP\\StructType\\GetResponse',
            'Put' => '\\App\\API\\SOAP\\StructType\\Put',
            'PutResponse' => '\\App\\API\\SOAP\\StructType\\PutResponse',
            'GetCustomFieldSchema' => '\\App\\API\\SOAP\\StructType\\GetCustomFieldSchema',
            'GetCustomFieldSchemaResponse' => '\\App\\API\\SOAP\\StructType\\GetCustomFieldSchemaResponse',
            'SanityCheck' => '\\App\\API\\SOAP\\StructType\\SanityCheck',
            'SanityCheckResponse' => '\\App\\API\\SOAP\\StructType\\SanityCheckResponse',
            'Login' => '\\App\\API\\SOAP\\StructType\\Login',
            'LoginResponse' => '\\App\\API\\SOAP\\StructType\\LoginResponse',
            'Logout' => '\\App\\API\\SOAP\\StructType\\Logout',
            'LogoutResponse' => '\\App\\API\\SOAP\\StructType\\LogoutResponse',
            'SetBusinessDate' => '\\App\\API\\SOAP\\StructType\\SetBusinessDate',
            'SetBusinessDateResponse' => '\\App\\API\\SOAP\\StructType\\SetBusinessDateResponse',
            'GetProcessStatus' => '\\App\\API\\SOAP\\StructType\\GetProcessStatus',
            'InvokeResult' => '\\App\\API\\SOAP\\StructType\\InvokeResult',
            'GetProcessStatusResponse' => '\\App\\API\\SOAP\\StructType\\GetProcessStatusResponse',
            'ProcessResult' => '\\App\\API\\SOAP\\StructType\\ProcessResult',
            'Delete' => '\\App\\API\\SOAP\\StructType\\Delete',
            'DeleteResponse' => '\\App\\API\\SOAP\\StructType\\DeleteResponse',
            'Invoke' => '\\App\\API\\SOAP\\StructType\\Invoke',
            'Action' => '\\App\\API\\SOAP\\StructType\\Action',
            'InvokeResponse' => '\\App\\API\\SOAP\\StructType\\InvokeResponse',
            'GetFiles' => '\\App\\API\\SOAP\\StructType\\GetFiles',
            'GetFilesResponse' => '\\App\\API\\SOAP\\StructType\\GetFilesResponse',
            'ArrayOfFile' => '\\App\\API\\SOAP\\ArrayType\\ArrayOfFile',
            'File' => '\\App\\API\\SOAP\\StructType\\File',
            'PutFiles' => '\\App\\API\\SOAP\\StructType\\PutFiles',
            'PutFilesResponse' => '\\App\\API\\SOAP\\StructType\\PutFilesResponse',
            'StringSearch' => '\\App\\API\\SOAP\\StructType\\StringSearch',
            'DecimalSearch' => '\\App\\API\\SOAP\\StructType\\DecimalSearch',
            'DateTimeSearch' => '\\App\\API\\SOAP\\StructType\\DateTimeSearch',
            'BooleanSearch' => '\\App\\API\\SOAP\\StructType\\BooleanSearch',
            'IntSearch' => '\\App\\API\\SOAP\\StructType\\IntSearch',
            'LongSearch' => '\\App\\API\\SOAP\\StructType\\LongSearch',
            'ShortSearch' => '\\App\\API\\SOAP\\StructType\\ShortSearch',
            'ByteSearch' => '\\App\\API\\SOAP\\StructType\\ByteSearch',
            'DoubleSearch' => '\\App\\API\\SOAP\\StructType\\DoubleSearch',
            'GuidSearch' => '\\App\\API\\SOAP\\StructType\\GuidSearch',
            'StringValue' => '\\App\\API\\SOAP\\StructType\\StringValue',
            'DecimalValue' => '\\App\\API\\SOAP\\StructType\\DecimalValue',
            'DateTimeValue' => '\\App\\API\\SOAP\\StructType\\DateTimeValue',
            'BooleanValue' => '\\App\\API\\SOAP\\StructType\\BooleanValue',
            'IntValue' => '\\App\\API\\SOAP\\StructType\\IntValue',
            'ShortValue' => '\\App\\API\\SOAP\\StructType\\ShortValue',
            'ByteValue' => '\\App\\API\\SOAP\\StructType\\ByteValue',
            'DoubleValue' => '\\App\\API\\SOAP\\StructType\\DoubleValue',
            'GuidValue' => '\\App\\API\\SOAP\\StructType\\GuidValue',
            'CustomStringField' => '\\App\\API\\SOAP\\StructType\\CustomStringField',
            'StringSkip' => '\\App\\API\\SOAP\\StructType\\StringSkip',
            'StringReturn' => '\\App\\API\\SOAP\\StructType\\StringReturn',
            'CustomDecimalField' => '\\App\\API\\SOAP\\StructType\\CustomDecimalField',
            'DecimalSkip' => '\\App\\API\\SOAP\\StructType\\DecimalSkip',
            'DecimalReturn' => '\\App\\API\\SOAP\\StructType\\DecimalReturn',
            'CustomDateTimeField' => '\\App\\API\\SOAP\\StructType\\CustomDateTimeField',
            'DateTimeSkip' => '\\App\\API\\SOAP\\StructType\\DateTimeSkip',
            'DateTimeReturn' => '\\App\\API\\SOAP\\StructType\\DateTimeReturn',
            'CustomBooleanField' => '\\App\\API\\SOAP\\StructType\\CustomBooleanField',
            'BooleanSkip' => '\\App\\API\\SOAP\\StructType\\BooleanSkip',
            'BooleanReturn' => '\\App\\API\\SOAP\\StructType\\BooleanReturn',
            'CustomIntField' => '\\App\\API\\SOAP\\StructType\\CustomIntField',
            'IntSkip' => '\\App\\API\\SOAP\\StructType\\IntSkip',
            'IntReturn' => '\\App\\API\\SOAP\\StructType\\IntReturn',
            'CustomLongField' => '\\App\\API\\SOAP\\StructType\\CustomLongField',
            'LongSkip' => '\\App\\API\\SOAP\\StructType\\LongSkip',
            'LongReturn' => '\\App\\API\\SOAP\\StructType\\LongReturn',
            'CustomShortField' => '\\App\\API\\SOAP\\StructType\\CustomShortField',
            'ShortSkip' => '\\App\\API\\SOAP\\StructType\\ShortSkip',
            'ShortReturn' => '\\App\\API\\SOAP\\StructType\\ShortReturn',
            'CustomByteField' => '\\App\\API\\SOAP\\StructType\\CustomByteField',
            'ByteSkip' => '\\App\\API\\SOAP\\StructType\\ByteSkip',
            'ByteReturn' => '\\App\\API\\SOAP\\StructType\\ByteReturn',
            'CustomDoubleField' => '\\App\\API\\SOAP\\StructType\\CustomDoubleField',
            'DoubleSkip' => '\\App\\API\\SOAP\\StructType\\DoubleSkip',
            'DoubleReturn' => '\\App\\API\\SOAP\\StructType\\DoubleReturn',
            'CustomGuidField' => '\\App\\API\\SOAP\\StructType\\CustomGuidField',
            'GuidSkip' => '\\App\\API\\SOAP\\StructType\\GuidSkip',
            'GuidReturn' => '\\App\\API\\SOAP\\StructType\\GuidReturn',
            'EventTimeActivity' => '\\App\\API\\SOAP\\StructType\\EventTimeActivity',
            'StatementCycle' => '\\App\\API\\SOAP\\StructType\\StatementCycle',
            'TaskRelatedActivity' => '\\App\\API\\SOAP\\StructType\\TaskRelatedActivity',
            'BusinessAccountShippingContact' => '\\App\\API\\SOAP\\StructType\\BusinessAccountShippingContact',
            'CheckHistoryDetail' => '\\App\\API\\SOAP\\StructType\\CheckHistoryDetail',
            'SalesOrdersDiscountDetails' => '\\App\\API\\SOAP\\StructType\\SalesOrdersDiscountDetails',
            'ContactRoles' => '\\App\\API\\SOAP\\StructType\\ContactRoles',
            'PaymentOrderDetail' => '\\App\\API\\SOAP\\StructType\\PaymentOrderDetail',
            'VendorClass' => '\\App\\API\\SOAP\\StructType\\VendorClass',
            'Attributes' => '\\App\\API\\SOAP\\StructType\\Attributes',
            'CustomerPriceClass' => '\\App\\API\\SOAP\\StructType\\CustomerPriceClass',
            'ProjectBillingDetails' => '\\App\\API\\SOAP\\StructType\\ProjectBillingDetails',
            'KitStockComponent' => '\\App\\API\\SOAP\\StructType\\KitStockComponent',
            'ExpenseReceipt' => '\\App\\API\\SOAP\\StructType\\ExpenseReceipt',
            'TaxDetails' => '\\App\\API\\SOAP\\StructType\\TaxDetails',
            'Lead' => '\\App\\API\\SOAP\\StructType\\Lead',
            'Activities' => '\\App\\API\\SOAP\\StructType\\Activities',
            'Campaigns' => '\\App\\API\\SOAP\\StructType\\Campaigns',
            'Duplicates' => '\\App\\API\\SOAP\\StructType\\Duplicates',
            'MarketingLists' => '\\App\\API\\SOAP\\StructType\\MarketingLists',
            'Relations' => '\\App\\API\\SOAP\\StructType\\Relations',
            'AccountLocationContact' => '\\App\\API\\SOAP\\StructType\\AccountLocationContact',
            'StockItemWarehouseDetail' => '\\App\\API\\SOAP\\StructType\\StockItemWarehouseDetail',
            'Contact' => '\\App\\API\\SOAP\\StructType\\Contact',
            'Cases' => '\\App\\API\\SOAP\\StructType\\Cases',
            'Notifications' => '\\App\\API\\SOAP\\StructType\\Notifications',
            'Opportunities' => '\\App\\API\\SOAP\\StructType\\Opportunities',
            'ExpenseClaimAPDocument' => '\\App\\API\\SOAP\\StructType\\ExpenseClaimAPDocument',
            'TaskRelatedTask' => '\\App\\API\\SOAP\\StructType\\TaskRelatedTask',
            'ProFormaFinancialDetails' => '\\App\\API\\SOAP\\StructType\\ProFormaFinancialDetails',
            'CommonTask' => '\\App\\API\\SOAP\\StructType\\CommonTask',
            'CreditVerificationRules' => '\\App\\API\\SOAP\\StructType\\CreditVerificationRules',
            'ShippingZones' => '\\App\\API\\SOAP\\StructType\\ShippingZones',
            'ProjectEquipment' => '\\App\\API\\SOAP\\StructType\\ProjectEquipment',
            'Discount' => '\\App\\API\\SOAP\\StructType\\Discount',
            'CustomerPriceClasses' => '\\App\\API\\SOAP\\StructType\\CustomerPriceClasses',
            'Customers' => '\\App\\API\\SOAP\\StructType\\Customers',
            'DiscountBreakpoints' => '\\App\\API\\SOAP\\StructType\\DiscountBreakpoints',
            'ItemPriceClasses' => '\\App\\API\\SOAP\\StructType\\ItemPriceClasses',
            'Items' => '\\App\\API\\SOAP\\StructType\\Items',
            'Warehouses' => '\\App\\API\\SOAP\\StructType\\Warehouses',
            'ProjectGLAccount' => '\\App\\API\\SOAP\\StructType\\ProjectGLAccount',
            'DefaultTaskForGLAccounts' => '\\App\\API\\SOAP\\StructType\\DefaultTaskForGLAccounts',
            'InterBranchAccountMappingTransactionInSourceBranchDetail' => '\\App\\API\\SOAP\\StructType\\InterBranchAccountMappingTransactionInSourceBranchDetail',
            'PaymentApplicationHistoryDetail' => '\\App\\API\\SOAP\\StructType\\PaymentApplicationHistoryDetail',
            'PurchaseReceiptDetailAllocation' => '\\App\\API\\SOAP\\StructType\\PurchaseReceiptDetailAllocation',
            'Account' => '\\App\\API\\SOAP\\StructType\\Account',
            'ExpenseReceiptTaxDetails' => '\\App\\API\\SOAP\\StructType\\ExpenseReceiptTaxDetails',
            'BillToSettings' => '\\App\\API\\SOAP\\StructType\\BillToSettings',
            'ContractUsage' => '\\App\\API\\SOAP\\StructType\\ContractUsage',
            'BilledTransactions' => '\\App\\API\\SOAP\\StructType\\BilledTransactions',
            'UnbilledTransactions' => '\\App\\API\\SOAP\\StructType\\UnbilledTransactions',
            'BusinessAccountOpportunityDetail' => '\\App\\API\\SOAP\\StructType\\BusinessAccountOpportunityDetail',
            'ProjectTaskToCRMLink' => '\\App\\API\\SOAP\\StructType\\ProjectTaskToCRMLink',
            'DiscountBreakpointDetail' => '\\App\\API\\SOAP\\StructType\\DiscountBreakpointDetail',
            'PhysicalInventoryReviewDetail' => '\\App\\API\\SOAP\\StructType\\PhysicalInventoryReviewDetail',
            'ExpenseReceiptDetails' => '\\App\\API\\SOAP\\StructType\\ExpenseReceiptDetails',
            'ContactDuplicateDetail' => '\\App\\API\\SOAP\\StructType\\ContactDuplicateDetail',
            'ReminderDetail' => '\\App\\API\\SOAP\\StructType\\ReminderDetail',
            'ExternalCommitment' => '\\App\\API\\SOAP\\StructType\\ExternalCommitment',
            'SalesInvoiceDiscountDetails' => '\\App\\API\\SOAP\\StructType\\SalesInvoiceDiscountDetails',
            'AccountByPeriodRow' => '\\App\\API\\SOAP\\StructType\\AccountByPeriodRow',
            'ProjectTemplate' => '\\App\\API\\SOAP\\StructType\\ProjectTemplate',
            'Employees' => '\\App\\API\\SOAP\\StructType\\Employees',
            'Equipments' => '\\App\\API\\SOAP\\StructType\\Equipments',
            'CategoryStockItem' => '\\App\\API\\SOAP\\StructType\\CategoryStockItem',
            'ExpenseClaim' => '\\App\\API\\SOAP\\StructType\\ExpenseClaim',
            'ApprovalDetails' => '\\App\\API\\SOAP\\StructType\\ApprovalDetails',
            'Details' => '\\App\\API\\SOAP\\StructType\\Details',
            'TaxZoneDetail' => '\\App\\API\\SOAP\\StructType\\TaxZoneDetail',
            'Check' => '\\App\\API\\SOAP\\StructType\\Check',
            'History' => '\\App\\API\\SOAP\\StructType\\History',
            'EmailProcessing' => '\\App\\API\\SOAP\\StructType\\EmailProcessing',
            'Result' => '\\App\\API\\SOAP\\StructType\\Result',
            'ReportingGroup' => '\\App\\API\\SOAP\\StructType\\ReportingGroup',
            'PhysicalInventoryCount' => '\\App\\API\\SOAP\\StructType\\PhysicalInventoryCount',
            'Approval' => '\\App\\API\\SOAP\\StructType\\Approval',
            'ShopForRates' => '\\App\\API\\SOAP\\StructType\\ShopForRates',
            'ContactUserInfo' => '\\App\\API\\SOAP\\StructType\\ContactUserInfo',
            'Roles' => '\\App\\API\\SOAP\\StructType\\Roles',
            'JournalVoucher' => '\\App\\API\\SOAP\\StructType\\JournalVoucher',
            'GLTransactions' => '\\App\\API\\SOAP\\StructType\\GLTransactions',
            'SubItemStockItem' => '\\App\\API\\SOAP\\StructType\\SubItemStockItem',
            'SalesOrder' => '\\App\\API\\SOAP\\StructType\\SalesOrder',
            'DiscountDetails' => '\\App\\API\\SOAP\\StructType\\DiscountDetails',
            'Payments' => '\\App\\API\\SOAP\\StructType\\Payments',
            'Shipments' => '\\App\\API\\SOAP\\StructType\\Shipments',
            'DiscountItemDetail' => '\\App\\API\\SOAP\\StructType\\DiscountItemDetail',
            'AdjustmentDetail' => '\\App\\API\\SOAP\\StructType\\AdjustmentDetail',
            'DocContact' => '\\App\\API\\SOAP\\StructType\\DocContact',
            'Vendor' => '\\App\\API\\SOAP\\StructType\\Vendor',
            'Contacts' => '\\App\\API\\SOAP\\StructType\\Contacts',
            'PaymentInstructions' => '\\App\\API\\SOAP\\StructType\\PaymentInstructions',
            'RelationDetail' => '\\App\\API\\SOAP\\StructType\\RelationDetail',
            'ItemsDetails' => '\\App\\API\\SOAP\\StructType\\ItemsDetails',
            'ProFormaTaxDetail' => '\\App\\API\\SOAP\\StructType\\ProFormaTaxDetail',
            'ExpenseClaimDetails' => '\\App\\API\\SOAP\\StructType\\ExpenseClaimDetails',
            'Address' => '\\App\\API\\SOAP\\StructType\\Address',
            'CarrierCustomerAccount' => '\\App\\API\\SOAP\\StructType\\CarrierCustomerAccount',
            'Bill' => '\\App\\API\\SOAP\\StructType\\Bill',
            'Applications' => '\\App\\API\\SOAP\\StructType\\Applications',
            'SalesOrderDetailAllocation' => '\\App\\API\\SOAP\\StructType\\SalesOrderDetailAllocation',
            'AccountLocation' => '\\App\\API\\SOAP\\StructType\\AccountLocation',
            'JournalVoucherDetailAPDocumentToApply' => '\\App\\API\\SOAP\\StructType\\JournalVoucherDetailAPDocumentToApply',
            'AccountBySubaccountRow' => '\\App\\API\\SOAP\\StructType\\AccountBySubaccountRow',
            'Case' => '\\App\\API\\SOAP\\StructType\\_Case',
            'RelatedCases' => '\\App\\API\\SOAP\\StructType\\RelatedCases',
            'SalesPriceWorksheet' => '\\App\\API\\SOAP\\StructType\\SalesPriceWorksheet',
            'SalesPrices' => '\\App\\API\\SOAP\\StructType\\SalesPrices',
            'ReplenishmentParameterStockItem' => '\\App\\API\\SOAP\\StructType\\ReplenishmentParameterStockItem',
            'Project' => '\\App\\API\\SOAP\\StructType\\Project',
            'ActivityHistory' => '\\App\\API\\SOAP\\StructType\\ActivityHistory',
            'Balances' => '\\App\\API\\SOAP\\StructType\\Balances',
            'Invoices' => '\\App\\API\\SOAP\\StructType\\Invoices',
            'UnionLocals' => '\\App\\API\\SOAP\\StructType\\UnionLocals',
            'ProjectBudget' => '\\App\\API\\SOAP\\StructType\\ProjectBudget',
            'LotSerialClass' => '\\App\\API\\SOAP\\StructType\\LotSerialClass',
            'Segments' => '\\App\\API\\SOAP\\StructType\\Segments',
            'EventRelatedActivity' => '\\App\\API\\SOAP\\StructType\\EventRelatedActivity',
            'Customer' => '\\App\\API\\SOAP\\StructType\\Customer',
            'Salespersons' => '\\App\\API\\SOAP\\StructType\\Salespersons',
            'TransferOrderDetail' => '\\App\\API\\SOAP\\StructType\\TransferOrderDetail',
            'Allocations' => '\\App\\API\\SOAP\\StructType\\Allocations',
            'ChangeOrderRevenueBudget' => '\\App\\API\\SOAP\\StructType\\ChangeOrderRevenueBudget',
            'BillApplicationDetail' => '\\App\\API\\SOAP\\StructType\\BillApplicationDetail',
            'SalesPricesWorksheetDetail' => '\\App\\API\\SOAP\\StructType\\SalesPricesWorksheetDetail',
            'ShipViaFreightRate' => '\\App\\API\\SOAP\\StructType\\ShipViaFreightRate',
            'JournalVoucherDetailARDocumentToApply' => '\\App\\API\\SOAP\\StructType\\JournalVoucherDetailARDocumentToApply',
            'AccountByPeriodInquiry' => '\\App\\API\\SOAP\\StructType\\AccountByPeriodInquiry',
            'Results' => '\\App\\API\\SOAP\\StructType\\Results',
            'PurchaseReceipt' => '\\App\\API\\SOAP\\StructType\\PurchaseReceipt',
            'PaymentDetail' => '\\App\\API\\SOAP\\StructType\\PaymentDetail',
            'Tax' => '\\App\\API\\SOAP\\StructType\\Tax',
            'TaxSchedule' => '\\App\\API\\SOAP\\StructType\\TaxSchedule',
            'Zones' => '\\App\\API\\SOAP\\StructType\\Zones',
            'AccountDetailsInquiry' => '\\App\\API\\SOAP\\StructType\\AccountDetailsInquiry',
            'FinancialYearPeriodDetail' => '\\App\\API\\SOAP\\StructType\\FinancialYearPeriodDetail',
            'KitAssemblyStockComponentAllocation' => '\\App\\API\\SOAP\\StructType\\KitAssemblyStockComponentAllocation',
            'DuplicateDetail' => '\\App\\API\\SOAP\\StructType\\DuplicateDetail',
            'BusinessAccountCaseDetail' => '\\App\\API\\SOAP\\StructType\\BusinessAccountCaseDetail',
            'ProjectTemplateTask' => '\\App\\API\\SOAP\\StructType\\ProjectTemplateTask',
            'AccountDetailsRow' => '\\App\\API\\SOAP\\StructType\\AccountDetailsRow',
            'CashSale' => '\\App\\API\\SOAP\\StructType\\CashSale',
            'CustomerContact' => '\\App\\API\\SOAP\\StructType\\CustomerContact',
            'StockItem' => '\\App\\API\\SOAP\\StructType\\StockItem',
            'Boxes' => '\\App\\API\\SOAP\\StructType\\Boxes',
            'Categories' => '\\App\\API\\SOAP\\StructType\\Categories',
            'CrossReferences' => '\\App\\API\\SOAP\\StructType\\CrossReferences',
            'ReplenishmentParameters' => '\\App\\API\\SOAP\\StructType\\ReplenishmentParameters',
            'SubItems' => '\\App\\API\\SOAP\\StructType\\SubItems',
            'UOMConversions' => '\\App\\API\\SOAP\\StructType\\UOMConversions',
            'VendorDetails' => '\\App\\API\\SOAP\\StructType\\VendorDetails',
            'WarehouseDetails' => '\\App\\API\\SOAP\\StructType\\WarehouseDetails',
            'TaxScheduleDetail' => '\\App\\API\\SOAP\\StructType\\TaxScheduleDetail',
            'SalesPricesInquiry' => '\\App\\API\\SOAP\\StructType\\SalesPricesInquiry',
            'SalesPriceDetails' => '\\App\\API\\SOAP\\StructType\\SalesPriceDetails',
            'ProjectBillingAndAllocationSettings' => '\\App\\API\\SOAP\\StructType\\ProjectBillingAndAllocationSettings',
            'Commissions' => '\\App\\API\\SOAP\\StructType\\Commissions',
            'SalesPersons' => '\\App\\API\\SOAP\\StructType\\SalesPersons_1',
            'FinancialSettings' => '\\App\\API\\SOAP\\StructType\\FinancialSettings',
            'BillDetail' => '\\App\\API\\SOAP\\StructType\\BillDetail',
            'PurchaseReceiptDetail' => '\\App\\API\\SOAP\\StructType\\PurchaseReceiptDetail',
            'JournalTransactionDetail' => '\\App\\API\\SOAP\\StructType\\JournalTransactionDetail',
            'CustomerPaymentMethod' => '\\App\\API\\SOAP\\StructType\\CustomerPaymentMethod',
            'CompanyFinancialPeriod' => '\\App\\API\\SOAP\\StructType\\CompanyFinancialPeriod',
            'OpportunityDetail' => '\\App\\API\\SOAP\\StructType\\OpportunityDetail',
            'EmployeeSettings' => '\\App\\API\\SOAP\\StructType\\EmployeeSettings',
            'BusinessAccountMainContact' => '\\App\\API\\SOAP\\StructType\\BusinessAccountMainContact',
            'AccountSummaryInquiry' => '\\App\\API\\SOAP\\StructType\\AccountSummaryInquiry',
            'Carrier' => '\\App\\API\\SOAP\\StructType\\Carrier',
            'CustomerAccounts' => '\\App\\API\\SOAP\\StructType\\CustomerAccounts',
            'PlugInParameters' => '\\App\\API\\SOAP\\StructType\\PlugInParameters',
            'KitNonStockComponent' => '\\App\\API\\SOAP\\StructType\\KitNonStockComponent',
            'VendorPricesInquiry' => '\\App\\API\\SOAP\\StructType\\VendorPricesInquiry',
            'VendorPriceDetails' => '\\App\\API\\SOAP\\StructType\\VendorPriceDetails',
            'ProjectTask' => '\\App\\API\\SOAP\\StructType\\ProjectTask',
            'Attribute' => '\\App\\API\\SOAP\\StructType\\Attribute',
            'ActivityDetail' => '\\App\\API\\SOAP\\StructType\\ActivityDetail',
            'ShipmentOrderDetail' => '\\App\\API\\SOAP\\StructType\\ShipmentOrderDetail',
            'Warehouse' => '\\App\\API\\SOAP\\StructType\\Warehouse',
            'Locations' => '\\App\\API\\SOAP\\StructType\\Locations',
            'DefaultTaskForGLAccount' => '\\App\\API\\SOAP\\StructType\\DefaultTaskForGLAccount',
            'BusinessAccountOrder' => '\\App\\API\\SOAP\\StructType\\BusinessAccountOrder',
            'JournalVoucherGLTransaction' => '\\App\\API\\SOAP\\StructType\\JournalVoucherGLTransaction',
            'TaxDetail' => '\\App\\API\\SOAP\\StructType\\TaxDetail',
            'TaxZoneApplicableTaxDetail' => '\\App\\API\\SOAP\\StructType\\TaxZoneApplicableTaxDetail',
            'PurchaseOrderDetail' => '\\App\\API\\SOAP\\StructType\\PurchaseOrderDetail',
            'TaskTimeActivity' => '\\App\\API\\SOAP\\StructType\\TaskTimeActivity',
            'KitAssemblyStockComponent' => '\\App\\API\\SOAP\\StructType\\KitAssemblyStockComponent',
            'NonStockItem' => '\\App\\API\\SOAP\\StructType\\NonStockItem',
            'SalesCategories' => '\\App\\API\\SOAP\\StructType\\SalesCategories',
            'EmailProcessingRow' => '\\App\\API\\SOAP\\StructType\\EmailProcessingRow',
            'CustomerClass' => '\\App\\API\\SOAP\\StructType\\CustomerClass',
            'TrialBalance' => '\\App\\API\\SOAP\\StructType\\TrialBalance',
            'ShippingTerm' => '\\App\\API\\SOAP\\StructType\\ShippingTerm',
            'CustomerPaymentMethodDetail' => '\\App\\API\\SOAP\\StructType\\CustomerPaymentMethodDetail',
            'Totals' => '\\App\\API\\SOAP\\StructType\\Totals',
            'InventoryAllocationInquiry' => '\\App\\API\\SOAP\\StructType\\InventoryAllocationInquiry',
            'SalesPersonDetail' => '\\App\\API\\SOAP\\StructType\\SalesPersonDetail',
            'WarehouseLocation' => '\\App\\API\\SOAP\\StructType\\WarehouseLocation',
            'TimeEntry' => '\\App\\API\\SOAP\\StructType\\TimeEntry',
            'TransferOrderDetailAllocation' => '\\App\\API\\SOAP\\StructType\\TransferOrderDetailAllocation',
            'BusinessAccountDefaultLocationSetting' => '\\App\\API\\SOAP\\StructType\\BusinessAccountDefaultLocationSetting',
            'CreditCardProcessingDetail' => '\\App\\API\\SOAP\\StructType\\CreditCardProcessingDetail',
            'ShipToSettings' => '\\App\\API\\SOAP\\StructType\\ShipToSettings',
            'Email' => '\\App\\API\\SOAP\\StructType\\Email',
            'FinancialPeriod' => '\\App\\API\\SOAP\\StructType\\FinancialPeriod',
            'LotSerialClassSegment' => '\\App\\API\\SOAP\\StructType\\LotSerialClassSegment',
            'ExpenseClaimFinancialDetail' => '\\App\\API\\SOAP\\StructType\\ExpenseClaimFinancialDetail',
            'APDocuments' => '\\App\\API\\SOAP\\StructType\\APDocuments',
            'ProjectTemplateTaskProperties' => '\\App\\API\\SOAP\\StructType\\ProjectTemplateTaskProperties',
            'ProjectBilling' => '\\App\\API\\SOAP\\StructType\\ProjectBilling',
            'PhysicalInventoryCountDetail' => '\\App\\API\\SOAP\\StructType\\PhysicalInventoryCountDetail',
            'Salesperson' => '\\App\\API\\SOAP\\StructType\\Salesperson',
            'ShippingBox' => '\\App\\API\\SOAP\\StructType\\ShippingBox',
            'ItemClass' => '\\App\\API\\SOAP\\StructType\\ItemClass',
            'ItemSalesCategory' => '\\App\\API\\SOAP\\StructType\\ItemSalesCategory',
            'Members' => '\\App\\API\\SOAP\\StructType\\Members',
            'StockItemVendorDetail' => '\\App\\API\\SOAP\\StructType\\StockItemVendorDetail',
            'ShipmentDetail' => '\\App\\API\\SOAP\\StructType\\ShipmentDetail',
            'ItemSalesCategoryMember' => '\\App\\API\\SOAP\\StructType\\ItemSalesCategoryMember',
            'ChangeOrder' => '\\App\\API\\SOAP\\StructType\\ChangeOrder',
            'Commitments' => '\\App\\API\\SOAP\\StructType\\Commitments',
            'CostBudget' => '\\App\\API\\SOAP\\StructType\\CostBudget',
            'RevenueBudget' => '\\App\\API\\SOAP\\StructType\\RevenueBudget',
            'BusinessAccountContact' => '\\App\\API\\SOAP\\StructType\\BusinessAccountContact',
            'OpportunityProduct' => '\\App\\API\\SOAP\\StructType\\OpportunityProduct',
            'PurchaseSettings' => '\\App\\API\\SOAP\\StructType\\PurchaseSettings',
            'InventoryItemUOMConversion' => '\\App\\API\\SOAP\\StructType\\InventoryItemUOMConversion',
            'SalesInvoiceDetail' => '\\App\\API\\SOAP\\StructType\\SalesInvoiceDetail',
            'UnionLocal' => '\\App\\API\\SOAP\\StructType\\UnionLocal',
            'TimeAndMaterial' => '\\App\\API\\SOAP\\StructType\\TimeAndMaterial',
            'SalesInvoiceTotals' => '\\App\\API\\SOAP\\StructType\\SalesInvoiceTotals',
            'Opportunity' => '\\App\\API\\SOAP\\StructType\\Opportunity',
            'Discounts' => '\\App\\API\\SOAP\\StructType\\Discounts',
            'Products' => '\\App\\API\\SOAP\\StructType\\Products',
            'LaborCostRate' => '\\App\\API\\SOAP\\StructType\\LaborCostRate',
            'EmployeeDelegate' => '\\App\\API\\SOAP\\StructType\\EmployeeDelegate',
            'Event' => '\\App\\API\\SOAP\\StructType\\Event',
            'Attendees' => '\\App\\API\\SOAP\\StructType\\Attendees',
            'RelatedActivities' => '\\App\\API\\SOAP\\StructType\\RelatedActivities',
            'ProjectTaskBillingAndAllocationSettings' => '\\App\\API\\SOAP\\StructType\\ProjectTaskBillingAndAllocationSettings',
            'WorkClassCompensationCode' => '\\App\\API\\SOAP\\StructType\\WorkClassCompensationCode',
            'SalesOrderShipment' => '\\App\\API\\SOAP\\StructType\\SalesOrderShipment',
            'ProjectTransactionDetail' => '\\App\\API\\SOAP\\StructType\\ProjectTransactionDetail',
            'Invoice' => '\\App\\API\\SOAP\\StructType\\Invoice',
            'ApplicationsCreditMemo' => '\\App\\API\\SOAP\\StructType\\ApplicationsCreditMemo',
            'ApplicationsDefault' => '\\App\\API\\SOAP\\StructType\\ApplicationsDefault',
            'Task' => '\\App\\API\\SOAP\\StructType\\Task',
            'RelatedTasks' => '\\App\\API\\SOAP\\StructType\\RelatedTasks',
            'SalesInvoiceTaxDetail' => '\\App\\API\\SOAP\\StructType\\SalesInvoiceTaxDetail',
            'CustomerSalesPerson' => '\\App\\API\\SOAP\\StructType\\CustomerSalesPerson',
            'VendorPriceDetail' => '\\App\\API\\SOAP\\StructType\\VendorPriceDetail',
            'ManageFinancialPeriods' => '\\App\\API\\SOAP\\StructType\\ManageFinancialPeriods',
            'BusinessAccountClassAttributeDetail' => '\\App\\API\\SOAP\\StructType\\BusinessAccountClassAttributeDetail',
            'SalesInvoiceSalesPersonDetail' => '\\App\\API\\SOAP\\StructType\\SalesInvoiceSalesPersonDetail',
            'KitSpecification' => '\\App\\API\\SOAP\\StructType\\KitSpecification',
            'NonStockComponents' => '\\App\\API\\SOAP\\StructType\\NonStockComponents',
            'StockComponents' => '\\App\\API\\SOAP\\StructType\\StockComponents',
            'ProgressBilling' => '\\App\\API\\SOAP\\StructType\\ProgressBilling',
            'ExpenseClaimTaxDetail' => '\\App\\API\\SOAP\\StructType\\ExpenseClaimTaxDetail',
            'EmployeeFinancialSettings' => '\\App\\API\\SOAP\\StructType\\EmployeeFinancialSettings',
            'InventorySummaryInquiry' => '\\App\\API\\SOAP\\StructType\\InventorySummaryInquiry',
            'KitAssembly' => '\\App\\API\\SOAP\\StructType\\KitAssembly',
            'CaseDetail' => '\\App\\API\\SOAP\\StructType\\CaseDetail',
            'AccountGroup' => '\\App\\API\\SOAP\\StructType\\AccountGroup',
            'Employee' => '\\App\\API\\SOAP\\StructType\\Employee',
            'Delegates' => '\\App\\API\\SOAP\\StructType\\Delegates',
            'EmploymentHistory' => '\\App\\API\\SOAP\\StructType\\EmploymentHistory',
            'OpportunityContact' => '\\App\\API\\SOAP\\StructType\\OpportunityContact',
            'ShipVia' => '\\App\\API\\SOAP\\StructType\\ShipVia',
            'FreightRates' => '\\App\\API\\SOAP\\StructType\\FreightRates',
            'Packages' => '\\App\\API\\SOAP\\StructType\\Packages',
            'ContractUsageTransactionDetail' => '\\App\\API\\SOAP\\StructType\\ContractUsageTransactionDetail',
            'InventoryItemCrossReference' => '\\App\\API\\SOAP\\StructType\\InventoryItemCrossReference',
            'ProjectProFormaDetails' => '\\App\\API\\SOAP\\StructType\\ProjectProFormaDetails',
            'AttributeDetail' => '\\App\\API\\SOAP\\StructType\\AttributeDetail',
            'ShipmentPackage' => '\\App\\API\\SOAP\\StructType\\ShipmentPackage',
            'InvoiceApplicationsCreditMemo' => '\\App\\API\\SOAP\\StructType\\InvoiceApplicationsCreditMemo',
            'InventorySummaryRow' => '\\App\\API\\SOAP\\StructType\\InventorySummaryRow',
            'AccountSummaryRow' => '\\App\\API\\SOAP\\StructType\\AccountSummaryRow',
            'ItemPriceClassesDetails' => '\\App\\API\\SOAP\\StructType\\ItemPriceClassesDetails',
            'CheckDetail' => '\\App\\API\\SOAP\\StructType\\CheckDetail',
            'ShippingInstructions' => '\\App\\API\\SOAP\\StructType\\ShippingInstructions',
            'ProjectTaskProperties' => '\\App\\API\\SOAP\\StructType\\ProjectTaskProperties',
            'AllocationRule' => '\\App\\API\\SOAP\\StructType\\AllocationRule',
            'UnitsOfMeasure' => '\\App\\API\\SOAP\\StructType\\UnitsOfMeasure',
            'CashSaleDetail' => '\\App\\API\\SOAP\\StructType\\CashSaleDetail',
            'InterBranchAccountMappingTransactionInDestinationBranchDetail' => '\\App\\API\\SOAP\\StructType\\InterBranchAccountMappingTransactionInDestinationBranchDetail',
            'AccountBySubaccountInquiry' => '\\App\\API\\SOAP\\StructType\\AccountBySubaccountInquiry',
            'VisibilitySettings' => '\\App\\API\\SOAP\\StructType\\VisibilitySettings',
            'Payment' => '\\App\\API\\SOAP\\StructType\\Payment',
            'ApplicationHistory' => '\\App\\API\\SOAP\\StructType\\ApplicationHistory',
            'CreditCardProcessingInfo' => '\\App\\API\\SOAP\\StructType\\CreditCardProcessingInfo',
            'DocumentsToApply' => '\\App\\API\\SOAP\\StructType\\DocumentsToApply',
            'OrdersToApply' => '\\App\\API\\SOAP\\StructType\\OrdersToApply',
            'DiscountItemPriceClassesDetail' => '\\App\\API\\SOAP\\StructType\\DiscountItemPriceClassesDetail',
            'VoucherEntryCode' => '\\App\\API\\SOAP\\StructType\\VoucherEntryCode',
            'SalesInvoiceApplicationInvoice' => '\\App\\API\\SOAP\\StructType\\SalesInvoiceApplicationInvoice',
            'TrialBalanceDetail' => '\\App\\API\\SOAP\\StructType\\TrialBalanceDetail',
            'ItemClassAtrribute' => '\\App\\API\\SOAP\\StructType\\ItemClassAtrribute',
            'AttributeValue' => '\\App\\API\\SOAP\\StructType\\AttributeValue',
            'DiscountWarehouseDetail' => '\\App\\API\\SOAP\\StructType\\DiscountWarehouseDetail',
            'ProjectEmployee' => '\\App\\API\\SOAP\\StructType\\ProjectEmployee',
            'InventoryReceiptDetailAllocation' => '\\App\\API\\SOAP\\StructType\\InventoryReceiptDetailAllocation',
            'DiscountCode' => '\\App\\API\\SOAP\\StructType\\DiscountCode',
            'FOBPoint' => '\\App\\API\\SOAP\\StructType\\FOBPoint',
            'BusinessAccountPaymentInstructionDetail' => '\\App\\API\\SOAP\\StructType\\BusinessAccountPaymentInstructionDetail',
            'EmploymentHistoryRecord' => '\\App\\API\\SOAP\\StructType\\EmploymentHistoryRecord',
            'Adjustment' => '\\App\\API\\SOAP\\StructType\\Adjustment',
            'OpportunityDiscount' => '\\App\\API\\SOAP\\StructType\\OpportunityDiscount',
            'JournalTransaction' => '\\App\\API\\SOAP\\StructType\\JournalTransaction',
            'InterBranchAccountMapping' => '\\App\\API\\SOAP\\StructType\\InterBranchAccountMapping',
            'TransactionsInDestinationBranch' => '\\App\\API\\SOAP\\StructType\\TransactionsInDestinationBranch',
            'TransactionsInSourceBranch' => '\\App\\API\\SOAP\\StructType\\TransactionsInSourceBranch',
            'BusinessAccountActivityDetail' => '\\App\\API\\SOAP\\StructType\\BusinessAccountActivityDetail',
            'FinancialPeriodDetail' => '\\App\\API\\SOAP\\StructType\\FinancialPeriodDetail',
            'InventoryReceipt' => '\\App\\API\\SOAP\\StructType\\InventoryReceipt',
            'AttributeDefinition' => '\\App\\API\\SOAP\\StructType\\AttributeDefinition',
            'Values' => '\\App\\API\\SOAP\\StructType\\Values',
            'ProjectActivity' => '\\App\\API\\SOAP\\StructType\\ProjectActivity',
            'CaseRelatedCase' => '\\App\\API\\SOAP\\StructType\\CaseRelatedCase',
            'SalesInvoiceCommissions' => '\\App\\API\\SOAP\\StructType\\SalesInvoiceCommissions',
            'ChangeOrderClass' => '\\App\\API\\SOAP\\StructType\\ChangeOrderClass',
            'AttributeDefinitionValue' => '\\App\\API\\SOAP\\StructType\\AttributeDefinitionValue',
            'BusinessAccountContract' => '\\App\\API\\SOAP\\StructType\\BusinessAccountContract',
            'ManageFinancialPeriodsDetail' => '\\App\\API\\SOAP\\StructType\\ManageFinancialPeriodsDetail',
            'ChangeOrderCommitment' => '\\App\\API\\SOAP\\StructType\\ChangeOrderCommitment',
            'SalesInvoiceApplicationCreditMemo' => '\\App\\API\\SOAP\\StructType\\SalesInvoiceApplicationCreditMemo',
            'ProjectUnionLocal' => '\\App\\API\\SOAP\\StructType\\ProjectUnionLocal',
            'SalesInvoiceFinancialDetails' => '\\App\\API\\SOAP\\StructType\\SalesInvoiceFinancialDetails',
            'InvoiceDetail' => '\\App\\API\\SOAP\\StructType\\InvoiceDetail',
            'ProFormaInvoice' => '\\App\\API\\SOAP\\StructType\\ProFormaInvoice',
            'CostCode' => '\\App\\API\\SOAP\\StructType\\CostCode',
            'BusinessAccountMarketingListDetail' => '\\App\\API\\SOAP\\StructType\\BusinessAccountMarketingListDetail',
            'SalesInvoiceFreightDetail' => '\\App\\API\\SOAP\\StructType\\SalesInvoiceFreightDetail',
            'TimeActivity' => '\\App\\API\\SOAP\\StructType\\TimeActivity',
            'CampaignDetail' => '\\App\\API\\SOAP\\StructType\\CampaignDetail',
            'SalesInvoice' => '\\App\\API\\SOAP\\StructType\\SalesInvoice',
            'ApplicationsInvoice' => '\\App\\API\\SOAP\\StructType\\ApplicationsInvoice',
            'FreightDetails' => '\\App\\API\\SOAP\\StructType\\FreightDetails',
            'SalesOrderDetail' => '\\App\\API\\SOAP\\StructType\\SalesOrderDetail',
            'BusinessAccount' => '\\App\\API\\SOAP\\StructType\\BusinessAccount',
            'Contracts' => '\\App\\API\\SOAP\\StructType\\Contracts',
            'Orders' => '\\App\\API\\SOAP\\StructType\\Orders',
            'TaxZone' => '\\App\\API\\SOAP\\StructType\\TaxZone',
            'ApplicableTaxes' => '\\App\\API\\SOAP\\StructType\\ApplicableTaxes',
            'TaxCategoryTaxDetail' => '\\App\\API\\SOAP\\StructType\\TaxCategoryTaxDetail',
            'InventoryAllocationRow' => '\\App\\API\\SOAP\\StructType\\InventoryAllocationRow',
            'SalesPriceDetail' => '\\App\\API\\SOAP\\StructType\\SalesPriceDetail',
            'Subaccount' => '\\App\\API\\SOAP\\StructType\\Subaccount',
            'CarrierPluginParameter' => '\\App\\API\\SOAP\\StructType\\CarrierPluginParameter',
            'ProjectProperties' => '\\App\\API\\SOAP\\StructType\\ProjectProperties',
            'Currency' => '\\App\\API\\SOAP\\StructType\\Currency',
            'NonStockItemSalesCategory' => '\\App\\API\\SOAP\\StructType\\NonStockItemSalesCategory',
            'CaseActivityDetail' => '\\App\\API\\SOAP\\StructType\\CaseActivityDetail',
            'EventAttendee' => '\\App\\API\\SOAP\\StructType\\EventAttendee',
            'Shipment' => '\\App\\API\\SOAP\\StructType\\Shipment',
            'BillTaxDetail' => '\\App\\API\\SOAP\\StructType\\BillTaxDetail',
            'InvoiceTaxDetail' => '\\App\\API\\SOAP\\StructType\\InvoiceTaxDetail',
            'PaymentMethodAllowedCashAccountDetail' => '\\App\\API\\SOAP\\StructType\\PaymentMethodAllowedCashAccountDetail',
            'DiscountCustomerPriceClassesDetail' => '\\App\\API\\SOAP\\StructType\\DiscountCustomerPriceClassesDetail',
            'JournalVoucherDetail' => '\\App\\API\\SOAP\\StructType\\JournalVoucherDetail',
            'APDocumentsToApply' => '\\App\\API\\SOAP\\StructType\\APDocumentsToApply',
            'ARDocumentsToApply' => '\\App\\API\\SOAP\\StructType\\ARDocumentsToApply',
            'KitAssemblyAllocation' => '\\App\\API\\SOAP\\StructType\\KitAssemblyAllocation',
            'CustomerLocation' => '\\App\\API\\SOAP\\StructType\\CustomerLocation',
            'TaxCategory' => '\\App\\API\\SOAP\\StructType\\TaxCategory',
            'ChangeOrderCostBudget' => '\\App\\API\\SOAP\\StructType\\ChangeOrderCostBudget',
            'FinancialYear' => '\\App\\API\\SOAP\\StructType\\FinancialYear',
            'ShippingTermDetail' => '\\App\\API\\SOAP\\StructType\\ShippingTermDetail',
            'ProjectBillingRules' => '\\App\\API\\SOAP\\StructType\\ProjectBillingRules',
            'ContactNotification' => '\\App\\API\\SOAP\\StructType\\ContactNotification',
            'PaymentMethodProcessingCenterDetail' => '\\App\\API\\SOAP\\StructType\\PaymentMethodProcessingCenterDetail',
            'ProjectTransaction' => '\\App\\API\\SOAP\\StructType\\ProjectTransaction',
            'ItemWarehouse' => '\\App\\API\\SOAP\\StructType\\ItemWarehouse',
            'Activity' => '\\App\\API\\SOAP\\StructType\\Activity',
            'ProjectBalance' => '\\App\\API\\SOAP\\StructType\\ProjectBalance',
            'ShippingSettings' => '\\App\\API\\SOAP\\StructType\\ShippingSettings',
            'TransferOrder' => '\\App\\API\\SOAP\\StructType\\TransferOrder',
            'ProjectTaskDefaultValues' => '\\App\\API\\SOAP\\StructType\\ProjectTaskDefaultValues',
            'ShipmentDetailAllocation' => '\\App\\API\\SOAP\\StructType\\ShipmentDetailAllocation',
            'DiscountCustomerDetail' => '\\App\\API\\SOAP\\StructType\\DiscountCustomerDetail',
            'ReportingSettings' => '\\App\\API\\SOAP\\StructType\\ReportingSettings',
            'ReportingGroups' => '\\App\\API\\SOAP\\StructType\\ReportingGroups',
            'PurchaseOrder' => '\\App\\API\\SOAP\\StructType\\PurchaseOrder',
            'VendorPriceWorksheetDetail' => '\\App\\API\\SOAP\\StructType\\VendorPriceWorksheetDetail',
            'BusinessAccountLocation' => '\\App\\API\\SOAP\\StructType\\BusinessAccountLocation',
            'InvoiceApplicationsDefault' => '\\App\\API\\SOAP\\StructType\\InvoiceApplicationsDefault',
            'InvoiceDiscountDetail' => '\\App\\API\\SOAP\\StructType\\InvoiceDiscountDetail',
            'KitAssemblyNonStockComponent' => '\\App\\API\\SOAP\\StructType\\KitAssemblyNonStockComponent',
            'VendorPriceWorksheet' => '\\App\\API\\SOAP\\StructType\\VendorPriceWorksheet',
            'VendorSalesPrices' => '\\App\\API\\SOAP\\StructType\\VendorSalesPrices',
            'OpportunityTaxDetail' => '\\App\\API\\SOAP\\StructType\\OpportunityTaxDetail',
            'PaymentMethod' => '\\App\\API\\SOAP\\StructType\\PaymentMethod',
            'AllowedCashAccounts' => '\\App\\API\\SOAP\\StructType\\AllowedCashAccounts',
            'ProcessingCenters' => '\\App\\API\\SOAP\\StructType\\ProcessingCenters',
            'BoxStockItem' => '\\App\\API\\SOAP\\StructType\\BoxStockItem',
            'NonStockItemVendorDetail' => '\\App\\API\\SOAP\\StructType\\NonStockItemVendorDetail',
            'NonStockItemAttribute' => '\\App\\API\\SOAP\\StructType\\NonStockItemAttribute',
            'PurchaseOrderTaxDetail' => '\\App\\API\\SOAP\\StructType\\PurchaseOrderTaxDetail',
            'PhysicalInventoryReview' => '\\App\\API\\SOAP\\StructType\\PhysicalInventoryReview',
            'InventoryReceiptDetail' => '\\App\\API\\SOAP\\StructType\\InventoryReceiptDetail',
            'MarketingListDetail' => '\\App\\API\\SOAP\\StructType\\MarketingListDetail',
            'SubmitExpenseReceipt' => '\\App\\API\\SOAP\\StructType\\SubmitExpenseReceipt',
            'ApproveExpenseReceipt' => '\\App\\API\\SOAP\\StructType\\ApproveExpenseReceipt',
            'RejectExpenseReceipt' => '\\App\\API\\SOAP\\StructType\\RejectExpenseReceipt',
            'PutOnHoldExpenseReceipt' => '\\App\\API\\SOAP\\StructType\\PutOnHoldExpenseReceipt',
            'ClaimExpenseReceipt' => '\\App\\API\\SOAP\\StructType\\ClaimExpenseReceipt',
            'CheckLeadForDuplicates' => '\\App\\API\\SOAP\\StructType\\CheckLeadForDuplicates',
            'CloseLeadAsDuplicate' => '\\App\\API\\SOAP\\StructType\\CloseLeadAsDuplicate',
            'ConvertLeadToBAccount' => '\\App\\API\\SOAP\\StructType\\ConvertLeadToBAccount',
            'ConvertLeadToContact' => '\\App\\API\\SOAP\\StructType\\ConvertLeadToContact',
            'ConvertLeadToOpportunity' => '\\App\\API\\SOAP\\StructType\\ConvertLeadToOpportunity',
            'ValidateLeadAddress' => '\\App\\API\\SOAP\\StructType\\ValidateLeadAddress',
            'MarkLeadAsValidated' => '\\App\\API\\SOAP\\StructType\\MarkLeadAsValidated',
            'CheckForContactDuplicates' => '\\App\\API\\SOAP\\StructType\\CheckForContactDuplicates',
            'ConvertContactToBusinessAccount' => '\\App\\API\\SOAP\\StructType\\ConvertContactToBusinessAccount',
            'CopyFromCompany' => '\\App\\API\\SOAP\\StructType\\CopyFromCompany',
            'MarkContactAsValidated' => '\\App\\API\\SOAP\\StructType\\MarkContactAsValidated',
            'ValidateContactAddress' => '\\App\\API\\SOAP\\StructType\\ValidateContactAddress',
            'CloseContactAsDuplicate' => '\\App\\API\\SOAP\\StructType\\CloseContactAsDuplicate',
            'UpdateDiscounts' => '\\App\\API\\SOAP\\StructType\\UpdateDiscounts',
            'ApproveExpenseClaim' => '\\App\\API\\SOAP\\StructType\\ApproveExpenseClaim',
            'RejectExpenseClaim' => '\\App\\API\\SOAP\\StructType\\RejectExpenseClaim',
            'SubmitExpenseClaim' => '\\App\\API\\SOAP\\StructType\\SubmitExpenseClaim',
            'ReleaseExpenseClaim' => '\\App\\API\\SOAP\\StructType\\ReleaseExpenseClaim',
            'PutOnHoldExpenseClaim' => '\\App\\API\\SOAP\\StructType\\PutOnHoldExpenseClaim',
            'ReleaseCheck' => '\\App\\API\\SOAP\\StructType\\ReleaseCheck',
            'ProcessEmailProcessing' => '\\App\\API\\SOAP\\StructType\\ProcessEmailProcessing',
            'ProcessAllEmailProcessing' => '\\App\\API\\SOAP\\StructType\\ProcessAllEmailProcessing',
            'ReleaseJournalVoucher' => '\\App\\API\\SOAP\\StructType\\ReleaseJournalVoucher',
            'CancelSalesOrder' => '\\App\\API\\SOAP\\StructType\\CancelSalesOrder',
            'ReopenSalesOrder' => '\\App\\API\\SOAP\\StructType\\ReopenSalesOrder',
            'PrepareSalesInvoice' => '\\App\\API\\SOAP\\StructType\\PrepareSalesInvoice',
            'OpenSalesOrder' => '\\App\\API\\SOAP\\StructType\\OpenSalesOrder',
            'ReleaseFromCreditHoldSalesOrder' => '\\App\\API\\SOAP\\StructType\\ReleaseFromCreditHoldSalesOrder',
            'SalesOrderAddInvoice' => '\\App\\API\\SOAP\\StructType\\SalesOrderAddInvoice',
            'SalesOrderAddStockItem' => '\\App\\API\\SOAP\\StructType\\SalesOrderAddStockItem',
            'SalesOrderCreatePurchaseOrder' => '\\App\\API\\SOAP\\StructType\\SalesOrderCreatePurchaseOrder',
            'SalesOrderCreateReceipt' => '\\App\\API\\SOAP\\StructType\\SalesOrderCreateReceipt',
            'SalesOrderCreateShipment' => '\\App\\API\\SOAP\\StructType\\SalesOrderCreateShipment',
            'AutoRecalculateDiscounts' => '\\App\\API\\SOAP\\StructType\\AutoRecalculateDiscounts',
            'ReleaseBill' => '\\App\\API\\SOAP\\StructType\\ReleaseBill',
            'ReverseBill' => '\\App\\API\\SOAP\\StructType\\ReverseBill',
            'ReleaseCase' => '\\App\\API\\SOAP\\StructType\\ReleaseCase',
            'TakeCase' => '\\App\\API\\SOAP\\StructType\\TakeCase',
            'AssignCase' => '\\App\\API\\SOAP\\StructType\\AssignCase',
            'ReleaseSalesPriceWorksheet' => '\\App\\API\\SOAP\\StructType\\ReleaseSalesPriceWorksheet',
            'RunProjectAllocation' => '\\App\\API\\SOAP\\StructType\\RunProjectAllocation',
            'ValidateProjectBalance' => '\\App\\API\\SOAP\\StructType\\ValidateProjectBalance',
            'RunProjectBilling' => '\\App\\API\\SOAP\\StructType\\RunProjectBilling',
            'ApproveProject' => '\\App\\API\\SOAP\\StructType\\ApproveProject',
            'RejectProject' => '\\App\\API\\SOAP\\StructType\\RejectProject',
            'LockProjectBudget' => '\\App\\API\\SOAP\\StructType\\LockProjectBudget',
            'UnlockProjectBudget' => '\\App\\API\\SOAP\\StructType\\UnlockProjectBudget',
            'LockProjectCommitments' => '\\App\\API\\SOAP\\StructType\\LockProjectCommitments',
            'UnlockProjectCommitments' => '\\App\\API\\SOAP\\StructType\\UnlockProjectCommitments',
            'ChangeProjectID' => '\\App\\API\\SOAP\\StructType\\ChangeProjectID',
            'ReleasePurchaseReceipt' => '\\App\\API\\SOAP\\StructType\\ReleasePurchaseReceipt',
            'CreateAPBill' => '\\App\\API\\SOAP\\StructType\\CreateAPBill',
            'ReleaseCashSale' => '\\App\\API\\SOAP\\StructType\\ReleaseCashSale',
            'UpdateStandardCostStockItem' => '\\App\\API\\SOAP\\StructType\\UpdateStandardCostStockItem',
            'UpdateStandardCostNonStockItem' => '\\App\\API\\SOAP\\StructType\\UpdateStandardCostNonStockItem',
            'TrialBalanceProcess' => '\\App\\API\\SOAP\\StructType\\TrialBalanceProcess',
            'TrialBalanceProcessAll' => '\\App\\API\\SOAP\\StructType\\TrialBalanceProcessAll',
            'ReleaseTrialBalance' => '\\App\\API\\SOAP\\StructType\\ReleaseTrialBalance',
            'CompleteTimeEntry' => '\\App\\API\\SOAP\\StructType\\CompleteTimeEntry',
            'OpenTimeEntry' => '\\App\\API\\SOAP\\StructType\\OpenTimeEntry',
            'SendEmail' => '\\App\\API\\SOAP\\StructType\\SendEmail',
            'CreateContactFromEmail' => '\\App\\API\\SOAP\\StructType\\CreateContactFromEmail',
            'CreateEventFromEmail' => '\\App\\API\\SOAP\\StructType\\CreateEventFromEmail',
            'CreateLeadFromEmail' => '\\App\\API\\SOAP\\StructType\\CreateLeadFromEmail',
            'CreateCaseFromEmail' => '\\App\\API\\SOAP\\StructType\\CreateCaseFromEmail',
            'CreateTaskFromEmail' => '\\App\\API\\SOAP\\StructType\\CreateTaskFromEmail',
            'RestoreDeletedEmail' => '\\App\\API\\SOAP\\StructType\\RestoreDeletedEmail',
            'RestoreArchivedEmail' => '\\App\\API\\SOAP\\StructType\\RestoreArchivedEmail',
            'ProcessEmail' => '\\App\\API\\SOAP\\StructType\\ProcessEmail',
            'DownloadEmlFileEmail' => '\\App\\API\\SOAP\\StructType\\DownloadEmlFileEmail',
            'CancelSendingEmail' => '\\App\\API\\SOAP\\StructType\\CancelSendingEmail',
            'ArchiveEmail' => '\\App\\API\\SOAP\\StructType\\ArchiveEmail',
            'LinkEntityToEmail' => '\\App\\API\\SOAP\\StructType\\LinkEntityToEmail',
            'GeneratePeriods' => '\\App\\API\\SOAP\\StructType\\GeneratePeriods',
            'ProjectBillingProcess' => '\\App\\API\\SOAP\\StructType\\ProjectBillingProcess',
            'ProjectBillingProcessAll' => '\\App\\API\\SOAP\\StructType\\ProjectBillingProcessAll',
            'ReleaseChangeOrder' => '\\App\\API\\SOAP\\StructType\\ReleaseChangeOrder',
            'ApproveChangeOrder' => '\\App\\API\\SOAP\\StructType\\ApproveChangeOrder',
            'RejectChangeOrder' => '\\App\\API\\SOAP\\StructType\\RejectChangeOrder',
            'EmailChangeOrder' => '\\App\\API\\SOAP\\StructType\\EmailChangeOrder',
            'ReverseChangeOrder' => '\\App\\API\\SOAP\\StructType\\ReverseChangeOrder',
            'CreateAccountFromOpportunity' => '\\App\\API\\SOAP\\StructType\\CreateAccountFromOpportunity',
            'CreateContactFromOpportunity' => '\\App\\API\\SOAP\\StructType\\CreateContactFromOpportunity',
            'CreateOpportunityInvoice' => '\\App\\API\\SOAP\\StructType\\CreateOpportunityInvoice',
            'CreateOpportunitySalesOrder' => '\\App\\API\\SOAP\\StructType\\CreateOpportunitySalesOrder',
            'AcceptInvitationEvent' => '\\App\\API\\SOAP\\StructType\\AcceptInvitationEvent',
            'CancelActivityEvent' => '\\App\\API\\SOAP\\StructType\\CancelActivityEvent',
            'CompleteEvent' => '\\App\\API\\SOAP\\StructType\\CompleteEvent',
            'CompleteAndFollowUpEvent' => '\\App\\API\\SOAP\\StructType\\CompleteAndFollowUpEvent',
            'ExportCardEvent' => '\\App\\API\\SOAP\\StructType\\ExportCardEvent',
            'RejectInvitationEvent' => '\\App\\API\\SOAP\\StructType\\RejectInvitationEvent',
            'InviteAllEvent' => '\\App\\API\\SOAP\\StructType\\InviteAllEvent',
            'InviteEvent' => '\\App\\API\\SOAP\\StructType\\InviteEvent',
            'LinkEntityToEvent' => '\\App\\API\\SOAP\\StructType\\LinkEntityToEvent',
            'ReleaseInvoice' => '\\App\\API\\SOAP\\StructType\\ReleaseInvoice',
            'ReverseInvoice' => '\\App\\API\\SOAP\\StructType\\ReverseInvoice',
            'CompleteTask' => '\\App\\API\\SOAP\\StructType\\CompleteTask',
            'CompleteAndFollowUpTask' => '\\App\\API\\SOAP\\StructType\\CompleteAndFollowUpTask',
            'CancelActivityTask' => '\\App\\API\\SOAP\\StructType\\CancelActivityTask',
            'LinkEntityToTask' => '\\App\\API\\SOAP\\StructType\\LinkEntityToTask',
            'ProcessManageFinancialPeriods' => '\\App\\API\\SOAP\\StructType\\ProcessManageFinancialPeriods',
            'ProcessAllManageFinancialPeriods' => '\\App\\API\\SOAP\\StructType\\ProcessAllManageFinancialPeriods',
            'ReleaseKitAssembly' => '\\App\\API\\SOAP\\StructType\\ReleaseKitAssembly',
            'ChangeEmployeeID' => '\\App\\API\\SOAP\\StructType\\ChangeEmployeeID',
            'CaptureCreditCardPayment' => '\\App\\API\\SOAP\\StructType\\CaptureCreditCardPayment',
            'ReleasePayment' => '\\App\\API\\SOAP\\StructType\\ReleasePayment',
            'VoidPayment' => '\\App\\API\\SOAP\\StructType\\VoidPayment',
            'PaymentLoadDocuments' => '\\App\\API\\SOAP\\StructType\\PaymentLoadDocuments',
            'PaymentLoadOrders' => '\\App\\API\\SOAP\\StructType\\PaymentLoadOrders',
            'ReleaseAdjustment' => '\\App\\API\\SOAP\\StructType\\ReleaseAdjustment',
            'ReleaseJournalTransaction' => '\\App\\API\\SOAP\\StructType\\ReleaseJournalTransaction',
            'ReleaseInventoryReceipt' => '\\App\\API\\SOAP\\StructType\\ReleaseInventoryReceipt',
            'ReleaseProFormaInvoice' => '\\App\\API\\SOAP\\StructType\\ReleaseProFormaInvoice',
            'ApproveProFormaInvoice' => '\\App\\API\\SOAP\\StructType\\ApproveProFormaInvoice',
            'RejectProFormaInvoice' => '\\App\\API\\SOAP\\StructType\\RejectProFormaInvoice',
            'EmailProFormaInvoice' => '\\App\\API\\SOAP\\StructType\\EmailProFormaInvoice',
            'ChangeCostCodeID' => '\\App\\API\\SOAP\\StructType\\ChangeCostCodeID',
            'ReleaseSalesInvoice' => '\\App\\API\\SOAP\\StructType\\ReleaseSalesInvoice',
            'SalesInvoiceAddOrder' => '\\App\\API\\SOAP\\StructType\\SalesInvoiceAddOrder',
            'SalesInvoiceAutoApply' => '\\App\\API\\SOAP\\StructType\\SalesInvoiceAutoApply',
            'ConvertBusinessAccountToCustomer' => '\\App\\API\\SOAP\\StructType\\ConvertBusinessAccountToCustomer',
            'ConvertBusinessAccountToVendor' => '\\App\\API\\SOAP\\StructType\\ConvertBusinessAccountToVendor',
            'MarkBusinessAccountAsValidated' => '\\App\\API\\SOAP\\StructType\\MarkBusinessAccountAsValidated',
            'ValidateBusinessAccountAddresses' => '\\App\\API\\SOAP\\StructType\\ValidateBusinessAccountAddresses',
            'ChangeBusinessAccountID' => '\\App\\API\\SOAP\\StructType\\ChangeBusinessAccountID',
            'CheckForBusinessAccountDuplicates' => '\\App\\API\\SOAP\\StructType\\CheckForBusinessAccountDuplicates',
            'ConfirmShipment' => '\\App\\API\\SOAP\\StructType\\ConfirmShipment',
            'CorrectShipment' => '\\App\\API\\SOAP\\StructType\\CorrectShipment',
            'UpdateIN' => '\\App\\API\\SOAP\\StructType\\UpdateIN',
            'PrepareInvoice' => '\\App\\API\\SOAP\\StructType\\PrepareInvoice',
            'ReleaseTransactions' => '\\App\\API\\SOAP\\StructType\\ReleaseTransactions',
            'CompleteActivity' => '\\App\\API\\SOAP\\StructType\\CompleteActivity',
            'LinkEntityToActivity' => '\\App\\API\\SOAP\\StructType\\LinkEntityToActivity',
            'ReleaseTransferOrder' => '\\App\\API\\SOAP\\StructType\\ReleaseTransferOrder',
            'EnterPOReceipt' => '\\App\\API\\SOAP\\StructType\\EnterPOReceipt',
            'EnterAPBill' => '\\App\\API\\SOAP\\StructType\\EnterAPBill',
            'ReleaseVendorPriceWorksheet' => '\\App\\API\\SOAP\\StructType\\ReleaseVendorPriceWorksheet',
            'CancelPhysicalInventory' => '\\App\\API\\SOAP\\StructType\\CancelPhysicalInventory',
            'CompletePhysicalInventory' => '\\App\\API\\SOAP\\StructType\\CompletePhysicalInventory',
            'FinishCountingPhysicalInventory' => '\\App\\API\\SOAP\\StructType\\FinishCountingPhysicalInventory',
        );
    }
}
