<?php

namespace App\API\SOAP\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFile ArrayType
 * @subpackage Arrays
 */
class ArrayOfFile extends AbstractStructArrayBase
{
    /**
     * The File
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\File[]
     */
    public $File;
    /**
     * Constructor method for ArrayOfFile
     * @uses ArrayOfFile::setFile()
     * @param \App\API\SOAP\StructType\File[] $file
     */
    public function __construct(array $file = array())
    {
        $this
            ->setFile($file);
    }
    /**
     * Get File value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\File[]|null
     */
    public function getFile()
    {
        return isset($this->File) ? $this->File : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFileForArrayConstraintsFromSetFile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFileFileItem) {
            // validation for constraint: itemType
            if (!$arrayOfFileFileItem instanceof \App\API\SOAP\StructType\File) {
                $invalidValues[] = is_object($arrayOfFileFileItem) ? get_class($arrayOfFileFileItem) : sprintf('%s(%s)', gettype($arrayOfFileFileItem), var_export($arrayOfFileFileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The File property can only contain items of type \App\API\SOAP\StructType\File, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set File value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\File[] $file
     * @return \App\API\SOAP\ArrayType\ArrayOfFile
     */
    public function setFile(array $file = array())
    {
        // validation for constraint: array
        if ('' !== ($fileArrayErrorMessage = self::validateFileForArrayConstraintsFromSetFile($file))) {
            throw new \InvalidArgumentException($fileArrayErrorMessage, __LINE__);
        }
        if (is_null($file) || (is_array($file) && empty($file))) {
            unset($this->File);
        } else {
            $this->File = $file;
        }
        return $this;
    }
    /**
     * Add item to File value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\File $item
     * @return \App\API\SOAP\ArrayType\ArrayOfFile
     */
    public function addToFile(\App\API\SOAP\StructType\File $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\File) {
            throw new \InvalidArgumentException(sprintf('The File property can only contain items of type \App\API\SOAP\StructType\File, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->File[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \App\API\SOAP\StructType\File|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \App\API\SOAP\StructType\File|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \App\API\SOAP\StructType\File|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \App\API\SOAP\StructType\File|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \App\API\SOAP\StructType\File|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string File
     */
    public function getAttributeName()
    {
        return 'File';
    }
}
