<?php

namespace App\API\SOAP\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomField ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomField extends AbstractStructArrayBase
{
    /**
     * The CustomField
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\CustomField[]
     */
    public $CustomField;
    /**
     * Constructor method for ArrayOfCustomField
     * @uses ArrayOfCustomField::setCustomField()
     * @param \App\API\SOAP\StructType\CustomField[] $customField
     */
    public function __construct(array $customField = array())
    {
        $this
            ->setCustomField($customField);
    }
    /**
     * Get CustomField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\CustomField[]|null
     */
    public function getCustomField()
    {
        return isset($this->CustomField) ? $this->CustomField : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomField method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomField method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldForArrayConstraintsFromSetCustomField(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomFieldCustomFieldItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomFieldCustomFieldItem instanceof \App\API\SOAP\StructType\CustomField) {
                $invalidValues[] = is_object($arrayOfCustomFieldCustomFieldItem) ? get_class($arrayOfCustomFieldCustomFieldItem) : sprintf('%s(%s)', gettype($arrayOfCustomFieldCustomFieldItem), var_export($arrayOfCustomFieldCustomFieldItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomField property can only contain items of type \App\API\SOAP\StructType\CustomField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CustomField[] $customField
     * @return \App\API\SOAP\ArrayType\ArrayOfCustomField
     */
    public function setCustomField(array $customField = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldArrayErrorMessage = self::validateCustomFieldForArrayConstraintsFromSetCustomField($customField))) {
            throw new \InvalidArgumentException($customFieldArrayErrorMessage, __LINE__);
        }
        if (is_null($customField) || (is_array($customField) && empty($customField))) {
            unset($this->CustomField);
        } else {
            $this->CustomField = $customField;
        }
        return $this;
    }
    /**
     * Add item to CustomField value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CustomField $item
     * @return \App\API\SOAP\ArrayType\ArrayOfCustomField
     */
    public function addToCustomField(\App\API\SOAP\StructType\CustomField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\CustomField) {
            throw new \InvalidArgumentException(sprintf('The CustomField property can only contain items of type \App\API\SOAP\StructType\CustomField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomField[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \App\API\SOAP\StructType\CustomField|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \App\API\SOAP\StructType\CustomField|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \App\API\SOAP\StructType\CustomField|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \App\API\SOAP\StructType\CustomField|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \App\API\SOAP\StructType\CustomField|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomField
     */
    public function getAttributeName()
    {
        return 'CustomField';
    }
}
