<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethods StructType
 * @subpackage Structs
 * @version 2.2
 */
class PaymentMethods extends AbstractStructBase
{
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - documentation: To indicate the payment method code. Valid values: CSH - CASH CRC - CREDIT CARD CHQ - CHEQUE DRD - DIRECT DEBIT MOB - PAYMENT WITH MOBILE PHONE
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * @var string
     */
    public $PaymentMethod;
    /**
     * Constructor method for PaymentMethods
     * @uses PaymentMethods::setPaymentMethod()
     * @param string $paymentMethod
     */
    public function __construct($paymentMethod = null)
    {
        $this
            ->setPaymentMethod($paymentMethod);
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param string $paymentMethod
     * @return \akademia\StructType\PaymentMethods
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($paymentMethod) && mb_strlen($paymentMethod) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($paymentMethod)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($paymentMethod) && mb_strlen($paymentMethod) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
}
