<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherCharge StructType
 * Meta information extracted from the WSDL
 * - documentation: Other Charge caption and its charge value
 * @subpackage Structs
 * @version 2.2
 */
class OtherCharge extends AbstractStructBase
{
    /**
     * The Caption
     * Meta information extracted from the WSDL
     * - documentation: Other Charge caption | Other Charges Caption
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $Caption;
    /**
     * The ChargeValue
     * Meta information extracted from the WSDL
     * - documentation: Charge value can be passed to print in this field
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - totalDigits: 18
     * - whiteSpace: collapse
     * @var float
     */
    public $ChargeValue;
    /**
     * The ChargeType
     * Meta information extracted from the WSDL
     * - documentation: ChargeType is mandatory element together with ChargeValue and provides more detail as to categorize the charge being provided. Possible values: ADMIN - Administration Charge/Fee/Cost DELIV - Delivery Charge/Fee/Cost DOCUM -
     * Documentation Charge/Fee/Cost EXPED - Expedite Charge/Fee/Cost EXCHA - Export Charge/Fee/Cost FRCST - Freight/Shipping Charge/Fee/Cost SSRGE - Fuel Surcharge LOGST - Logistic Charge/Fee/Cost SOTHR - Other Charge/Fee/Cost SPKGN - Packaging/Packing
     * Charge/Fee/Cost PICUP - Pickup Charge/Fee/Cost HRCRG - Handling Charge/Fee/Cost VATCR - VAT Charge/Fee/Cost INSCH - Insurance Cost (Fee) REVCH - Reverse Charge
     * - minOccurs: 0
     * @var string
     */
    public $ChargeType;
    /**
     * Constructor method for OtherCharge
     * @uses OtherCharge::setCaption()
     * @uses OtherCharge::setChargeValue()
     * @uses OtherCharge::setChargeType()
     * @param string $caption
     * @param float $chargeValue
     * @param string $chargeType
     */
    public function __construct($caption = null, $chargeValue = null, $chargeType = null)
    {
        $this
            ->setCaption($caption)
            ->setChargeValue($chargeValue)
            ->setChargeType($chargeType);
    }
    /**
     * Get Caption value
     * @return string|null
     */
    public function getCaption()
    {
        return $this->Caption;
    }
    /**
     * Set Caption value
     * @param string $caption
     * @return \akademia\StructType\OtherCharge
     */
    public function setCaption($caption = null)
    {
        // validation for constraint: string
        if (!is_null($caption) && !is_string($caption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caption, true), gettype($caption)), __LINE__);
        }
        $this->Caption = $caption;
        return $this;
    }
    /**
     * Get ChargeValue value
     * @return float|null
     */
    public function getChargeValue()
    {
        return $this->ChargeValue;
    }
    /**
     * Set ChargeValue value
     * @param float $chargeValue
     * @return \akademia\StructType\OtherCharge
     */
    public function setChargeValue($chargeValue = null)
    {
        // validation for constraint: float
        if (!is_null($chargeValue) && !(is_float($chargeValue) || is_numeric($chargeValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($chargeValue, true), gettype($chargeValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($chargeValue) && mb_strlen(mb_substr($chargeValue, false !== mb_strpos($chargeValue, '.') ? mb_strpos($chargeValue, '.') + 1 : mb_strlen($chargeValue))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($chargeValue, true), mb_strlen(mb_substr($chargeValue, mb_strpos($chargeValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($chargeValue) && mb_strlen(preg_replace('/(\D)/', '', $chargeValue)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($chargeValue, true), mb_strlen(preg_replace('/(\D)/', '', $chargeValue))), __LINE__);
        }
        $this->ChargeValue = $chargeValue;
        return $this;
    }
    /**
     * Get ChargeType value
     * @return string|null
     */
    public function getChargeType()
    {
        return $this->ChargeType;
    }
    /**
     * Set ChargeType value
     * @uses \akademia\EnumType\ChargeType::valueIsValid()
     * @uses \akademia\EnumType\ChargeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chargeType
     * @return \akademia\StructType\OtherCharge
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\ChargeType::valueIsValid($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\ChargeType', is_array($chargeType) ? implode(', ', $chargeType) : var_export($chargeType, true), implode(', ', \akademia\EnumType\ChargeType::getValidValues())), __LINE__);
        }
        $this->ChargeType = $chargeType;
        return $this;
    }
}
