<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelOptions StructType
 * Meta information extracted from the WSDL
 * - documentation: Label options that available for transport label, waybill document, shipment receipt and custom invoice document
 * @subpackage Structs
 * @version 2.2
 */
class LabelOptions extends AbstractStructBase
{
    /**
     * The CustomerLogo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\CustomerLogo
     */
    public $CustomerLogo;
    /**
     * The CustomerBarcode
     * Meta information extracted from the WSDL
     * - documentation: Customer barcode to be printed on supported transport label templates
     * - minOccurs: 0
     * @var \akademia\StructType\CustomerBarcode
     */
    public $CustomerBarcode;
    /**
     * The PrinterDPI
     * Meta information extracted from the WSDL
     * - documentation: Printer DPI Resolution for X-axis and Y-axis (in DPI) for transport label and waybill document output
     * - base: xsd:positiveInteger
     * - maxInclusive: 300
     * - minInclusive: 200
     * - minOccurs: 0
     * @var int
     */
    public $PrinterDPI;
    /**
     * The RequestWaybillDocument
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $RequestWaybillDocument;
    /**
     * The HideAccountInWaybillDocument
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $HideAccountInWaybillDocument;
    /**
     * The NumberOfWaybillDocumentCopies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NumberOfWaybillDocumentCopies;
    /**
     * The RequestDHLCustomsInvoice
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $RequestDHLCustomsInvoice;
    /**
     * The DHLCustomsInvoiceLanguageCode
     * Meta information extracted from the WSDL
     * - documentation: DHL Customs Invoice Language Code | eng for English
     * - base: xsd:string
     * - default: eng
     * - maxLength: 3
     * - minOccurs: 0
     * @var string
     */
    public $DHLCustomsInvoiceLanguageCode;
    /**
     * The DHLCustomsInvoiceLanguageCountryCode
     * Meta information extracted from the WSDL
     * - documentation: DHL Customs Invoice Language Country Code
     * - base: xsd:token
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $DHLCustomsInvoiceLanguageCountryCode;
    /**
     * The DHLCustomsInvoiceType
     * Meta information extracted from the WSDL
     * - default: COMMERCIAL_INVOICE
     * - minOccurs: 0
     * @var string
     */
    public $DHLCustomsInvoiceType;
    /**
     * The RequestShipmentReceipt
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $RequestShipmentReceipt;
    /**
     * The DetachOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\DetachOptions
     */
    public $DetachOptions;
    /**
     * The RequestBarcodeInfo
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $RequestBarcodeInfo;
    /**
     * The RequestLabelsToFitA4
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $RequestLabelsToFitA4;
    /**
     * The RequestDHLLogoOnLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestDHLLogoOnLabel;
    /**
     * The RequestTransportLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestTransportLabel;
    /**
     * The RequestQRCode
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $RequestQRCode;
    /**
     * Constructor method for LabelOptions
     * @uses LabelOptions::setCustomerLogo()
     * @uses LabelOptions::setCustomerBarcode()
     * @uses LabelOptions::setPrinterDPI()
     * @uses LabelOptions::setRequestWaybillDocument()
     * @uses LabelOptions::setHideAccountInWaybillDocument()
     * @uses LabelOptions::setNumberOfWaybillDocumentCopies()
     * @uses LabelOptions::setRequestDHLCustomsInvoice()
     * @uses LabelOptions::setDHLCustomsInvoiceLanguageCode()
     * @uses LabelOptions::setDHLCustomsInvoiceLanguageCountryCode()
     * @uses LabelOptions::setDHLCustomsInvoiceType()
     * @uses LabelOptions::setRequestShipmentReceipt()
     * @uses LabelOptions::setDetachOptions()
     * @uses LabelOptions::setRequestBarcodeInfo()
     * @uses LabelOptions::setRequestLabelsToFitA4()
     * @uses LabelOptions::setRequestDHLLogoOnLabel()
     * @uses LabelOptions::setRequestTransportLabel()
     * @uses LabelOptions::setRequestQRCode()
     * @param \akademia\StructType\CustomerLogo $customerLogo
     * @param \akademia\StructType\CustomerBarcode $customerBarcode
     * @param int $printerDPI
     * @param string $requestWaybillDocument
     * @param string $hideAccountInWaybillDocument
     * @param string $numberOfWaybillDocumentCopies
     * @param string $requestDHLCustomsInvoice
     * @param string $dHLCustomsInvoiceLanguageCode
     * @param string $dHLCustomsInvoiceLanguageCountryCode
     * @param string $dHLCustomsInvoiceType
     * @param string $requestShipmentReceipt
     * @param \akademia\StructType\DetachOptions $detachOptions
     * @param string $requestBarcodeInfo
     * @param string $requestLabelsToFitA4
     * @param string $requestDHLLogoOnLabel
     * @param string $requestTransportLabel
     * @param string $requestQRCode
     */
    public function __construct(\akademia\StructType\CustomerLogo $customerLogo = null, \akademia\StructType\CustomerBarcode $customerBarcode = null, $printerDPI = null, $requestWaybillDocument = 'N', $hideAccountInWaybillDocument = 'N', $numberOfWaybillDocumentCopies = null, $requestDHLCustomsInvoice = 'N', $dHLCustomsInvoiceLanguageCode = 'eng', $dHLCustomsInvoiceLanguageCountryCode = null, $dHLCustomsInvoiceType = 'COMMERCIAL_INVOICE', $requestShipmentReceipt = 'N', \akademia\StructType\DetachOptions $detachOptions = null, $requestBarcodeInfo = 'N', $requestLabelsToFitA4 = 'N', $requestDHLLogoOnLabel = null, $requestTransportLabel = null, $requestQRCode = 'N')
    {
        $this
            ->setCustomerLogo($customerLogo)
            ->setCustomerBarcode($customerBarcode)
            ->setPrinterDPI($printerDPI)
            ->setRequestWaybillDocument($requestWaybillDocument)
            ->setHideAccountInWaybillDocument($hideAccountInWaybillDocument)
            ->setNumberOfWaybillDocumentCopies($numberOfWaybillDocumentCopies)
            ->setRequestDHLCustomsInvoice($requestDHLCustomsInvoice)
            ->setDHLCustomsInvoiceLanguageCode($dHLCustomsInvoiceLanguageCode)
            ->setDHLCustomsInvoiceLanguageCountryCode($dHLCustomsInvoiceLanguageCountryCode)
            ->setDHLCustomsInvoiceType($dHLCustomsInvoiceType)
            ->setRequestShipmentReceipt($requestShipmentReceipt)
            ->setDetachOptions($detachOptions)
            ->setRequestBarcodeInfo($requestBarcodeInfo)
            ->setRequestLabelsToFitA4($requestLabelsToFitA4)
            ->setRequestDHLLogoOnLabel($requestDHLLogoOnLabel)
            ->setRequestTransportLabel($requestTransportLabel)
            ->setRequestQRCode($requestQRCode);
    }
    /**
     * Get CustomerLogo value
     * @return \akademia\StructType\CustomerLogo|null
     */
    public function getCustomerLogo()
    {
        return $this->CustomerLogo;
    }
    /**
     * Set CustomerLogo value
     * @param \akademia\StructType\CustomerLogo $customerLogo
     * @return \akademia\StructType\LabelOptions
     */
    public function setCustomerLogo(\akademia\StructType\CustomerLogo $customerLogo = null)
    {
        $this->CustomerLogo = $customerLogo;
        return $this;
    }
    /**
     * Get CustomerBarcode value
     * @return \akademia\StructType\CustomerBarcode|null
     */
    public function getCustomerBarcode()
    {
        return $this->CustomerBarcode;
    }
    /**
     * Set CustomerBarcode value
     * @param \akademia\StructType\CustomerBarcode $customerBarcode
     * @return \akademia\StructType\LabelOptions
     */
    public function setCustomerBarcode(\akademia\StructType\CustomerBarcode $customerBarcode = null)
    {
        $this->CustomerBarcode = $customerBarcode;
        return $this;
    }
    /**
     * Get PrinterDPI value
     * @return int|null
     */
    public function getPrinterDPI()
    {
        return $this->PrinterDPI;
    }
    /**
     * Set PrinterDPI value
     * @param int $printerDPI
     * @return \akademia\StructType\LabelOptions
     */
    public function setPrinterDPI($printerDPI = null)
    {
        // validation for constraint: int
        if (!is_null($printerDPI) && !(is_int($printerDPI) || ctype_digit($printerDPI))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printerDPI, true), gettype($printerDPI)), __LINE__);
        }
        // validation for constraint: maxInclusive(300)
        if (!is_null($printerDPI) && $printerDPI > 300) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 300', var_export($printerDPI, true)), __LINE__);
        }
        // validation for constraint: minInclusive(200)
        if (!is_null($printerDPI) && $printerDPI < 200) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 200', var_export($printerDPI, true)), __LINE__);
        }
        $this->PrinterDPI = $printerDPI;
        return $this;
    }
    /**
     * Get RequestWaybillDocument value
     * @return string|null
     */
    public function getRequestWaybillDocument()
    {
        return $this->RequestWaybillDocument;
    }
    /**
     * Set RequestWaybillDocument value
     * @uses \akademia\EnumType\RequestWaybillDocument::valueIsValid()
     * @uses \akademia\EnumType\RequestWaybillDocument::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestWaybillDocument
     * @return \akademia\StructType\LabelOptions
     */
    public function setRequestWaybillDocument($requestWaybillDocument = 'N')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\RequestWaybillDocument::valueIsValid($requestWaybillDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\RequestWaybillDocument', is_array($requestWaybillDocument) ? implode(', ', $requestWaybillDocument) : var_export($requestWaybillDocument, true), implode(', ', \akademia\EnumType\RequestWaybillDocument::getValidValues())), __LINE__);
        }
        $this->RequestWaybillDocument = $requestWaybillDocument;
        return $this;
    }
    /**
     * Get HideAccountInWaybillDocument value
     * @return string|null
     */
    public function getHideAccountInWaybillDocument()
    {
        return $this->HideAccountInWaybillDocument;
    }
    /**
     * Set HideAccountInWaybillDocument value
     * @uses \akademia\EnumType\HideAccountInWaybillDocument::valueIsValid()
     * @uses \akademia\EnumType\HideAccountInWaybillDocument::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hideAccountInWaybillDocument
     * @return \akademia\StructType\LabelOptions
     */
    public function setHideAccountInWaybillDocument($hideAccountInWaybillDocument = 'N')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\HideAccountInWaybillDocument::valueIsValid($hideAccountInWaybillDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\HideAccountInWaybillDocument', is_array($hideAccountInWaybillDocument) ? implode(', ', $hideAccountInWaybillDocument) : var_export($hideAccountInWaybillDocument, true), implode(', ', \akademia\EnumType\HideAccountInWaybillDocument::getValidValues())), __LINE__);
        }
        $this->HideAccountInWaybillDocument = $hideAccountInWaybillDocument;
        return $this;
    }
    /**
     * Get NumberOfWaybillDocumentCopies value
     * @return string|null
     */
    public function getNumberOfWaybillDocumentCopies()
    {
        return $this->NumberOfWaybillDocumentCopies;
    }
    /**
     * Set NumberOfWaybillDocumentCopies value
     * @uses \akademia\EnumType\NumberOfWaybillDocumentCopies::valueIsValid()
     * @uses \akademia\EnumType\NumberOfWaybillDocumentCopies::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfWaybillDocumentCopies
     * @return \akademia\StructType\LabelOptions
     */
    public function setNumberOfWaybillDocumentCopies($numberOfWaybillDocumentCopies = null)
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\NumberOfWaybillDocumentCopies::valueIsValid($numberOfWaybillDocumentCopies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\NumberOfWaybillDocumentCopies', is_array($numberOfWaybillDocumentCopies) ? implode(', ', $numberOfWaybillDocumentCopies) : var_export($numberOfWaybillDocumentCopies, true), implode(', ', \akademia\EnumType\NumberOfWaybillDocumentCopies::getValidValues())), __LINE__);
        }
        $this->NumberOfWaybillDocumentCopies = $numberOfWaybillDocumentCopies;
        return $this;
    }
    /**
     * Get RequestDHLCustomsInvoice value
     * @return string|null
     */
    public function getRequestDHLCustomsInvoice()
    {
        return $this->RequestDHLCustomsInvoice;
    }
    /**
     * Set RequestDHLCustomsInvoice value
     * @uses \akademia\EnumType\RequestDHLCustomsInvoice::valueIsValid()
     * @uses \akademia\EnumType\RequestDHLCustomsInvoice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestDHLCustomsInvoice
     * @return \akademia\StructType\LabelOptions
     */
    public function setRequestDHLCustomsInvoice($requestDHLCustomsInvoice = 'N')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\RequestDHLCustomsInvoice::valueIsValid($requestDHLCustomsInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\RequestDHLCustomsInvoice', is_array($requestDHLCustomsInvoice) ? implode(', ', $requestDHLCustomsInvoice) : var_export($requestDHLCustomsInvoice, true), implode(', ', \akademia\EnumType\RequestDHLCustomsInvoice::getValidValues())), __LINE__);
        }
        $this->RequestDHLCustomsInvoice = $requestDHLCustomsInvoice;
        return $this;
    }
    /**
     * Get DHLCustomsInvoiceLanguageCode value
     * @return string|null
     */
    public function getDHLCustomsInvoiceLanguageCode()
    {
        return $this->DHLCustomsInvoiceLanguageCode;
    }
    /**
     * Set DHLCustomsInvoiceLanguageCode value
     * @param string $dHLCustomsInvoiceLanguageCode
     * @return \akademia\StructType\LabelOptions
     */
    public function setDHLCustomsInvoiceLanguageCode($dHLCustomsInvoiceLanguageCode = 'eng')
    {
        // validation for constraint: string
        if (!is_null($dHLCustomsInvoiceLanguageCode) && !is_string($dHLCustomsInvoiceLanguageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dHLCustomsInvoiceLanguageCode, true), gettype($dHLCustomsInvoiceLanguageCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($dHLCustomsInvoiceLanguageCode) && mb_strlen($dHLCustomsInvoiceLanguageCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($dHLCustomsInvoiceLanguageCode)), __LINE__);
        }
        $this->DHLCustomsInvoiceLanguageCode = $dHLCustomsInvoiceLanguageCode;
        return $this;
    }
    /**
     * Get DHLCustomsInvoiceLanguageCountryCode value
     * @return string|null
     */
    public function getDHLCustomsInvoiceLanguageCountryCode()
    {
        return $this->DHLCustomsInvoiceLanguageCountryCode;
    }
    /**
     * Set DHLCustomsInvoiceLanguageCountryCode value
     * @param string $dHLCustomsInvoiceLanguageCountryCode
     * @return \akademia\StructType\LabelOptions
     */
    public function setDHLCustomsInvoiceLanguageCountryCode($dHLCustomsInvoiceLanguageCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($dHLCustomsInvoiceLanguageCountryCode) && !is_string($dHLCustomsInvoiceLanguageCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dHLCustomsInvoiceLanguageCountryCode, true), gettype($dHLCustomsInvoiceLanguageCountryCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($dHLCustomsInvoiceLanguageCountryCode) && mb_strlen($dHLCustomsInvoiceLanguageCountryCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($dHLCustomsInvoiceLanguageCountryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($dHLCustomsInvoiceLanguageCountryCode) && mb_strlen($dHLCustomsInvoiceLanguageCountryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($dHLCustomsInvoiceLanguageCountryCode)), __LINE__);
        }
        $this->DHLCustomsInvoiceLanguageCountryCode = $dHLCustomsInvoiceLanguageCountryCode;
        return $this;
    }
    /**
     * Get DHLCustomsInvoiceType value
     * @return string|null
     */
    public function getDHLCustomsInvoiceType()
    {
        return $this->DHLCustomsInvoiceType;
    }
    /**
     * Set DHLCustomsInvoiceType value
     * @uses \akademia\EnumType\DHLCustomsInvoiceType::valueIsValid()
     * @uses \akademia\EnumType\DHLCustomsInvoiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dHLCustomsInvoiceType
     * @return \akademia\StructType\LabelOptions
     */
    public function setDHLCustomsInvoiceType($dHLCustomsInvoiceType = 'COMMERCIAL_INVOICE')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\DHLCustomsInvoiceType::valueIsValid($dHLCustomsInvoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\DHLCustomsInvoiceType', is_array($dHLCustomsInvoiceType) ? implode(', ', $dHLCustomsInvoiceType) : var_export($dHLCustomsInvoiceType, true), implode(', ', \akademia\EnumType\DHLCustomsInvoiceType::getValidValues())), __LINE__);
        }
        $this->DHLCustomsInvoiceType = $dHLCustomsInvoiceType;
        return $this;
    }
    /**
     * Get RequestShipmentReceipt value
     * @return string|null
     */
    public function getRequestShipmentReceipt()
    {
        return $this->RequestShipmentReceipt;
    }
    /**
     * Set RequestShipmentReceipt value
     * @uses \akademia\EnumType\RequestShipmentReceipt::valueIsValid()
     * @uses \akademia\EnumType\RequestShipmentReceipt::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestShipmentReceipt
     * @return \akademia\StructType\LabelOptions
     */
    public function setRequestShipmentReceipt($requestShipmentReceipt = 'N')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\RequestShipmentReceipt::valueIsValid($requestShipmentReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\RequestShipmentReceipt', is_array($requestShipmentReceipt) ? implode(', ', $requestShipmentReceipt) : var_export($requestShipmentReceipt, true), implode(', ', \akademia\EnumType\RequestShipmentReceipt::getValidValues())), __LINE__);
        }
        $this->RequestShipmentReceipt = $requestShipmentReceipt;
        return $this;
    }
    /**
     * Get DetachOptions value
     * @return \akademia\StructType\DetachOptions|null
     */
    public function getDetachOptions()
    {
        return $this->DetachOptions;
    }
    /**
     * Set DetachOptions value
     * @param \akademia\StructType\DetachOptions $detachOptions
     * @return \akademia\StructType\LabelOptions
     */
    public function setDetachOptions(\akademia\StructType\DetachOptions $detachOptions = null)
    {
        $this->DetachOptions = $detachOptions;
        return $this;
    }
    /**
     * Get RequestBarcodeInfo value
     * @return string|null
     */
    public function getRequestBarcodeInfo()
    {
        return $this->RequestBarcodeInfo;
    }
    /**
     * Set RequestBarcodeInfo value
     * @uses \akademia\EnumType\RequestBarcodeInfo::valueIsValid()
     * @uses \akademia\EnumType\RequestBarcodeInfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestBarcodeInfo
     * @return \akademia\StructType\LabelOptions
     */
    public function setRequestBarcodeInfo($requestBarcodeInfo = 'N')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\RequestBarcodeInfo::valueIsValid($requestBarcodeInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\RequestBarcodeInfo', is_array($requestBarcodeInfo) ? implode(', ', $requestBarcodeInfo) : var_export($requestBarcodeInfo, true), implode(', ', \akademia\EnumType\RequestBarcodeInfo::getValidValues())), __LINE__);
        }
        $this->RequestBarcodeInfo = $requestBarcodeInfo;
        return $this;
    }
    /**
     * Get RequestLabelsToFitA4 value
     * @return string|null
     */
    public function getRequestLabelsToFitA4()
    {
        return $this->RequestLabelsToFitA4;
    }
    /**
     * Set RequestLabelsToFitA4 value
     * @uses \akademia\EnumType\RequestLabelsToFitA4::valueIsValid()
     * @uses \akademia\EnumType\RequestLabelsToFitA4::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestLabelsToFitA4
     * @return \akademia\StructType\LabelOptions
     */
    public function setRequestLabelsToFitA4($requestLabelsToFitA4 = 'N')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\RequestLabelsToFitA4::valueIsValid($requestLabelsToFitA4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\RequestLabelsToFitA4', is_array($requestLabelsToFitA4) ? implode(', ', $requestLabelsToFitA4) : var_export($requestLabelsToFitA4, true), implode(', ', \akademia\EnumType\RequestLabelsToFitA4::getValidValues())), __LINE__);
        }
        $this->RequestLabelsToFitA4 = $requestLabelsToFitA4;
        return $this;
    }
    /**
     * Get RequestDHLLogoOnLabel value
     * @return string|null
     */
    public function getRequestDHLLogoOnLabel()
    {
        return $this->RequestDHLLogoOnLabel;
    }
    /**
     * Set RequestDHLLogoOnLabel value
     * @uses \akademia\EnumType\RequestDHLLogoOnLabel::valueIsValid()
     * @uses \akademia\EnumType\RequestDHLLogoOnLabel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestDHLLogoOnLabel
     * @return \akademia\StructType\LabelOptions
     */
    public function setRequestDHLLogoOnLabel($requestDHLLogoOnLabel = null)
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\RequestDHLLogoOnLabel::valueIsValid($requestDHLLogoOnLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\RequestDHLLogoOnLabel', is_array($requestDHLLogoOnLabel) ? implode(', ', $requestDHLLogoOnLabel) : var_export($requestDHLLogoOnLabel, true), implode(', ', \akademia\EnumType\RequestDHLLogoOnLabel::getValidValues())), __LINE__);
        }
        $this->RequestDHLLogoOnLabel = $requestDHLLogoOnLabel;
        return $this;
    }
    /**
     * Get RequestTransportLabel value
     * @return string|null
     */
    public function getRequestTransportLabel()
    {
        return $this->RequestTransportLabel;
    }
    /**
     * Set RequestTransportLabel value
     * @uses \akademia\EnumType\RequestTransportLabel::valueIsValid()
     * @uses \akademia\EnumType\RequestTransportLabel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestTransportLabel
     * @return \akademia\StructType\LabelOptions
     */
    public function setRequestTransportLabel($requestTransportLabel = null)
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\RequestTransportLabel::valueIsValid($requestTransportLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\RequestTransportLabel', is_array($requestTransportLabel) ? implode(', ', $requestTransportLabel) : var_export($requestTransportLabel, true), implode(', ', \akademia\EnumType\RequestTransportLabel::getValidValues())), __LINE__);
        }
        $this->RequestTransportLabel = $requestTransportLabel;
        return $this;
    }
    /**
     * Get RequestQRCode value
     * @return string|null
     */
    public function getRequestQRCode()
    {
        return $this->RequestQRCode;
    }
    /**
     * Set RequestQRCode value
     * @uses \akademia\EnumType\RequestQRCode::valueIsValid()
     * @uses \akademia\EnumType\RequestQRCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestQRCode
     * @return \akademia\StructType\LabelOptions
     */
    public function setRequestQRCode($requestQRCode = 'N')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\RequestQRCode::valueIsValid($requestQRCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\RequestQRCode', is_array($requestQRCode) ? implode(', ', $requestQRCode) : var_export($requestQRCode, true), implode(', ', \akademia\EnumType\RequestQRCode::getValidValues())), __LINE__);
        }
        $this->RequestQRCode = $requestQRCode;
        return $this;
    }
}
