<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceSignatureDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: Custom Invoice Signature details
 * @subpackage Structs
 * @version 2.2
 */
class InvoiceSignatureDetails extends AbstractStructBase
{
    /**
     * The SignatureName
     * Meta information extracted from the WSDL
     * - documentation: Name of signatory | Signature name
     * - base: xsd:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $SignatureName;
    /**
     * The SignatureTitle
     * Meta information extracted from the WSDL
     * - documentation: Title of signatory | Signature title
     * - base: xsd:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $SignatureTitle;
    /**
     * The SignatureImage
     * Meta information extracted from the WSDL
     * - documentation: Signature image in base64 format. Max of size is 1 MB. Valid format of image are: PNG, GIF, JPEG, JPG | SignatureImage
     * - base: xsd:base64Binary
     * - maxLength: 1048576
     * - minOccurs: 0
     * @var string
     */
    public $SignatureImage;
    /**
     * Constructor method for InvoiceSignatureDetails
     * @uses InvoiceSignatureDetails::setSignatureName()
     * @uses InvoiceSignatureDetails::setSignatureTitle()
     * @uses InvoiceSignatureDetails::setSignatureImage()
     * @param string $signatureName
     * @param string $signatureTitle
     * @param string $signatureImage
     */
    public function __construct($signatureName = null, $signatureTitle = null, $signatureImage = null)
    {
        $this
            ->setSignatureName($signatureName)
            ->setSignatureTitle($signatureTitle)
            ->setSignatureImage($signatureImage);
    }
    /**
     * Get SignatureName value
     * @return string|null
     */
    public function getSignatureName()
    {
        return $this->SignatureName;
    }
    /**
     * Set SignatureName value
     * @param string $signatureName
     * @return \akademia\StructType\InvoiceSignatureDetails
     */
    public function setSignatureName($signatureName = null)
    {
        // validation for constraint: string
        if (!is_null($signatureName) && !is_string($signatureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatureName, true), gettype($signatureName)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($signatureName) && mb_strlen($signatureName) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($signatureName)), __LINE__);
        }
        $this->SignatureName = $signatureName;
        return $this;
    }
    /**
     * Get SignatureTitle value
     * @return string|null
     */
    public function getSignatureTitle()
    {
        return $this->SignatureTitle;
    }
    /**
     * Set SignatureTitle value
     * @param string $signatureTitle
     * @return \akademia\StructType\InvoiceSignatureDetails
     */
    public function setSignatureTitle($signatureTitle = null)
    {
        // validation for constraint: string
        if (!is_null($signatureTitle) && !is_string($signatureTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatureTitle, true), gettype($signatureTitle)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($signatureTitle) && mb_strlen($signatureTitle) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($signatureTitle)), __LINE__);
        }
        $this->SignatureTitle = $signatureTitle;
        return $this;
    }
    /**
     * Get SignatureImage value
     * @return string|null
     */
    public function getSignatureImage()
    {
        return $this->SignatureImage;
    }
    /**
     * Set SignatureImage value
     * @param string $signatureImage
     * @return \akademia\StructType\InvoiceSignatureDetails
     */
    public function setSignatureImage($signatureImage = null)
    {
        // validation for constraint: string
        if (!is_null($signatureImage) && !is_string($signatureImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatureImage, true), gettype($signatureImage)), __LINE__);
        }
        // validation for constraint: maxLength(1048576)
        if (!is_null($signatureImage) && mb_strlen($signatureImage) > 1048576) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1048576', mb_strlen($signatureImage)), __LINE__);
        }
        $this->SignatureImage = $signatureImage;
        return $this;
    }
}
