<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsCharacteristicsType StructType
 * @subpackage Structs
 * @version 2.2
 */
class GoodsCharacteristicsType extends AbstractStructBase
{
    /**
     * The GoodsCharacteristic
     * Meta information extracted from the WSDL
     * - documentation: Goods characteristics for the line item
     * - maxOccurs: 999
     * @var \akademia\StructType\GoodsCharacteristicType[]
     */
    public $GoodsCharacteristic;
    /**
     * Constructor method for GoodsCharacteristicsType
     * @uses GoodsCharacteristicsType::setGoodsCharacteristic()
     * @param \akademia\StructType\GoodsCharacteristicType[] $goodsCharacteristic
     */
    public function __construct(array $goodsCharacteristic = array())
    {
        $this
            ->setGoodsCharacteristic($goodsCharacteristic);
    }
    /**
     * Get GoodsCharacteristic value
     * @return \akademia\StructType\GoodsCharacteristicType[]|null
     */
    public function getGoodsCharacteristic()
    {
        return $this->GoodsCharacteristic;
    }
    /**
     * This method is responsible for validating the values passed to the setGoodsCharacteristic method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsCharacteristic method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsCharacteristicForArrayConstraintsFromSetGoodsCharacteristic(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsCharacteristicsTypeGoodsCharacteristicItem) {
            // validation for constraint: itemType
            if (!$goodsCharacteristicsTypeGoodsCharacteristicItem instanceof \akademia\StructType\GoodsCharacteristicType) {
                $invalidValues[] = is_object($goodsCharacteristicsTypeGoodsCharacteristicItem) ? get_class($goodsCharacteristicsTypeGoodsCharacteristicItem) : sprintf('%s(%s)', gettype($goodsCharacteristicsTypeGoodsCharacteristicItem), var_export($goodsCharacteristicsTypeGoodsCharacteristicItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsCharacteristic property can only contain items of type \akademia\StructType\GoodsCharacteristicType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GoodsCharacteristic value
     * @throws \InvalidArgumentException
     * @param \akademia\StructType\GoodsCharacteristicType[] $goodsCharacteristic
     * @return \akademia\StructType\GoodsCharacteristicsType
     */
    public function setGoodsCharacteristic(array $goodsCharacteristic = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsCharacteristicArrayErrorMessage = self::validateGoodsCharacteristicForArrayConstraintsFromSetGoodsCharacteristic($goodsCharacteristic))) {
            throw new \InvalidArgumentException($goodsCharacteristicArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($goodsCharacteristic) && count($goodsCharacteristic) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999', count($goodsCharacteristic)), __LINE__);
        }
        $this->GoodsCharacteristic = $goodsCharacteristic;
        return $this;
    }
    /**
     * Add item to GoodsCharacteristic value
     * @throws \InvalidArgumentException
     * @param \akademia\StructType\GoodsCharacteristicType $item
     * @return \akademia\StructType\GoodsCharacteristicsType
     */
    public function addToGoodsCharacteristic(\akademia\StructType\GoodsCharacteristicType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \akademia\StructType\GoodsCharacteristicType) {
            throw new \InvalidArgumentException(sprintf('The GoodsCharacteristic property can only contain items of type \akademia\StructType\GoodsCharacteristicType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($this->GoodsCharacteristic) && count($this->GoodsCharacteristic) >= 999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999', count($this->GoodsCharacteristic)), __LINE__);
        }
        $this->GoodsCharacteristic[] = $item;
        return $this;
    }
}
