<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentImage StructType
 * Meta information extracted from the WSDL
 * - documentation: Custom Clearance Document Image
 * @subpackage Structs
 * @version 2.2
 */
class DocumentImage extends AbstractStructBase
{
    /**
     * The DocumentImageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentImageType;
    /**
     * The DocumentImage
     * @var \akademia\StructType\DocumentImage
     */
    public $DocumentImage;
    /**
     * The DocumentImageFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentImageFormat;
    /**
     * Constructor method for DocumentImage
     * @uses DocumentImage::setDocumentImageType()
     * @uses DocumentImage::setDocumentImage()
     * @uses DocumentImage::setDocumentImageFormat()
     * @param string $documentImageType
     * @param \akademia\StructType\DocumentImage $documentImage
     * @param string $documentImageFormat
     */
    public function __construct($documentImageType = null, \akademia\StructType\DocumentImage $documentImage = null, $documentImageFormat = null)
    {
        $this
            ->setDocumentImageType($documentImageType)
            ->setDocumentImage($documentImage)
            ->setDocumentImageFormat($documentImageFormat);
    }
    /**
     * Get DocumentImageType value
     * @return string|null
     */
    public function getDocumentImageType()
    {
        return $this->DocumentImageType;
    }
    /**
     * Set DocumentImageType value
     * @uses \akademia\EnumType\DocumentImageType::valueIsValid()
     * @uses \akademia\EnumType\DocumentImageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentImageType
     * @return \akademia\StructType\DocumentImage
     */
    public function setDocumentImageType($documentImageType = null)
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\DocumentImageType::valueIsValid($documentImageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\DocumentImageType', is_array($documentImageType) ? implode(', ', $documentImageType) : var_export($documentImageType, true), implode(', ', \akademia\EnumType\DocumentImageType::getValidValues())), __LINE__);
        }
        $this->DocumentImageType = $documentImageType;
        return $this;
    }
    /**
     * Get DocumentImage value
     * @return \akademia\StructType\DocumentImage|null
     */
    public function getDocumentImage()
    {
        return $this->DocumentImage;
    }
    /**
     * Set DocumentImage value
     * @param \akademia\StructType\DocumentImage $documentImage
     * @return \akademia\StructType\DocumentImage
     */
    public function setDocumentImage(\akademia\StructType\DocumentImage $documentImage = null)
    {
        $this->DocumentImage = $documentImage;
        return $this;
    }
    /**
     * Get DocumentImageFormat value
     * @return string|null
     */
    public function getDocumentImageFormat()
    {
        return $this->DocumentImageFormat;
    }
    /**
     * Set DocumentImageFormat value
     * @uses \akademia\EnumType\DocumentImageFormat::valueIsValid()
     * @uses \akademia\EnumType\DocumentImageFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentImageFormat
     * @return \akademia\StructType\DocumentImage
     */
    public function setDocumentImageFormat($documentImageFormat = null)
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\DocumentImageFormat::valueIsValid($documentImageFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\DocumentImageFormat', is_array($documentImageFormat) ? implode(', ', $documentImageFormat) : var_export($documentImageFormat, true), implode(', ', \akademia\EnumType\DocumentImageFormat::getValidValues())), __LINE__);
        }
        $this->DocumentImageFormat = $documentImageFormat;
        return $this;
    }
}
