<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_TotalNetType StructType
 * @subpackage Structs
 * @version 2.2
 */
class DocTypeRef_TotalNetType extends AbstractStructBase
{
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - documentation: Identifies the currency of the rate
     * @var string
     */
    public $Currency;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Identifies the rate price.
     * @var string
     */
    public $Amount;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $type;
    /**
     * Constructor method for docTypeRef_TotalNetType
     * @uses DocTypeRef_TotalNetType::setCurrency()
     * @uses DocTypeRef_TotalNetType::setAmount()
     * @uses DocTypeRef_TotalNetType::setType()
     * @param string $currency
     * @param string $amount
     * @param string $type
     */
    public function __construct($currency = null, $amount = null, $type = null)
    {
        $this
            ->setCurrency($currency)
            ->setAmount($amount)
            ->setType($type);
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \akademia\StructType\DocTypeRef_TotalNetType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \akademia\StructType\DocTypeRef_TotalNetType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \akademia\StructType\DocTypeRef_TotalNetType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
