<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ServiceAreaType StructType
 * @subpackage Structs
 * @version 2.2
 */
class DocTypeRef_ServiceAreaType extends AbstractStructBase
{
    /**
     * The FacilityCode
     * Meta information extracted from the WSDL
     * - documentation: The DHL Facility Code for the Origin/Destination
     * - minOccurs: 0
     * @var string
     */
    public $FacilityCode;
    /**
     * The ServiceAreaCode
     * Meta information extracted from the WSDL
     * - documentation: The DHL Service Area Code for the origin/destination of the Shipment
     * - minOccurs: 0
     * @var string
     */
    public $ServiceAreaCode;
    /**
     * Constructor method for docTypeRef_ServiceAreaType
     * @uses DocTypeRef_ServiceAreaType::setFacilityCode()
     * @uses DocTypeRef_ServiceAreaType::setServiceAreaCode()
     * @param string $facilityCode
     * @param string $serviceAreaCode
     */
    public function __construct($facilityCode = null, $serviceAreaCode = null)
    {
        $this
            ->setFacilityCode($facilityCode)
            ->setServiceAreaCode($serviceAreaCode);
    }
    /**
     * Get FacilityCode value
     * @return string|null
     */
    public function getFacilityCode()
    {
        return $this->FacilityCode;
    }
    /**
     * Set FacilityCode value
     * @param string $facilityCode
     * @return \akademia\StructType\DocTypeRef_ServiceAreaType
     */
    public function setFacilityCode($facilityCode = null)
    {
        // validation for constraint: string
        if (!is_null($facilityCode) && !is_string($facilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facilityCode, true), gettype($facilityCode)), __LINE__);
        }
        $this->FacilityCode = $facilityCode;
        return $this;
    }
    /**
     * Get ServiceAreaCode value
     * @return string|null
     */
    public function getServiceAreaCode()
    {
        return $this->ServiceAreaCode;
    }
    /**
     * Set ServiceAreaCode value
     * @param string $serviceAreaCode
     * @return \akademia\StructType\DocTypeRef_ServiceAreaType
     */
    public function setServiceAreaCode($serviceAreaCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAreaCode) && !is_string($serviceAreaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceAreaCode, true), gettype($serviceAreaCode)), __LINE__);
        }
        $this->ServiceAreaCode = $serviceAreaCode;
        return $this;
    }
}
