<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ProcessShipmentRequestType StructType
 * @subpackage Structs
 * @version 2.2
 */
class DocTypeRef_ProcessShipmentRequestType extends AbstractStructBase
{
    /**
     * The MessageId
     * Meta information extracted from the WSDL
     * - documentation: logging end to end token
     * - base: xsd:string
     * - maxLength: 200
     * - minOccurs: 0
     * @var string
     */
    public $MessageId;
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\Request
     */
    public $Request;
    /**
     * The ClientDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\DocTypeRef_ClientDetailType2
     */
    public $ClientDetail;
    /**
     * The RequestedShipment
     * @var \akademia\StructType\DocTypeRef_RequestedShipmentType
     */
    public $RequestedShipment;
    /**
     * Constructor method for docTypeRef_ProcessShipmentRequestType
     * @uses DocTypeRef_ProcessShipmentRequestType::setMessageId()
     * @uses DocTypeRef_ProcessShipmentRequestType::setRequest()
     * @uses DocTypeRef_ProcessShipmentRequestType::setClientDetail()
     * @uses DocTypeRef_ProcessShipmentRequestType::setRequestedShipment()
     * @param string $messageId
     * @param \akademia\StructType\Request $request
     * @param \akademia\StructType\DocTypeRef_ClientDetailType2 $clientDetail
     * @param \akademia\StructType\DocTypeRef_RequestedShipmentType $requestedShipment
     */
    public function __construct($messageId = null, \akademia\StructType\Request $request = null, \akademia\StructType\DocTypeRef_ClientDetailType2 $clientDetail = null, \akademia\StructType\DocTypeRef_RequestedShipmentType $requestedShipment = null)
    {
        $this
            ->setMessageId($messageId)
            ->setRequest($request)
            ->setClientDetail($clientDetail)
            ->setRequestedShipment($requestedShipment);
    }
    /**
     * Get MessageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->MessageId;
    }
    /**
     * Set MessageId value
     * @param string $messageId
     * @return \akademia\StructType\DocTypeRef_ProcessShipmentRequestType
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: string
        if (!is_null($messageId) && !is_string($messageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageId, true), gettype($messageId)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($messageId) && mb_strlen($messageId) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($messageId)), __LINE__);
        }
        $this->MessageId = $messageId;
        return $this;
    }
    /**
     * Get Request value
     * @return \akademia\StructType\Request|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \akademia\StructType\Request $request
     * @return \akademia\StructType\DocTypeRef_ProcessShipmentRequestType
     */
    public function setRequest(\akademia\StructType\Request $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get ClientDetail value
     * @return \akademia\StructType\DocTypeRef_ClientDetailType2|null
     */
    public function getClientDetail()
    {
        return $this->ClientDetail;
    }
    /**
     * Set ClientDetail value
     * @param \akademia\StructType\DocTypeRef_ClientDetailType2 $clientDetail
     * @return \akademia\StructType\DocTypeRef_ProcessShipmentRequestType
     */
    public function setClientDetail(\akademia\StructType\DocTypeRef_ClientDetailType2 $clientDetail = null)
    {
        $this->ClientDetail = $clientDetail;
        return $this;
    }
    /**
     * Get RequestedShipment value
     * @return \akademia\StructType\DocTypeRef_RequestedShipmentType|null
     */
    public function getRequestedShipment()
    {
        return $this->RequestedShipment;
    }
    /**
     * Set RequestedShipment value
     * @param \akademia\StructType\DocTypeRef_RequestedShipmentType $requestedShipment
     * @return \akademia\StructType\DocTypeRef_ProcessShipmentRequestType
     */
    public function setRequestedShipment(\akademia\StructType\DocTypeRef_RequestedShipmentType $requestedShipment = null)
    {
        $this->RequestedShipment = $requestedShipment;
        return $this;
    }
}
