<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ContactInfoType StructType
 * @subpackage Structs
 * @version 2.2
 */
class DocTypeRef_ContactInfoType extends AbstractStructBase
{
    /**
     * The Contact
     * @var \akademia\StructType\DocTypeRef_ContactType
     */
    public $Contact;
    /**
     * The Address
     * @var \akademia\StructType\DocTypeRef_AddressType
     */
    public $Address;
    /**
     * The RegistrationNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\DocTypeRef_RegistrationNumbers
     */
    public $RegistrationNumbers;
    /**
     * The BankDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\DocTypeRef_BankDetails
     */
    public $BankDetails;
    /**
     * The BusinessPartyTypeCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $BusinessPartyTypeCode;
    /**
     * Constructor method for docTypeRef_ContactInfoType
     * @uses DocTypeRef_ContactInfoType::setContact()
     * @uses DocTypeRef_ContactInfoType::setAddress()
     * @uses DocTypeRef_ContactInfoType::setRegistrationNumbers()
     * @uses DocTypeRef_ContactInfoType::setBankDetails()
     * @uses DocTypeRef_ContactInfoType::setBusinessPartyTypeCode()
     * @param \akademia\StructType\DocTypeRef_ContactType $contact
     * @param \akademia\StructType\DocTypeRef_AddressType $address
     * @param \akademia\StructType\DocTypeRef_RegistrationNumbers $registrationNumbers
     * @param \akademia\StructType\DocTypeRef_BankDetails $bankDetails
     * @param string $businessPartyTypeCode
     */
    public function __construct(\akademia\StructType\DocTypeRef_ContactType $contact = null, \akademia\StructType\DocTypeRef_AddressType $address = null, \akademia\StructType\DocTypeRef_RegistrationNumbers $registrationNumbers = null, \akademia\StructType\DocTypeRef_BankDetails $bankDetails = null, $businessPartyTypeCode = null)
    {
        $this
            ->setContact($contact)
            ->setAddress($address)
            ->setRegistrationNumbers($registrationNumbers)
            ->setBankDetails($bankDetails)
            ->setBusinessPartyTypeCode($businessPartyTypeCode);
    }
    /**
     * Get Contact value
     * @return \akademia\StructType\DocTypeRef_ContactType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \akademia\StructType\DocTypeRef_ContactType $contact
     * @return \akademia\StructType\DocTypeRef_ContactInfoType
     */
    public function setContact(\akademia\StructType\DocTypeRef_ContactType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Address value
     * @return \akademia\StructType\DocTypeRef_AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \akademia\StructType\DocTypeRef_AddressType $address
     * @return \akademia\StructType\DocTypeRef_ContactInfoType
     */
    public function setAddress(\akademia\StructType\DocTypeRef_AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get RegistrationNumbers value
     * @return \akademia\StructType\DocTypeRef_RegistrationNumbers|null
     */
    public function getRegistrationNumbers()
    {
        return $this->RegistrationNumbers;
    }
    /**
     * Set RegistrationNumbers value
     * @param \akademia\StructType\DocTypeRef_RegistrationNumbers $registrationNumbers
     * @return \akademia\StructType\DocTypeRef_ContactInfoType
     */
    public function setRegistrationNumbers(\akademia\StructType\DocTypeRef_RegistrationNumbers $registrationNumbers = null)
    {
        $this->RegistrationNumbers = $registrationNumbers;
        return $this;
    }
    /**
     * Get BankDetails value
     * @return \akademia\StructType\DocTypeRef_BankDetails|null
     */
    public function getBankDetails()
    {
        return $this->BankDetails;
    }
    /**
     * Set BankDetails value
     * @param \akademia\StructType\DocTypeRef_BankDetails $bankDetails
     * @return \akademia\StructType\DocTypeRef_ContactInfoType
     */
    public function setBankDetails(\akademia\StructType\DocTypeRef_BankDetails $bankDetails = null)
    {
        $this->BankDetails = $bankDetails;
        return $this;
    }
    /**
     * Get BusinessPartyTypeCode value
     * @return string|null
     */
    public function getBusinessPartyTypeCode()
    {
        return $this->BusinessPartyTypeCode;
    }
    /**
     * Set BusinessPartyTypeCode value
     * @param string $businessPartyTypeCode
     * @return \akademia\StructType\DocTypeRef_ContactInfoType
     */
    public function setBusinessPartyTypeCode($businessPartyTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($businessPartyTypeCode) && !is_string($businessPartyTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessPartyTypeCode, true), gettype($businessPartyTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($businessPartyTypeCode) && mb_strlen($businessPartyTypeCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($businessPartyTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($businessPartyTypeCode) && mb_strlen($businessPartyTypeCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($businessPartyTypeCode)), __LINE__);
        }
        $this->BusinessPartyTypeCode = $businessPartyTypeCode;
        return $this;
    }
}
