<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Billing StructType
 * @subpackage Structs
 * @version 2.2
 */
class Billing extends AbstractStructBase
{
    /**
     * The ShipperAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: The DHL account number used for the shipment. Used as the shipper account number. Please note if you use this billing section then the above 'Account'tag is not needed. 'ShipperAccountNumber' is mandatory then.
     * - base: xsd:string
     * - maxLength: 12
     * - minLength: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ShipperAccountNumber;
    /**
     * The ShippingPaymentType
     * @var string
     */
    public $ShippingPaymentType;
    /**
     * The BillingAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: The DHL account number used for the shipment, if ShippingPaymentType is equal to R or T.
     * - base: xsd:string
     * - maxLength: 12
     * - minLength: 0
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $BillingAccountNumber;
    /**
     * The DutyAndTaxPayerAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: The DHL account number used for duties and tax payments.
     * - base: xsd:string
     * - maxLength: 12
     * - minLength: 0
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $DutyAndTaxPayerAccountNumber;
    /**
     * The ShipmentPrepaidTotalCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\ShipmentPrepaidTotalCharge
     */
    public $ShipmentPrepaidTotalCharge;
    /**
     * Constructor method for Billing
     * @uses Billing::setShipperAccountNumber()
     * @uses Billing::setShippingPaymentType()
     * @uses Billing::setBillingAccountNumber()
     * @uses Billing::setDutyAndTaxPayerAccountNumber()
     * @uses Billing::setShipmentPrepaidTotalCharge()
     * @param string $shipperAccountNumber
     * @param string $shippingPaymentType
     * @param string $billingAccountNumber
     * @param string $dutyAndTaxPayerAccountNumber
     * @param \akademia\StructType\ShipmentPrepaidTotalCharge $shipmentPrepaidTotalCharge
     */
    public function __construct($shipperAccountNumber = null, $shippingPaymentType = null, $billingAccountNumber = null, $dutyAndTaxPayerAccountNumber = null, \akademia\StructType\ShipmentPrepaidTotalCharge $shipmentPrepaidTotalCharge = null)
    {
        $this
            ->setShipperAccountNumber($shipperAccountNumber)
            ->setShippingPaymentType($shippingPaymentType)
            ->setBillingAccountNumber($billingAccountNumber)
            ->setDutyAndTaxPayerAccountNumber($dutyAndTaxPayerAccountNumber)
            ->setShipmentPrepaidTotalCharge($shipmentPrepaidTotalCharge);
    }
    /**
     * Get ShipperAccountNumber value
     * @return string|null
     */
    public function getShipperAccountNumber()
    {
        return $this->ShipperAccountNumber;
    }
    /**
     * Set ShipperAccountNumber value
     * @param string $shipperAccountNumber
     * @return \akademia\StructType\Billing
     */
    public function setShipperAccountNumber($shipperAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipperAccountNumber) && !is_string($shipperAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperAccountNumber, true), gettype($shipperAccountNumber)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($shipperAccountNumber) && mb_strlen($shipperAccountNumber) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($shipperAccountNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($shipperAccountNumber) && mb_strlen($shipperAccountNumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($shipperAccountNumber)), __LINE__);
        }
        $this->ShipperAccountNumber = $shipperAccountNumber;
        return $this;
    }
    /**
     * Get ShippingPaymentType value
     * @return string|null
     */
    public function getShippingPaymentType()
    {
        return $this->ShippingPaymentType;
    }
    /**
     * Set ShippingPaymentType value
     * @uses \akademia\EnumType\ShipmentPaymentType::valueIsValid()
     * @uses \akademia\EnumType\ShipmentPaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shippingPaymentType
     * @return \akademia\StructType\Billing
     */
    public function setShippingPaymentType($shippingPaymentType = null)
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\ShipmentPaymentType::valueIsValid($shippingPaymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\ShipmentPaymentType', is_array($shippingPaymentType) ? implode(', ', $shippingPaymentType) : var_export($shippingPaymentType, true), implode(', ', \akademia\EnumType\ShipmentPaymentType::getValidValues())), __LINE__);
        }
        $this->ShippingPaymentType = $shippingPaymentType;
        return $this;
    }
    /**
     * Get BillingAccountNumber value
     * @return string|null
     */
    public function getBillingAccountNumber()
    {
        return $this->BillingAccountNumber;
    }
    /**
     * Set BillingAccountNumber value
     * @param string $billingAccountNumber
     * @return \akademia\StructType\Billing
     */
    public function setBillingAccountNumber($billingAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingAccountNumber) && !is_string($billingAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingAccountNumber, true), gettype($billingAccountNumber)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($billingAccountNumber) && mb_strlen($billingAccountNumber) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($billingAccountNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($billingAccountNumber) && mb_strlen($billingAccountNumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($billingAccountNumber)), __LINE__);
        }
        $this->BillingAccountNumber = $billingAccountNumber;
        return $this;
    }
    /**
     * Get DutyAndTaxPayerAccountNumber value
     * @return string|null
     */
    public function getDutyAndTaxPayerAccountNumber()
    {
        return $this->DutyAndTaxPayerAccountNumber;
    }
    /**
     * Set DutyAndTaxPayerAccountNumber value
     * @param string $dutyAndTaxPayerAccountNumber
     * @return \akademia\StructType\Billing
     */
    public function setDutyAndTaxPayerAccountNumber($dutyAndTaxPayerAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dutyAndTaxPayerAccountNumber) && !is_string($dutyAndTaxPayerAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dutyAndTaxPayerAccountNumber, true), gettype($dutyAndTaxPayerAccountNumber)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($dutyAndTaxPayerAccountNumber) && mb_strlen($dutyAndTaxPayerAccountNumber) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($dutyAndTaxPayerAccountNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($dutyAndTaxPayerAccountNumber) && mb_strlen($dutyAndTaxPayerAccountNumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($dutyAndTaxPayerAccountNumber)), __LINE__);
        }
        $this->DutyAndTaxPayerAccountNumber = $dutyAndTaxPayerAccountNumber;
        return $this;
    }
    /**
     * Get ShipmentPrepaidTotalCharge value
     * @return \akademia\StructType\ShipmentPrepaidTotalCharge|null
     */
    public function getShipmentPrepaidTotalCharge()
    {
        return $this->ShipmentPrepaidTotalCharge;
    }
    /**
     * Set ShipmentPrepaidTotalCharge value
     * @param \akademia\StructType\ShipmentPrepaidTotalCharge $shipmentPrepaidTotalCharge
     * @return \akademia\StructType\Billing
     */
    public function setShipmentPrepaidTotalCharge(\akademia\StructType\ShipmentPrepaidTotalCharge $shipmentPrepaidTotalCharge = null)
    {
        $this->ShipmentPrepaidTotalCharge = $shipmentPrepaidTotalCharge;
        return $this;
    }
}
