<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalInformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional Informations for export line item
 * @subpackage Structs
 * @version 2.2
 */
class AdditionalInformation extends AbstractStructBase
{
    /**
     * The AdditionalInformationText
     * Meta information extracted from the WSDL
     * - documentation: Export line item's additional information text that can be printed in customs invoice.
     * - base: xsd:string
     * @var string
     */
    public $AdditionalInformationText;
    /**
     * The BillingCode
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 3
     * - whiteSpace: collapse
     * @var string
     */
    public $BillingCode;
    /**
     * The OriginServiceArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\DocTypeRef_OriginServiceAreaType
     */
    public $OriginServiceArea;
    /**
     * The DestinationServiceArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\DocTypeRef_DestinationServiceAreaType
     */
    public $DestinationServiceArea;
    /**
     * The Ship
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\DocTypeRef_ShipType
     */
    public $Ship;
    /**
     * The VolumetricWeight
     * Meta information extracted from the WSDL
     * - documentation: Dimensional Weight
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $VolumetricWeight;
    /**
     * The DHLRoutingCode
     * Meta information extracted from the WSDL
     * - documentation: Routing Code
     * - minOccurs: 0
     * @var string
     */
    public $DHLRoutingCode;
    /**
     * The DHLRoutingDataID
     * Meta information extracted from the WSDL
     * - documentation: Routing Code Identifier
     * - minOccurs: 0
     * @var string
     */
    public $DHLRoutingDataID;
    /**
     * The ServiceContentCode
     * Meta information extracted from the WSDL
     * - documentation: Product Content Code
     * - base: xsd:token
     * - maxLength: 3
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ServiceContentCode;
    /**
     * The ServiceHandlingFeatureCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\ServiceHandlingFeatureCodes
     */
    public $ServiceHandlingFeatureCodes;
    /**
     * The DeliveryDateCode
     * Meta information extracted from the WSDL
     * - documentation: Delivery Date Code
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDateCode;
    /**
     * The DeliveryTimeCode
     * Meta information extracted from the WSDL
     * - documentation: Delivery Time Code
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryTimeCode;
    /**
     * Constructor method for AdditionalInformation
     * @uses AdditionalInformation::setAdditionalInformationText()
     * @uses AdditionalInformation::setBillingCode()
     * @uses AdditionalInformation::setOriginServiceArea()
     * @uses AdditionalInformation::setDestinationServiceArea()
     * @uses AdditionalInformation::setShip()
     * @uses AdditionalInformation::setVolumetricWeight()
     * @uses AdditionalInformation::setDHLRoutingCode()
     * @uses AdditionalInformation::setDHLRoutingDataID()
     * @uses AdditionalInformation::setServiceContentCode()
     * @uses AdditionalInformation::setServiceHandlingFeatureCodes()
     * @uses AdditionalInformation::setDeliveryDateCode()
     * @uses AdditionalInformation::setDeliveryTimeCode()
     * @param string $additionalInformationText
     * @param string $billingCode
     * @param \akademia\StructType\DocTypeRef_OriginServiceAreaType $originServiceArea
     * @param \akademia\StructType\DocTypeRef_DestinationServiceAreaType $destinationServiceArea
     * @param \akademia\StructType\DocTypeRef_ShipType $ship
     * @param float $volumetricWeight
     * @param string $dHLRoutingCode
     * @param string $dHLRoutingDataID
     * @param string $serviceContentCode
     * @param \akademia\StructType\ServiceHandlingFeatureCodes $serviceHandlingFeatureCodes
     * @param string $deliveryDateCode
     * @param string $deliveryTimeCode
     */
    public function __construct($additionalInformationText = null, $billingCode = null, \akademia\StructType\DocTypeRef_OriginServiceAreaType $originServiceArea = null, \akademia\StructType\DocTypeRef_DestinationServiceAreaType $destinationServiceArea = null, \akademia\StructType\DocTypeRef_ShipType $ship = null, $volumetricWeight = null, $dHLRoutingCode = null, $dHLRoutingDataID = null, $serviceContentCode = null, \akademia\StructType\ServiceHandlingFeatureCodes $serviceHandlingFeatureCodes = null, $deliveryDateCode = null, $deliveryTimeCode = null)
    {
        $this
            ->setAdditionalInformationText($additionalInformationText)
            ->setBillingCode($billingCode)
            ->setOriginServiceArea($originServiceArea)
            ->setDestinationServiceArea($destinationServiceArea)
            ->setShip($ship)
            ->setVolumetricWeight($volumetricWeight)
            ->setDHLRoutingCode($dHLRoutingCode)
            ->setDHLRoutingDataID($dHLRoutingDataID)
            ->setServiceContentCode($serviceContentCode)
            ->setServiceHandlingFeatureCodes($serviceHandlingFeatureCodes)
            ->setDeliveryDateCode($deliveryDateCode)
            ->setDeliveryTimeCode($deliveryTimeCode);
    }
    /**
     * Get AdditionalInformationText value
     * @return string|null
     */
    public function getAdditionalInformationText()
    {
        return $this->AdditionalInformationText;
    }
    /**
     * Set AdditionalInformationText value
     * @param string $additionalInformationText
     * @return \akademia\StructType\AdditionalInformation
     */
    public function setAdditionalInformationText($additionalInformationText = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInformationText) && !is_string($additionalInformationText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInformationText, true), gettype($additionalInformationText)), __LINE__);
        }
        $this->AdditionalInformationText = $additionalInformationText;
        return $this;
    }
    /**
     * Get BillingCode value
     * @return string|null
     */
    public function getBillingCode()
    {
        return $this->BillingCode;
    }
    /**
     * Set BillingCode value
     * @param string $billingCode
     * @return \akademia\StructType\AdditionalInformation
     */
    public function setBillingCode($billingCode = null)
    {
        // validation for constraint: string
        if (!is_null($billingCode) && !is_string($billingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingCode, true), gettype($billingCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($billingCode) && mb_strlen($billingCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($billingCode)), __LINE__);
        }
        $this->BillingCode = $billingCode;
        return $this;
    }
    /**
     * Get OriginServiceArea value
     * @return \akademia\StructType\DocTypeRef_OriginServiceAreaType|null
     */
    public function getOriginServiceArea()
    {
        return $this->OriginServiceArea;
    }
    /**
     * Set OriginServiceArea value
     * @param \akademia\StructType\DocTypeRef_OriginServiceAreaType $originServiceArea
     * @return \akademia\StructType\AdditionalInformation
     */
    public function setOriginServiceArea(\akademia\StructType\DocTypeRef_OriginServiceAreaType $originServiceArea = null)
    {
        $this->OriginServiceArea = $originServiceArea;
        return $this;
    }
    /**
     * Get DestinationServiceArea value
     * @return \akademia\StructType\DocTypeRef_DestinationServiceAreaType|null
     */
    public function getDestinationServiceArea()
    {
        return $this->DestinationServiceArea;
    }
    /**
     * Set DestinationServiceArea value
     * @param \akademia\StructType\DocTypeRef_DestinationServiceAreaType $destinationServiceArea
     * @return \akademia\StructType\AdditionalInformation
     */
    public function setDestinationServiceArea(\akademia\StructType\DocTypeRef_DestinationServiceAreaType $destinationServiceArea = null)
    {
        $this->DestinationServiceArea = $destinationServiceArea;
        return $this;
    }
    /**
     * Get Ship value
     * @return \akademia\StructType\DocTypeRef_ShipType|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @param \akademia\StructType\DocTypeRef_ShipType $ship
     * @return \akademia\StructType\AdditionalInformation
     */
    public function setShip(\akademia\StructType\DocTypeRef_ShipType $ship = null)
    {
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Get VolumetricWeight value
     * @return float|null
     */
    public function getVolumetricWeight()
    {
        return $this->VolumetricWeight;
    }
    /**
     * Set VolumetricWeight value
     * @param float $volumetricWeight
     * @return \akademia\StructType\AdditionalInformation
     */
    public function setVolumetricWeight($volumetricWeight = null)
    {
        // validation for constraint: float
        if (!is_null($volumetricWeight) && !(is_float($volumetricWeight) || is_numeric($volumetricWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volumetricWeight, true), gettype($volumetricWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($volumetricWeight) && mb_strlen(mb_substr($volumetricWeight, false !== mb_strpos($volumetricWeight, '.') ? mb_strpos($volumetricWeight, '.') + 1 : mb_strlen($volumetricWeight))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($volumetricWeight, true), mb_strlen(mb_substr($volumetricWeight, mb_strpos($volumetricWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($volumetricWeight) && mb_strlen(preg_replace('/(\D)/', '', $volumetricWeight)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($volumetricWeight, true), mb_strlen(preg_replace('/(\D)/', '', $volumetricWeight))), __LINE__);
        }
        $this->VolumetricWeight = $volumetricWeight;
        return $this;
    }
    /**
     * Get DHLRoutingCode value
     * @return string|null
     */
    public function getDHLRoutingCode()
    {
        return $this->DHLRoutingCode;
    }
    /**
     * Set DHLRoutingCode value
     * @param string $dHLRoutingCode
     * @return \akademia\StructType\AdditionalInformation
     */
    public function setDHLRoutingCode($dHLRoutingCode = null)
    {
        // validation for constraint: string
        if (!is_null($dHLRoutingCode) && !is_string($dHLRoutingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dHLRoutingCode, true), gettype($dHLRoutingCode)), __LINE__);
        }
        $this->DHLRoutingCode = $dHLRoutingCode;
        return $this;
    }
    /**
     * Get DHLRoutingDataID value
     * @return string|null
     */
    public function getDHLRoutingDataID()
    {
        return $this->DHLRoutingDataID;
    }
    /**
     * Set DHLRoutingDataID value
     * @param string $dHLRoutingDataID
     * @return \akademia\StructType\AdditionalInformation
     */
    public function setDHLRoutingDataID($dHLRoutingDataID = null)
    {
        // validation for constraint: string
        if (!is_null($dHLRoutingDataID) && !is_string($dHLRoutingDataID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dHLRoutingDataID, true), gettype($dHLRoutingDataID)), __LINE__);
        }
        $this->DHLRoutingDataID = $dHLRoutingDataID;
        return $this;
    }
    /**
     * Get ServiceContentCode value
     * @return string|null
     */
    public function getServiceContentCode()
    {
        return $this->ServiceContentCode;
    }
    /**
     * Set ServiceContentCode value
     * @param string $serviceContentCode
     * @return \akademia\StructType\AdditionalInformation
     */
    public function setServiceContentCode($serviceContentCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceContentCode) && !is_string($serviceContentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceContentCode, true), gettype($serviceContentCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($serviceContentCode) && mb_strlen($serviceContentCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($serviceContentCode)), __LINE__);
        }
        $this->ServiceContentCode = $serviceContentCode;
        return $this;
    }
    /**
     * Get ServiceHandlingFeatureCodes value
     * @return \akademia\StructType\ServiceHandlingFeatureCodes|null
     */
    public function getServiceHandlingFeatureCodes()
    {
        return $this->ServiceHandlingFeatureCodes;
    }
    /**
     * Set ServiceHandlingFeatureCodes value
     * @param \akademia\StructType\ServiceHandlingFeatureCodes $serviceHandlingFeatureCodes
     * @return \akademia\StructType\AdditionalInformation
     */
    public function setServiceHandlingFeatureCodes(\akademia\StructType\ServiceHandlingFeatureCodes $serviceHandlingFeatureCodes = null)
    {
        $this->ServiceHandlingFeatureCodes = $serviceHandlingFeatureCodes;
        return $this;
    }
    /**
     * Get DeliveryDateCode value
     * @return string|null
     */
    public function getDeliveryDateCode()
    {
        return $this->DeliveryDateCode;
    }
    /**
     * Set DeliveryDateCode value
     * @param string $deliveryDateCode
     * @return \akademia\StructType\AdditionalInformation
     */
    public function setDeliveryDateCode($deliveryDateCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDateCode) && !is_string($deliveryDateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDateCode, true), gettype($deliveryDateCode)), __LINE__);
        }
        $this->DeliveryDateCode = $deliveryDateCode;
        return $this;
    }
    /**
     * Get DeliveryTimeCode value
     * @return string|null
     */
    public function getDeliveryTimeCode()
    {
        return $this->DeliveryTimeCode;
    }
    /**
     * Set DeliveryTimeCode value
     * @param string $deliveryTimeCode
     * @return \akademia\StructType\AdditionalInformation
     */
    public function setDeliveryTimeCode($deliveryTimeCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTimeCode) && !is_string($deliveryTimeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTimeCode, true), gettype($deliveryTimeCode)), __LINE__);
        }
        $this->DeliveryTimeCode = $deliveryTimeCode;
        return $this;
    }
}
