<?php

namespace akademia\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 * @version 2.2
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getRateRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \akademia\StructType\DocTypeRef_RateRequestType $parameters
     * @return \akademia\StructType\DocTypeRef_RateResponseType|bool
     */
    public function getRateRequest(\akademia\StructType\DocTypeRef_RateRequestType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRateRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \akademia\StructType\DocTypeRef_RateResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
