<?php

namespace akademia\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 * @version 2.2
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createShipmentRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \akademia\StructType\DocTypeRef_ProcessShipmentRequestType $parameters
     * @return \akademia\StructType\DocTypeRef_ShipmentDetailType|bool
     */
    public function createShipmentRequest(\akademia\StructType\DocTypeRef_ProcessShipmentRequestType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createShipmentRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \akademia\StructType\DocTypeRef_ShipmentDetailType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
