<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetachOptions StructType
 * Meta information extracted from the WSDL
 * - documentation: Detach options for Transport Label, Waybill Document, Shipment Receipt and Customs Invoice
 * @subpackage Structs
 * @version 2.2
 */
class DetachOptions extends AbstractStructBase
{
    /**
     * The AllInOnePDF
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $AllInOnePDF;
    /**
     * The SplitShipmentReceiptAndCustomsInvoice
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $SplitShipmentReceiptAndCustomsInvoice;
    /**
     * The SplitTransportLabelAndWaybillDocument
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $SplitTransportLabelAndWaybillDocument;
    /**
     * The SplitLabelsByPieces
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $SplitLabelsByPieces;
    /**
     * The ShipmentReceiptWithLabels
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentReceiptWithLabels;
    /**
     * Constructor method for DetachOptions
     * @uses DetachOptions::setAllInOnePDF()
     * @uses DetachOptions::setSplitShipmentReceiptAndCustomsInvoice()
     * @uses DetachOptions::setSplitTransportLabelAndWaybillDocument()
     * @uses DetachOptions::setSplitLabelsByPieces()
     * @uses DetachOptions::setShipmentReceiptWithLabels()
     * @param string $allInOnePDF
     * @param string $splitShipmentReceiptAndCustomsInvoice
     * @param string $splitTransportLabelAndWaybillDocument
     * @param string $splitLabelsByPieces
     * @param string $shipmentReceiptWithLabels
     */
    public function __construct($allInOnePDF = 'N', $splitShipmentReceiptAndCustomsInvoice = 'N', $splitTransportLabelAndWaybillDocument = 'N', $splitLabelsByPieces = 'N', $shipmentReceiptWithLabels = 'N')
    {
        $this
            ->setAllInOnePDF($allInOnePDF)
            ->setSplitShipmentReceiptAndCustomsInvoice($splitShipmentReceiptAndCustomsInvoice)
            ->setSplitTransportLabelAndWaybillDocument($splitTransportLabelAndWaybillDocument)
            ->setSplitLabelsByPieces($splitLabelsByPieces)
            ->setShipmentReceiptWithLabels($shipmentReceiptWithLabels);
    }
    /**
     * Get AllInOnePDF value
     * @return string|null
     */
    public function getAllInOnePDF()
    {
        return $this->AllInOnePDF;
    }
    /**
     * Set AllInOnePDF value
     * @uses \akademia\EnumType\AllInOnePDF::valueIsValid()
     * @uses \akademia\EnumType\AllInOnePDF::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allInOnePDF
     * @return \akademia\StructType\DetachOptions
     */
    public function setAllInOnePDF($allInOnePDF = 'N')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\AllInOnePDF::valueIsValid($allInOnePDF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\AllInOnePDF', is_array($allInOnePDF) ? implode(', ', $allInOnePDF) : var_export($allInOnePDF, true), implode(', ', \akademia\EnumType\AllInOnePDF::getValidValues())), __LINE__);
        }
        $this->AllInOnePDF = $allInOnePDF;
        return $this;
    }
    /**
     * Get SplitShipmentReceiptAndCustomsInvoice value
     * @return string|null
     */
    public function getSplitShipmentReceiptAndCustomsInvoice()
    {
        return $this->SplitShipmentReceiptAndCustomsInvoice;
    }
    /**
     * Set SplitShipmentReceiptAndCustomsInvoice value
     * @uses \akademia\EnumType\SplitShipmentReceiptAndCustomsInvoice::valueIsValid()
     * @uses \akademia\EnumType\SplitShipmentReceiptAndCustomsInvoice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $splitShipmentReceiptAndCustomsInvoice
     * @return \akademia\StructType\DetachOptions
     */
    public function setSplitShipmentReceiptAndCustomsInvoice($splitShipmentReceiptAndCustomsInvoice = 'N')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\SplitShipmentReceiptAndCustomsInvoice::valueIsValid($splitShipmentReceiptAndCustomsInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\SplitShipmentReceiptAndCustomsInvoice', is_array($splitShipmentReceiptAndCustomsInvoice) ? implode(', ', $splitShipmentReceiptAndCustomsInvoice) : var_export($splitShipmentReceiptAndCustomsInvoice, true), implode(', ', \akademia\EnumType\SplitShipmentReceiptAndCustomsInvoice::getValidValues())), __LINE__);
        }
        $this->SplitShipmentReceiptAndCustomsInvoice = $splitShipmentReceiptAndCustomsInvoice;
        return $this;
    }
    /**
     * Get SplitTransportLabelAndWaybillDocument value
     * @return string|null
     */
    public function getSplitTransportLabelAndWaybillDocument()
    {
        return $this->SplitTransportLabelAndWaybillDocument;
    }
    /**
     * Set SplitTransportLabelAndWaybillDocument value
     * @uses \akademia\EnumType\SplitTransportLabelAndWaybillDocument::valueIsValid()
     * @uses \akademia\EnumType\SplitTransportLabelAndWaybillDocument::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $splitTransportLabelAndWaybillDocument
     * @return \akademia\StructType\DetachOptions
     */
    public function setSplitTransportLabelAndWaybillDocument($splitTransportLabelAndWaybillDocument = 'N')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\SplitTransportLabelAndWaybillDocument::valueIsValid($splitTransportLabelAndWaybillDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\SplitTransportLabelAndWaybillDocument', is_array($splitTransportLabelAndWaybillDocument) ? implode(', ', $splitTransportLabelAndWaybillDocument) : var_export($splitTransportLabelAndWaybillDocument, true), implode(', ', \akademia\EnumType\SplitTransportLabelAndWaybillDocument::getValidValues())), __LINE__);
        }
        $this->SplitTransportLabelAndWaybillDocument = $splitTransportLabelAndWaybillDocument;
        return $this;
    }
    /**
     * Get SplitLabelsByPieces value
     * @return string|null
     */
    public function getSplitLabelsByPieces()
    {
        return $this->SplitLabelsByPieces;
    }
    /**
     * Set SplitLabelsByPieces value
     * @uses \akademia\EnumType\SplitLabelsByPieces::valueIsValid()
     * @uses \akademia\EnumType\SplitLabelsByPieces::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $splitLabelsByPieces
     * @return \akademia\StructType\DetachOptions
     */
    public function setSplitLabelsByPieces($splitLabelsByPieces = 'N')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\SplitLabelsByPieces::valueIsValid($splitLabelsByPieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\SplitLabelsByPieces', is_array($splitLabelsByPieces) ? implode(', ', $splitLabelsByPieces) : var_export($splitLabelsByPieces, true), implode(', ', \akademia\EnumType\SplitLabelsByPieces::getValidValues())), __LINE__);
        }
        $this->SplitLabelsByPieces = $splitLabelsByPieces;
        return $this;
    }
    /**
     * Get ShipmentReceiptWithLabels value
     * @return string|null
     */
    public function getShipmentReceiptWithLabels()
    {
        return $this->ShipmentReceiptWithLabels;
    }
    /**
     * Set ShipmentReceiptWithLabels value
     * @uses \akademia\EnumType\ShipmentReceiptWithLabels::valueIsValid()
     * @uses \akademia\EnumType\ShipmentReceiptWithLabels::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shipmentReceiptWithLabels
     * @return \akademia\StructType\DetachOptions
     */
    public function setShipmentReceiptWithLabels($shipmentReceiptWithLabels = 'N')
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\ShipmentReceiptWithLabels::valueIsValid($shipmentReceiptWithLabels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\ShipmentReceiptWithLabels', is_array($shipmentReceiptWithLabels) ? implode(', ', $shipmentReceiptWithLabels) : var_export($shipmentReceiptWithLabels, true), implode(', ', \akademia\EnumType\ShipmentReceiptWithLabels::getValidValues())), __LINE__);
        }
        $this->ShipmentReceiptWithLabels = $shipmentReceiptWithLabels;
        return $this;
    }
}
