<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BespokeLabelData StructType
 * @subpackage Structs
 * @version 2.2
 */
class BespokeLabelData extends AbstractStructBase
{
    /**
     * The LabelBarcodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\LabelBarcodes
     */
    public $LabelBarcodes;
    /**
     * The LabelTextEntries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\LabelTextEntries
     */
    public $LabelTextEntries;
    /**
     * The LabelDescription
     * Meta information extracted from the WSDL
     * - documentation: Customer additional information Description
     * - base: xsd:token
     * - maxLength: 80
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $LabelDescription;
    /**
     * Constructor method for BespokeLabelData
     * @uses BespokeLabelData::setLabelBarcodes()
     * @uses BespokeLabelData::setLabelTextEntries()
     * @uses BespokeLabelData::setLabelDescription()
     * @param \akademia\StructType\LabelBarcodes $labelBarcodes
     * @param \akademia\StructType\LabelTextEntries $labelTextEntries
     * @param string $labelDescription
     */
    public function __construct(\akademia\StructType\LabelBarcodes $labelBarcodes = null, \akademia\StructType\LabelTextEntries $labelTextEntries = null, $labelDescription = null)
    {
        $this
            ->setLabelBarcodes($labelBarcodes)
            ->setLabelTextEntries($labelTextEntries)
            ->setLabelDescription($labelDescription);
    }
    /**
     * Get LabelBarcodes value
     * @return \akademia\StructType\LabelBarcodes|null
     */
    public function getLabelBarcodes()
    {
        return $this->LabelBarcodes;
    }
    /**
     * Set LabelBarcodes value
     * @param \akademia\StructType\LabelBarcodes $labelBarcodes
     * @return \akademia\StructType\BespokeLabelData
     */
    public function setLabelBarcodes(\akademia\StructType\LabelBarcodes $labelBarcodes = null)
    {
        $this->LabelBarcodes = $labelBarcodes;
        return $this;
    }
    /**
     * Get LabelTextEntries value
     * @return \akademia\StructType\LabelTextEntries|null
     */
    public function getLabelTextEntries()
    {
        return $this->LabelTextEntries;
    }
    /**
     * Set LabelTextEntries value
     * @param \akademia\StructType\LabelTextEntries $labelTextEntries
     * @return \akademia\StructType\BespokeLabelData
     */
    public function setLabelTextEntries(\akademia\StructType\LabelTextEntries $labelTextEntries = null)
    {
        $this->LabelTextEntries = $labelTextEntries;
        return $this;
    }
    /**
     * Get LabelDescription value
     * @return string|null
     */
    public function getLabelDescription()
    {
        return $this->LabelDescription;
    }
    /**
     * Set LabelDescription value
     * @param string $labelDescription
     * @return \akademia\StructType\BespokeLabelData
     */
    public function setLabelDescription($labelDescription = null)
    {
        // validation for constraint: string
        if (!is_null($labelDescription) && !is_string($labelDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelDescription, true), gettype($labelDescription)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($labelDescription) && mb_strlen($labelDescription) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($labelDescription)), __LINE__);
        }
        $this->LabelDescription = $labelDescription;
        return $this;
    }
}
