<?php

namespace akademia\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for RequestLabelsToFitA4 EnumType
 * Meta information extracted from the WSDL
 * - documentation: Request Transport Label and Waybill Document in A4 margin PDF format
 * @subpackage Enumerations
 * @version 2.2
 */
class RequestLabelsToFitA4 extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Y'
     * @return string 'Y'
     */
    const VALUE_Y = 'Y';
    /**
     * Constant for value 'N'
     * @return string 'N'
     */
    const VALUE_N = 'N';
    /**
     * Return allowed values
     * @uses self::VALUE_Y
     * @uses self::VALUE_N
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_Y,
            self::VALUE_N,
        );
    }
}
