<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LandedCostType StructType
 * @subpackage Structs
 * @version 2.2
 */
class LandedCostType extends AbstractStructBase
{
    /**
     * The GetItemCostBreakdown
     * Meta information extracted from the WSDL
     * - documentation: If the value is "Y", the item cost breakdown will be returned.
     * @var string
     */
    public $GetItemCostBreakdown;
    /**
     * The ShipmentCurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: This will be used for other amount section if the specific currency code is not provided.
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * - whiteSpace: collapse
     * @var string
     */
    public $ShipmentCurrencyCode;
    /**
     * The ShipmentPurpose
     * Meta information extracted from the WSDL
     * - documentation: Possible values: "COMMERCIAL" "PERSONAL"
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentPurpose;
    /**
     * The ShipmentTransportationMode
     * Meta information extracted from the WSDL
     * - documentation: Possible value: "AIR" "OCEAN" "GROUND"
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentTransportationMode;
    /**
     * The MerchantSelectedCarrierName
     * Meta information extracted from the WSDL
     * - documentation: Carrier Name from Merchant Example: DHL, UPS, FEDEX
     * - minOccurs: 0
     * @var string
     */
    public $MerchantSelectedCarrierName;
    /**
     * The Items
     * @var \akademia\StructType\ItemsType
     */
    public $Items;
    /**
     * The ShipmentMonetaryAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\ShipmentMonetaryAmountType
     */
    public $ShipmentMonetaryAmount;
    /**
     * Constructor method for LandedCostType
     * @uses LandedCostType::setGetItemCostBreakdown()
     * @uses LandedCostType::setShipmentCurrencyCode()
     * @uses LandedCostType::setShipmentPurpose()
     * @uses LandedCostType::setShipmentTransportationMode()
     * @uses LandedCostType::setMerchantSelectedCarrierName()
     * @uses LandedCostType::setItems()
     * @uses LandedCostType::setShipmentMonetaryAmount()
     * @param string $getItemCostBreakdown
     * @param string $shipmentCurrencyCode
     * @param string $shipmentPurpose
     * @param string $shipmentTransportationMode
     * @param string $merchantSelectedCarrierName
     * @param \akademia\StructType\ItemsType $items
     * @param \akademia\StructType\ShipmentMonetaryAmountType $shipmentMonetaryAmount
     */
    public function __construct($getItemCostBreakdown = null, $shipmentCurrencyCode = null, $shipmentPurpose = null, $shipmentTransportationMode = null, $merchantSelectedCarrierName = null, \akademia\StructType\ItemsType $items = null, \akademia\StructType\ShipmentMonetaryAmountType $shipmentMonetaryAmount = null)
    {
        $this
            ->setGetItemCostBreakdown($getItemCostBreakdown)
            ->setShipmentCurrencyCode($shipmentCurrencyCode)
            ->setShipmentPurpose($shipmentPurpose)
            ->setShipmentTransportationMode($shipmentTransportationMode)
            ->setMerchantSelectedCarrierName($merchantSelectedCarrierName)
            ->setItems($items)
            ->setShipmentMonetaryAmount($shipmentMonetaryAmount);
    }
    /**
     * Get GetItemCostBreakdown value
     * @return string|null
     */
    public function getGetItemCostBreakdown()
    {
        return $this->GetItemCostBreakdown;
    }
    /**
     * Set GetItemCostBreakdown value
     * @uses \akademia\EnumType\GetItemCostBreakdown2::valueIsValid()
     * @uses \akademia\EnumType\GetItemCostBreakdown2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $getItemCostBreakdown
     * @return \akademia\StructType\LandedCostType
     */
    public function setGetItemCostBreakdown($getItemCostBreakdown = null)
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\GetItemCostBreakdown2::valueIsValid($getItemCostBreakdown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\GetItemCostBreakdown2', is_array($getItemCostBreakdown) ? implode(', ', $getItemCostBreakdown) : var_export($getItemCostBreakdown, true), implode(', ', \akademia\EnumType\GetItemCostBreakdown2::getValidValues())), __LINE__);
        }
        $this->GetItemCostBreakdown = $getItemCostBreakdown;
        return $this;
    }
    /**
     * Get ShipmentCurrencyCode value
     * @return string|null
     */
    public function getShipmentCurrencyCode()
    {
        return $this->ShipmentCurrencyCode;
    }
    /**
     * Set ShipmentCurrencyCode value
     * @param string $shipmentCurrencyCode
     * @return \akademia\StructType\LandedCostType
     */
    public function setShipmentCurrencyCode($shipmentCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentCurrencyCode) && !is_string($shipmentCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentCurrencyCode, true), gettype($shipmentCurrencyCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($shipmentCurrencyCode) && mb_strlen($shipmentCurrencyCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($shipmentCurrencyCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($shipmentCurrencyCode) && mb_strlen($shipmentCurrencyCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($shipmentCurrencyCode)), __LINE__);
        }
        $this->ShipmentCurrencyCode = $shipmentCurrencyCode;
        return $this;
    }
    /**
     * Get ShipmentPurpose value
     * @return string|null
     */
    public function getShipmentPurpose()
    {
        return $this->ShipmentPurpose;
    }
    /**
     * Set ShipmentPurpose value
     * @uses \akademia\EnumType\ShipmentPurpose2::valueIsValid()
     * @uses \akademia\EnumType\ShipmentPurpose2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shipmentPurpose
     * @return \akademia\StructType\LandedCostType
     */
    public function setShipmentPurpose($shipmentPurpose = null)
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\ShipmentPurpose2::valueIsValid($shipmentPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\ShipmentPurpose2', is_array($shipmentPurpose) ? implode(', ', $shipmentPurpose) : var_export($shipmentPurpose, true), implode(', ', \akademia\EnumType\ShipmentPurpose2::getValidValues())), __LINE__);
        }
        $this->ShipmentPurpose = $shipmentPurpose;
        return $this;
    }
    /**
     * Get ShipmentTransportationMode value
     * @return string|null
     */
    public function getShipmentTransportationMode()
    {
        return $this->ShipmentTransportationMode;
    }
    /**
     * Set ShipmentTransportationMode value
     * @uses \akademia\EnumType\ShipmentTransportationMode2::valueIsValid()
     * @uses \akademia\EnumType\ShipmentTransportationMode2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shipmentTransportationMode
     * @return \akademia\StructType\LandedCostType
     */
    public function setShipmentTransportationMode($shipmentTransportationMode = null)
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\ShipmentTransportationMode2::valueIsValid($shipmentTransportationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\ShipmentTransportationMode2', is_array($shipmentTransportationMode) ? implode(', ', $shipmentTransportationMode) : var_export($shipmentTransportationMode, true), implode(', ', \akademia\EnumType\ShipmentTransportationMode2::getValidValues())), __LINE__);
        }
        $this->ShipmentTransportationMode = $shipmentTransportationMode;
        return $this;
    }
    /**
     * Get MerchantSelectedCarrierName value
     * @return string|null
     */
    public function getMerchantSelectedCarrierName()
    {
        return $this->MerchantSelectedCarrierName;
    }
    /**
     * Set MerchantSelectedCarrierName value
     * @uses \akademia\EnumType\MerchantSelectedCarrierName2::valueIsValid()
     * @uses \akademia\EnumType\MerchantSelectedCarrierName2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $merchantSelectedCarrierName
     * @return \akademia\StructType\LandedCostType
     */
    public function setMerchantSelectedCarrierName($merchantSelectedCarrierName = null)
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\MerchantSelectedCarrierName2::valueIsValid($merchantSelectedCarrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\MerchantSelectedCarrierName2', is_array($merchantSelectedCarrierName) ? implode(', ', $merchantSelectedCarrierName) : var_export($merchantSelectedCarrierName, true), implode(', ', \akademia\EnumType\MerchantSelectedCarrierName2::getValidValues())), __LINE__);
        }
        $this->MerchantSelectedCarrierName = $merchantSelectedCarrierName;
        return $this;
    }
    /**
     * Get Items value
     * @return \akademia\StructType\ItemsType|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \akademia\StructType\ItemsType $items
     * @return \akademia\StructType\LandedCostType
     */
    public function setItems(\akademia\StructType\ItemsType $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get ShipmentMonetaryAmount value
     * @return \akademia\StructType\ShipmentMonetaryAmountType|null
     */
    public function getShipmentMonetaryAmount()
    {
        return $this->ShipmentMonetaryAmount;
    }
    /**
     * Set ShipmentMonetaryAmount value
     * @param \akademia\StructType\ShipmentMonetaryAmountType $shipmentMonetaryAmount
     * @return \akademia\StructType\LandedCostType
     */
    public function setShipmentMonetaryAmount(\akademia\StructType\ShipmentMonetaryAmountType $shipmentMonetaryAmount = null)
    {
        $this->ShipmentMonetaryAmount = $shipmentMonetaryAmount;
        return $this;
    }
}
