<?php

namespace akademia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_InternationDetailType StructType
 * @subpackage Structs
 * @version 2.2
 */
class DocTypeRef_InternationDetailType extends AbstractStructBase
{
    /**
     * The Commodities
     * @var \akademia\StructType\DocTypeRef_CommoditiesType
     */
    public $Commodities;
    /**
     * The Content
     * Meta information extracted from the WSDL
     * - documentation: Details whether a shipment is non-dutiable (value DOCUMENTS) or dutiable (NON_DOCUMENTS)
     * - minOccurs: 0
     * @var string
     */
    public $Content;
    /**
     * The ExportDeclaration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \akademia\StructType\ExportDeclaration
     */
    public $ExportDeclaration;
    /**
     * Constructor method for docTypeRef_InternationDetailType
     * @uses DocTypeRef_InternationDetailType::setCommodities()
     * @uses DocTypeRef_InternationDetailType::setContent()
     * @uses DocTypeRef_InternationDetailType::setExportDeclaration()
     * @param \akademia\StructType\DocTypeRef_CommoditiesType $commodities
     * @param string $content
     * @param \akademia\StructType\ExportDeclaration $exportDeclaration
     */
    public function __construct(\akademia\StructType\DocTypeRef_CommoditiesType $commodities = null, $content = null, \akademia\StructType\ExportDeclaration $exportDeclaration = null)
    {
        $this
            ->setCommodities($commodities)
            ->setContent($content)
            ->setExportDeclaration($exportDeclaration);
    }
    /**
     * Get Commodities value
     * @return \akademia\StructType\DocTypeRef_CommoditiesType|null
     */
    public function getCommodities()
    {
        return $this->Commodities;
    }
    /**
     * Set Commodities value
     * @param \akademia\StructType\DocTypeRef_CommoditiesType $commodities
     * @return \akademia\StructType\DocTypeRef_InternationDetailType
     */
    public function setCommodities(\akademia\StructType\DocTypeRef_CommoditiesType $commodities = null)
    {
        $this->Commodities = $commodities;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @uses \akademia\EnumType\Content::valueIsValid()
     * @uses \akademia\EnumType\Content::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $content
     * @return \akademia\StructType\DocTypeRef_InternationDetailType
     */
    public function setContent($content = null)
    {
        // validation for constraint: enumeration
        if (!\akademia\EnumType\Content::valueIsValid($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \akademia\EnumType\Content', is_array($content) ? implode(', ', $content) : var_export($content, true), implode(', ', \akademia\EnumType\Content::getValidValues())), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Get ExportDeclaration value
     * @return \akademia\StructType\ExportDeclaration|null
     */
    public function getExportDeclaration()
    {
        return $this->ExportDeclaration;
    }
    /**
     * Set ExportDeclaration value
     * @param \akademia\StructType\ExportDeclaration $exportDeclaration
     * @return \akademia\StructType\DocTypeRef_InternationDetailType
     */
    public function setExportDeclaration(\akademia\StructType\ExportDeclaration $exportDeclaration = null)
    {
        $this->ExportDeclaration = $exportDeclaration;
        return $this;
    }
}
