<?php

namespace akademia\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 * @version 2.2
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteShipmentRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \akademia\StructType\DocTypeRef_DeleteRequestType $parameters
     * @return \akademia\StructType\DocTypeRef_DeleteResponseType|bool
     */
    public function deleteShipmentRequest(\akademia\StructType\DocTypeRef_DeleteRequestType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteShipmentRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \akademia\StructType\DocTypeRef_DeleteResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
