<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for view StructType
 * @subpackage Structs
 */
class View extends Image
{
    /**
     * The shotCode
     * @var string
     */
    public $shotCode;
    /**
     * The backgroundDescription
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $backgroundDescription;
    /**
     * Constructor method for view
     * @uses View::setShotCode()
     * @uses View::setBackgroundDescription()
     * @param string $shotCode
     * @param string $backgroundDescription
     */
    public function __construct($shotCode = null, $backgroundDescription = null)
    {
        $this
            ->setShotCode($shotCode)
            ->setBackgroundDescription($backgroundDescription);
    }
    /**
     * Get shotCode value
     * @return string|null
     */
    public function getShotCode()
    {
        return $this->shotCode;
    }
    /**
     * Set shotCode value
     * @param string $shotCode
     * @return \StructType\View
     */
    public function setShotCode($shotCode = null)
    {
        // validation for constraint: string
        if (!is_null($shotCode) && !is_string($shotCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shotCode, true), gettype($shotCode)), __LINE__);
        }
        $this->shotCode = $shotCode;
        return $this;
    }
    /**
     * Get backgroundDescription value
     * @return string|null
     */
    public function getBackgroundDescription()
    {
        return $this->backgroundDescription;
    }
    /**
     * Set backgroundDescription value
     * @param string $backgroundDescription
     * @return \StructType\View
     */
    public function setBackgroundDescription($backgroundDescription = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundDescription) && !is_string($backgroundDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backgroundDescription, true), gettype($backgroundDescription)), __LINE__);
        }
        $this->backgroundDescription = $backgroundDescription;
        return $this;
    }
}
