<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TechnicalSpecification StructType
 * @subpackage Structs
 */
class TechnicalSpecification extends AbstractStructBase
{
    /**
     * The titleId
     * Meta information extracted from the WSDL
     * - choice: titleId | definition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $titleId;
    /**
     * The definition
     * Meta information extracted from the WSDL
     * - choice: titleId | definition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\TechnicalSpecificationDefinition
     */
    public $definition;
    /**
     * The range
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Range_1
     */
    public $range;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Value[]
     */
    public $value;
    /**
     * Constructor method for TechnicalSpecification
     * @uses TechnicalSpecification::setTitleId()
     * @uses TechnicalSpecification::setDefinition()
     * @uses TechnicalSpecification::setRange()
     * @uses TechnicalSpecification::setValue()
     * @param int $titleId
     * @param \StructType\TechnicalSpecificationDefinition $definition
     * @param \StructType\Range_1 $range
     * @param \StructType\Value[] $value
     */
    public function __construct($titleId = null, \StructType\TechnicalSpecificationDefinition $definition = null, \StructType\Range_1 $range = null, array $value = array())
    {
        $this
            ->setTitleId($titleId)
            ->setDefinition($definition)
            ->setRange($range)
            ->setValue($value);
    }
    /**
     * Get titleId value
     * @return int|null
     */
    public function getTitleId()
    {
        return isset($this->titleId) ? $this->titleId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTitleId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTitleId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTitleIdForChoiceConstraintsFromSetTitleId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'definition',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property titleId can\'t be set as the property %s is already set. Only one property must be set among these properties: titleId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set titleId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $titleId
     * @return \StructType\TechnicalSpecification
     */
    public function setTitleId($titleId = null)
    {
        // validation for constraint: int
        if (!is_null($titleId) && !(is_int($titleId) || ctype_digit($titleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($titleId, true), gettype($titleId)), __LINE__);
        }
        // validation for constraint: choice(titleId, definition)
        if ('' !== ($titleIdChoiceErrorMessage = self::validateTitleIdForChoiceConstraintsFromSetTitleId($titleId))) {
            throw new \InvalidArgumentException($titleIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($titleId) || (is_array($titleId) && empty($titleId))) {
            unset($this->titleId);
        } else {
            $this->titleId = $titleId;
        }
        return $this;
    }
    /**
     * Get definition value
     * @return \StructType\TechnicalSpecificationDefinition|null
     */
    public function getDefinition()
    {
        return isset($this->definition) ? $this->definition : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDefinition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefinition method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDefinitionForChoiceConstraintsFromSetDefinition($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'titleId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property definition can\'t be set as the property %s is already set. Only one property must be set among these properties: definition, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set definition value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TechnicalSpecificationDefinition $definition
     * @return \StructType\TechnicalSpecification
     */
    public function setDefinition(\StructType\TechnicalSpecificationDefinition $definition = null)
    {
        // validation for constraint: choice(titleId, definition)
        if ('' !== ($definitionChoiceErrorMessage = self::validateDefinitionForChoiceConstraintsFromSetDefinition($definition))) {
            throw new \InvalidArgumentException($definitionChoiceErrorMessage, __LINE__);
        }
        if (is_null($definition) || (is_array($definition) && empty($definition))) {
            unset($this->definition);
        } else {
            $this->definition = $definition;
        }
        return $this;
    }
    /**
     * Get range value
     * @return \StructType\Range_1|null
     */
    public function getRange()
    {
        return $this->range;
    }
    /**
     * Set range value
     * @param \StructType\Range_1 $range
     * @return \StructType\TechnicalSpecification
     */
    public function setRange(\StructType\Range_1 $range = null)
    {
        $this->range = $range;
        return $this;
    }
    /**
     * Get value value
     * @return \StructType\Value[]|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $technicalSpecificationValueItem) {
            // validation for constraint: itemType
            if (!$technicalSpecificationValueItem instanceof \StructType\Value) {
                $invalidValues[] = is_object($technicalSpecificationValueItem) ? get_class($technicalSpecificationValueItem) : sprintf('%s(%s)', gettype($technicalSpecificationValueItem), var_export($technicalSpecificationValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The value property can only contain items of type \StructType\Value, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set value value
     * @throws \InvalidArgumentException
     * @param \StructType\Value[] $value
     * @return \StructType\TechnicalSpecification
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Add item to value value
     * @throws \InvalidArgumentException
     * @param \StructType\Value $item
     * @return \StructType\TechnicalSpecification
     */
    public function addToValue(\StructType\Value $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Value) {
            throw new \InvalidArgumentException(sprintf('The value property can only contain items of type \StructType\Value, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->value[] = $item;
        return $this;
    }
}
