<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subdivisions StructType
 * @subpackage Structs
 */
class Subdivisions extends BaseResponse
{
    /**
     * The subdivision
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IdentifiedString[]
     */
    public $subdivision;
    /**
     * Constructor method for Subdivisions
     * @uses Subdivisions::setSubdivision()
     * @param \StructType\IdentifiedString[] $subdivision
     */
    public function __construct(array $subdivision = array())
    {
        $this
            ->setSubdivision($subdivision);
    }
    /**
     * Get subdivision value
     * @return \StructType\IdentifiedString[]|null
     */
    public function getSubdivision()
    {
        return $this->subdivision;
    }
    /**
     * This method is responsible for validating the values passed to the setSubdivision method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubdivision method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubdivisionForArrayConstraintsFromSetSubdivision(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subdivisionsSubdivisionItem) {
            // validation for constraint: itemType
            if (!$subdivisionsSubdivisionItem instanceof \StructType\IdentifiedString) {
                $invalidValues[] = is_object($subdivisionsSubdivisionItem) ? get_class($subdivisionsSubdivisionItem) : sprintf('%s(%s)', gettype($subdivisionsSubdivisionItem), var_export($subdivisionsSubdivisionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subdivision property can only contain items of type \StructType\IdentifiedString, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subdivision value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifiedString[] $subdivision
     * @return \StructType\Subdivisions
     */
    public function setSubdivision(array $subdivision = array())
    {
        // validation for constraint: array
        if ('' !== ($subdivisionArrayErrorMessage = self::validateSubdivisionForArrayConstraintsFromSetSubdivision($subdivision))) {
            throw new \InvalidArgumentException($subdivisionArrayErrorMessage, __LINE__);
        }
        $this->subdivision = $subdivision;
        return $this;
    }
    /**
     * Add item to subdivision value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifiedString $item
     * @return \StructType\Subdivisions
     */
    public function addToSubdivision(\StructType\IdentifiedString $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifiedString) {
            throw new \InvalidArgumentException(sprintf('The subdivision property can only contain items of type \StructType\IdentifiedString, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subdivision[] = $item;
        return $this;
    }
}
