<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StylesRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides a list of Chrome style ID's associated with the provided model ID.
 * @subpackage Structs
 */
class StylesRequest extends BaseRequest
{
    /**
     * The modelId
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $modelId;
    /**
     * Constructor method for StylesRequest
     * @uses StylesRequest::setModelId()
     * @param int $modelId
     */
    public function __construct($modelId = null)
    {
        $this
            ->setModelId($modelId);
    }
    /**
     * Get modelId value
     * @return int
     */
    public function getModelId()
    {
        return $this->modelId;
    }
    /**
     * Set modelId value
     * @param int $modelId
     * @return \StructType\StylesRequest
     */
    public function setModelId($modelId = null)
    {
        // validation for constraint: int
        if (!is_null($modelId) && !(is_int($modelId) || ctype_digit($modelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modelId, true), gettype($modelId)), __LINE__);
        }
        $this->modelId = $modelId;
        return $this;
    }
}
