<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseStatus StructType
 * @subpackage Structs
 */
class ResponseStatus extends AbstractStructBase
{
    /**
     * The responseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $responseCode;
    /**
     * The matchedEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MatchedEquipment[]
     */
    public $matchedEquipment;
    /**
     * The matchedNonFactoryEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MatchedNonFactoryEquipment[]
     */
    public $matchedNonFactoryEquipment;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Status[]
     */
    public $status;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * Constructor method for ResponseStatus
     * @uses ResponseStatus::setResponseCode()
     * @uses ResponseStatus::setMatchedEquipment()
     * @uses ResponseStatus::setMatchedNonFactoryEquipment()
     * @uses ResponseStatus::setStatus()
     * @uses ResponseStatus::setDescription()
     * @param string $responseCode
     * @param \StructType\MatchedEquipment[] $matchedEquipment
     * @param \StructType\MatchedNonFactoryEquipment[] $matchedNonFactoryEquipment
     * @param \StructType\Status[] $status
     * @param string $description
     */
    public function __construct($responseCode = null, array $matchedEquipment = array(), array $matchedNonFactoryEquipment = array(), array $status = array(), $description = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setMatchedEquipment($matchedEquipment)
            ->setMatchedNonFactoryEquipment($matchedNonFactoryEquipment)
            ->setStatus($status)
            ->setDescription($description);
    }
    /**
     * Get responseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->responseCode;
    }
    /**
     * Set responseCode value
     * @param string $responseCode
     * @return \StructType\ResponseStatus
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->responseCode = $responseCode;
        return $this;
    }
    /**
     * Get matchedEquipment value
     * @return \StructType\MatchedEquipment[]|null
     */
    public function getMatchedEquipment()
    {
        return $this->matchedEquipment;
    }
    /**
     * This method is responsible for validating the values passed to the setMatchedEquipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMatchedEquipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMatchedEquipmentForArrayConstraintsFromSetMatchedEquipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseStatusMatchedEquipmentItem) {
            // validation for constraint: itemType
            if (!$responseStatusMatchedEquipmentItem instanceof \StructType\MatchedEquipment) {
                $invalidValues[] = is_object($responseStatusMatchedEquipmentItem) ? get_class($responseStatusMatchedEquipmentItem) : sprintf('%s(%s)', gettype($responseStatusMatchedEquipmentItem), var_export($responseStatusMatchedEquipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The matchedEquipment property can only contain items of type \StructType\MatchedEquipment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set matchedEquipment value
     * @throws \InvalidArgumentException
     * @param \StructType\MatchedEquipment[] $matchedEquipment
     * @return \StructType\ResponseStatus
     */
    public function setMatchedEquipment(array $matchedEquipment = array())
    {
        // validation for constraint: array
        if ('' !== ($matchedEquipmentArrayErrorMessage = self::validateMatchedEquipmentForArrayConstraintsFromSetMatchedEquipment($matchedEquipment))) {
            throw new \InvalidArgumentException($matchedEquipmentArrayErrorMessage, __LINE__);
        }
        $this->matchedEquipment = $matchedEquipment;
        return $this;
    }
    /**
     * Add item to matchedEquipment value
     * @throws \InvalidArgumentException
     * @param \StructType\MatchedEquipment $item
     * @return \StructType\ResponseStatus
     */
    public function addToMatchedEquipment(\StructType\MatchedEquipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MatchedEquipment) {
            throw new \InvalidArgumentException(sprintf('The matchedEquipment property can only contain items of type \StructType\MatchedEquipment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->matchedEquipment[] = $item;
        return $this;
    }
    /**
     * Get matchedNonFactoryEquipment value
     * @return \StructType\MatchedNonFactoryEquipment[]|null
     */
    public function getMatchedNonFactoryEquipment()
    {
        return $this->matchedNonFactoryEquipment;
    }
    /**
     * This method is responsible for validating the values passed to the setMatchedNonFactoryEquipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMatchedNonFactoryEquipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMatchedNonFactoryEquipmentForArrayConstraintsFromSetMatchedNonFactoryEquipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseStatusMatchedNonFactoryEquipmentItem) {
            // validation for constraint: itemType
            if (!$responseStatusMatchedNonFactoryEquipmentItem instanceof \StructType\MatchedNonFactoryEquipment) {
                $invalidValues[] = is_object($responseStatusMatchedNonFactoryEquipmentItem) ? get_class($responseStatusMatchedNonFactoryEquipmentItem) : sprintf('%s(%s)', gettype($responseStatusMatchedNonFactoryEquipmentItem), var_export($responseStatusMatchedNonFactoryEquipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The matchedNonFactoryEquipment property can only contain items of type \StructType\MatchedNonFactoryEquipment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set matchedNonFactoryEquipment value
     * @throws \InvalidArgumentException
     * @param \StructType\MatchedNonFactoryEquipment[] $matchedNonFactoryEquipment
     * @return \StructType\ResponseStatus
     */
    public function setMatchedNonFactoryEquipment(array $matchedNonFactoryEquipment = array())
    {
        // validation for constraint: array
        if ('' !== ($matchedNonFactoryEquipmentArrayErrorMessage = self::validateMatchedNonFactoryEquipmentForArrayConstraintsFromSetMatchedNonFactoryEquipment($matchedNonFactoryEquipment))) {
            throw new \InvalidArgumentException($matchedNonFactoryEquipmentArrayErrorMessage, __LINE__);
        }
        $this->matchedNonFactoryEquipment = $matchedNonFactoryEquipment;
        return $this;
    }
    /**
     * Add item to matchedNonFactoryEquipment value
     * @throws \InvalidArgumentException
     * @param \StructType\MatchedNonFactoryEquipment $item
     * @return \StructType\ResponseStatus
     */
    public function addToMatchedNonFactoryEquipment(\StructType\MatchedNonFactoryEquipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MatchedNonFactoryEquipment) {
            throw new \InvalidArgumentException(sprintf('The matchedNonFactoryEquipment property can only contain items of type \StructType\MatchedNonFactoryEquipment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->matchedNonFactoryEquipment[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\Status[]|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * This method is responsible for validating the values passed to the setStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusForArrayConstraintsFromSetStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseStatusStatusItem) {
            // validation for constraint: itemType
            if (!$responseStatusStatusItem instanceof \StructType\Status) {
                $invalidValues[] = is_object($responseStatusStatusItem) ? get_class($responseStatusStatusItem) : sprintf('%s(%s)', gettype($responseStatusStatusItem), var_export($responseStatusStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The status property can only contain items of type \StructType\Status, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set status value
     * @throws \InvalidArgumentException
     * @param \StructType\Status[] $status
     * @return \StructType\ResponseStatus
     */
    public function setStatus(array $status = array())
    {
        // validation for constraint: array
        if ('' !== ($statusArrayErrorMessage = self::validateStatusForArrayConstraintsFromSetStatus($status))) {
            throw new \InvalidArgumentException($statusArrayErrorMessage, __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Add item to status value
     * @throws \InvalidArgumentException
     * @param \StructType\Status $item
     * @return \StructType\ResponseStatus
     */
    public function addToStatus(\StructType\Status $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Status) {
            throw new \InvalidArgumentException(sprintf('The status property can only contain items of type \StructType\Status, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->status[] = $item;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ResponseStatus
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
