<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceRange StructType
 * @subpackage Structs
 */
class PriceRange extends AbstractStructBase
{
    /**
     * The invoice
     * @var \StructType\Range
     */
    public $invoice;
    /**
     * The msrp
     * @var \StructType\Range
     */
    public $msrp;
    /**
     * The destination
     * @var \StructType\Range
     */
    public $destination;
    /**
     * The unknown
     * @var bool
     */
    public $unknown;
    /**
     * Constructor method for PriceRange
     * @uses PriceRange::setInvoice()
     * @uses PriceRange::setMsrp()
     * @uses PriceRange::setDestination()
     * @uses PriceRange::setUnknown()
     * @param \StructType\Range $invoice
     * @param \StructType\Range $msrp
     * @param \StructType\Range $destination
     * @param bool $unknown
     */
    public function __construct(\StructType\Range $invoice = null, \StructType\Range $msrp = null, \StructType\Range $destination = null, $unknown = null)
    {
        $this
            ->setInvoice($invoice)
            ->setMsrp($msrp)
            ->setDestination($destination)
            ->setUnknown($unknown);
    }
    /**
     * Get invoice value
     * @return \StructType\Range|null
     */
    public function getInvoice()
    {
        return $this->invoice;
    }
    /**
     * Set invoice value
     * @param \StructType\Range $invoice
     * @return \StructType\PriceRange
     */
    public function setInvoice(\StructType\Range $invoice = null)
    {
        $this->invoice = $invoice;
        return $this;
    }
    /**
     * Get msrp value
     * @return \StructType\Range|null
     */
    public function getMsrp()
    {
        return $this->msrp;
    }
    /**
     * Set msrp value
     * @param \StructType\Range $msrp
     * @return \StructType\PriceRange
     */
    public function setMsrp(\StructType\Range $msrp = null)
    {
        $this->msrp = $msrp;
        return $this;
    }
    /**
     * Get destination value
     * @return \StructType\Range|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param \StructType\Range $destination
     * @return \StructType\PriceRange
     */
    public function setDestination(\StructType\Range $destination = null)
    {
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get unknown value
     * @return bool|null
     */
    public function getUnknown()
    {
        return $this->unknown;
    }
    /**
     * Set unknown value
     * @param bool $unknown
     * @return \StructType\PriceRange
     */
    public function setUnknown($unknown = null)
    {
        // validation for constraint: boolean
        if (!is_null($unknown) && !is_bool($unknown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unknown, true), gettype($unknown)), __LINE__);
        }
        $this->unknown = $unknown;
        return $this;
    }
}
