<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModelsRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides a list of Chrome model ID's associated with the provided year and (sub)division ID.
 * @subpackage Structs
 */
class ModelsRequest extends BaseRequest
{
    /**
     * The modelYear
     * @var int
     */
    public $modelYear;
    /**
     * The divisionId
     * Meta information extracted from the WSDL
     * - choice: divisionId | subdivisionId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $divisionId;
    /**
     * The subdivisionId
     * Meta information extracted from the WSDL
     * - choice: divisionId | subdivisionId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $subdivisionId;
    /**
     * Constructor method for ModelsRequest
     * @uses ModelsRequest::setModelYear()
     * @uses ModelsRequest::setDivisionId()
     * @uses ModelsRequest::setSubdivisionId()
     * @param int $modelYear
     * @param int $divisionId
     * @param int $subdivisionId
     */
    public function __construct($modelYear = null, $divisionId = null, $subdivisionId = null)
    {
        $this
            ->setModelYear($modelYear)
            ->setDivisionId($divisionId)
            ->setSubdivisionId($subdivisionId);
    }
    /**
     * Get modelYear value
     * @return int|null
     */
    public function getModelYear()
    {
        return $this->modelYear;
    }
    /**
     * Set modelYear value
     * @param int $modelYear
     * @return \StructType\ModelsRequest
     */
    public function setModelYear($modelYear = null)
    {
        // validation for constraint: int
        if (!is_null($modelYear) && !(is_int($modelYear) || ctype_digit($modelYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modelYear, true), gettype($modelYear)), __LINE__);
        }
        $this->modelYear = $modelYear;
        return $this;
    }
    /**
     * Get divisionId value
     * @return int|null
     */
    public function getDivisionId()
    {
        return isset($this->divisionId) ? $this->divisionId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDivisionId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDivisionId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDivisionIdForChoiceConstraintsFromSetDivisionId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'subdivisionId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property divisionId can\'t be set as the property %s is already set. Only one property must be set among these properties: divisionId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set divisionId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $divisionId
     * @return \StructType\ModelsRequest
     */
    public function setDivisionId($divisionId = null)
    {
        // validation for constraint: int
        if (!is_null($divisionId) && !(is_int($divisionId) || ctype_digit($divisionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($divisionId, true), gettype($divisionId)), __LINE__);
        }
        // validation for constraint: choice(divisionId, subdivisionId)
        if ('' !== ($divisionIdChoiceErrorMessage = self::validateDivisionIdForChoiceConstraintsFromSetDivisionId($divisionId))) {
            throw new \InvalidArgumentException($divisionIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($divisionId) || (is_array($divisionId) && empty($divisionId))) {
            unset($this->divisionId);
        } else {
            $this->divisionId = $divisionId;
        }
        return $this;
    }
    /**
     * Get subdivisionId value
     * @return int|null
     */
    public function getSubdivisionId()
    {
        return isset($this->subdivisionId) ? $this->subdivisionId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSubdivisionId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubdivisionId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSubdivisionIdForChoiceConstraintsFromSetSubdivisionId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'divisionId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property subdivisionId can\'t be set as the property %s is already set. Only one property must be set among these properties: subdivisionId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set subdivisionId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $subdivisionId
     * @return \StructType\ModelsRequest
     */
    public function setSubdivisionId($subdivisionId = null)
    {
        // validation for constraint: int
        if (!is_null($subdivisionId) && !(is_int($subdivisionId) || ctype_digit($subdivisionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subdivisionId, true), gettype($subdivisionId)), __LINE__);
        }
        // validation for constraint: choice(divisionId, subdivisionId)
        if ('' !== ($subdivisionIdChoiceErrorMessage = self::validateSubdivisionIdForChoiceConstraintsFromSetSubdivisionId($subdivisionId))) {
            throw new \InvalidArgumentException($subdivisionIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($subdivisionId) || (is_array($subdivisionId) && empty($subdivisionId))) {
            unset($this->subdivisionId);
        } else {
            $this->subdivisionId = $subdivisionId;
        }
        return $this;
    }
}
