<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MatchedEquipment StructType
 * @subpackage Structs
 */
class MatchedEquipment extends AbstractStructBase
{
    /**
     * The equipmentDescription
     * @var string
     */
    public $equipmentDescription;
    /**
     * The categoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $categoryId;
    /**
     * Constructor method for MatchedEquipment
     * @uses MatchedEquipment::setEquipmentDescription()
     * @uses MatchedEquipment::setCategoryId()
     * @param string $equipmentDescription
     * @param int[] $categoryId
     */
    public function __construct($equipmentDescription = null, array $categoryId = array())
    {
        $this
            ->setEquipmentDescription($equipmentDescription)
            ->setCategoryId($categoryId);
    }
    /**
     * Get equipmentDescription value
     * @return string|null
     */
    public function getEquipmentDescription()
    {
        return $this->equipmentDescription;
    }
    /**
     * Set equipmentDescription value
     * @param string $equipmentDescription
     * @return \StructType\MatchedEquipment
     */
    public function setEquipmentDescription($equipmentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentDescription) && !is_string($equipmentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($equipmentDescription, true), gettype($equipmentDescription)), __LINE__);
        }
        $this->equipmentDescription = $equipmentDescription;
        return $this;
    }
    /**
     * Get categoryId value
     * @return int[]|null
     */
    public function getCategoryId()
    {
        return $this->categoryId;
    }
    /**
     * This method is responsible for validating the values passed to the setCategoryId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategoryId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryIdForArrayConstraintsFromSetCategoryId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $matchedEquipmentCategoryIdItem) {
            // validation for constraint: itemType
            if (!(is_int($matchedEquipmentCategoryIdItem) || ctype_digit($matchedEquipmentCategoryIdItem))) {
                $invalidValues[] = is_object($matchedEquipmentCategoryIdItem) ? get_class($matchedEquipmentCategoryIdItem) : sprintf('%s(%s)', gettype($matchedEquipmentCategoryIdItem), var_export($matchedEquipmentCategoryIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The categoryId property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set categoryId value
     * @throws \InvalidArgumentException
     * @param int[] $categoryId
     * @return \StructType\MatchedEquipment
     */
    public function setCategoryId(array $categoryId = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryIdArrayErrorMessage = self::validateCategoryIdForArrayConstraintsFromSetCategoryId($categoryId))) {
            throw new \InvalidArgumentException($categoryIdArrayErrorMessage, __LINE__);
        }
        $this->categoryId = $categoryId;
        return $this;
    }
    /**
     * Add item to categoryId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\MatchedEquipment
     */
    public function addToCategoryId($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The categoryId property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->categoryId[] = $item;
        return $this;
    }
}
