<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Engine StructType
 * @subpackage Structs
 */
class Engine extends AbstractStructBase
{
    /**
     * The engineType
     * @var \StructType\IdentifiedString
     */
    public $engineType;
    /**
     * The fuelType
     * @var \StructType\IdentifiedString
     */
    public $fuelType;
    /**
     * The horsepower
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ValueRPM
     */
    public $horsepower;
    /**
     * The netTorque
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ValueRPM
     */
    public $netTorque;
    /**
     * The cylinders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cylinders;
    /**
     * The displacement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Displacement
     */
    public $displacement;
    /**
     * The fuelEconomy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FuelEconomy
     */
    public $fuelEconomy;
    /**
     * The fuelCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FuelCapacity
     */
    public $fuelCapacity;
    /**
     * The forcedInduction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IdentifiedString
     */
    public $forcedInduction;
    /**
     * The installed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InstallationCause
     */
    public $installed;
    /**
     * The highOutput
     * @var bool
     */
    public $highOutput;
    /**
     * Constructor method for Engine
     * @uses Engine::setEngineType()
     * @uses Engine::setFuelType()
     * @uses Engine::setHorsepower()
     * @uses Engine::setNetTorque()
     * @uses Engine::setCylinders()
     * @uses Engine::setDisplacement()
     * @uses Engine::setFuelEconomy()
     * @uses Engine::setFuelCapacity()
     * @uses Engine::setForcedInduction()
     * @uses Engine::setInstalled()
     * @uses Engine::setHighOutput()
     * @param \StructType\IdentifiedString $engineType
     * @param \StructType\IdentifiedString $fuelType
     * @param \StructType\ValueRPM $horsepower
     * @param \StructType\ValueRPM $netTorque
     * @param int $cylinders
     * @param \StructType\Displacement $displacement
     * @param \StructType\FuelEconomy $fuelEconomy
     * @param \StructType\FuelCapacity $fuelCapacity
     * @param \StructType\IdentifiedString $forcedInduction
     * @param \StructType\InstallationCause $installed
     * @param bool $highOutput
     */
    public function __construct(\StructType\IdentifiedString $engineType = null, \StructType\IdentifiedString $fuelType = null, \StructType\ValueRPM $horsepower = null, \StructType\ValueRPM $netTorque = null, $cylinders = null, \StructType\Displacement $displacement = null, \StructType\FuelEconomy $fuelEconomy = null, \StructType\FuelCapacity $fuelCapacity = null, \StructType\IdentifiedString $forcedInduction = null, \StructType\InstallationCause $installed = null, $highOutput = null)
    {
        $this
            ->setEngineType($engineType)
            ->setFuelType($fuelType)
            ->setHorsepower($horsepower)
            ->setNetTorque($netTorque)
            ->setCylinders($cylinders)
            ->setDisplacement($displacement)
            ->setFuelEconomy($fuelEconomy)
            ->setFuelCapacity($fuelCapacity)
            ->setForcedInduction($forcedInduction)
            ->setInstalled($installed)
            ->setHighOutput($highOutput);
    }
    /**
     * Get engineType value
     * @return \StructType\IdentifiedString|null
     */
    public function getEngineType()
    {
        return $this->engineType;
    }
    /**
     * Set engineType value
     * @param \StructType\IdentifiedString $engineType
     * @return \StructType\Engine
     */
    public function setEngineType(\StructType\IdentifiedString $engineType = null)
    {
        $this->engineType = $engineType;
        return $this;
    }
    /**
     * Get fuelType value
     * @return \StructType\IdentifiedString|null
     */
    public function getFuelType()
    {
        return $this->fuelType;
    }
    /**
     * Set fuelType value
     * @param \StructType\IdentifiedString $fuelType
     * @return \StructType\Engine
     */
    public function setFuelType(\StructType\IdentifiedString $fuelType = null)
    {
        $this->fuelType = $fuelType;
        return $this;
    }
    /**
     * Get horsepower value
     * @return \StructType\ValueRPM|null
     */
    public function getHorsepower()
    {
        return $this->horsepower;
    }
    /**
     * Set horsepower value
     * @param \StructType\ValueRPM $horsepower
     * @return \StructType\Engine
     */
    public function setHorsepower(\StructType\ValueRPM $horsepower = null)
    {
        $this->horsepower = $horsepower;
        return $this;
    }
    /**
     * Get netTorque value
     * @return \StructType\ValueRPM|null
     */
    public function getNetTorque()
    {
        return $this->netTorque;
    }
    /**
     * Set netTorque value
     * @param \StructType\ValueRPM $netTorque
     * @return \StructType\Engine
     */
    public function setNetTorque(\StructType\ValueRPM $netTorque = null)
    {
        $this->netTorque = $netTorque;
        return $this;
    }
    /**
     * Get cylinders value
     * @return int|null
     */
    public function getCylinders()
    {
        return $this->cylinders;
    }
    /**
     * Set cylinders value
     * @param int $cylinders
     * @return \StructType\Engine
     */
    public function setCylinders($cylinders = null)
    {
        // validation for constraint: int
        if (!is_null($cylinders) && !(is_int($cylinders) || ctype_digit($cylinders))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cylinders, true), gettype($cylinders)), __LINE__);
        }
        $this->cylinders = $cylinders;
        return $this;
    }
    /**
     * Get displacement value
     * @return \StructType\Displacement|null
     */
    public function getDisplacement()
    {
        return $this->displacement;
    }
    /**
     * Set displacement value
     * @param \StructType\Displacement $displacement
     * @return \StructType\Engine
     */
    public function setDisplacement(\StructType\Displacement $displacement = null)
    {
        $this->displacement = $displacement;
        return $this;
    }
    /**
     * Get fuelEconomy value
     * @return \StructType\FuelEconomy|null
     */
    public function getFuelEconomy()
    {
        return $this->fuelEconomy;
    }
    /**
     * Set fuelEconomy value
     * @param \StructType\FuelEconomy $fuelEconomy
     * @return \StructType\Engine
     */
    public function setFuelEconomy(\StructType\FuelEconomy $fuelEconomy = null)
    {
        $this->fuelEconomy = $fuelEconomy;
        return $this;
    }
    /**
     * Get fuelCapacity value
     * @return \StructType\FuelCapacity|null
     */
    public function getFuelCapacity()
    {
        return $this->fuelCapacity;
    }
    /**
     * Set fuelCapacity value
     * @param \StructType\FuelCapacity $fuelCapacity
     * @return \StructType\Engine
     */
    public function setFuelCapacity(\StructType\FuelCapacity $fuelCapacity = null)
    {
        $this->fuelCapacity = $fuelCapacity;
        return $this;
    }
    /**
     * Get forcedInduction value
     * @return \StructType\IdentifiedString|null
     */
    public function getForcedInduction()
    {
        return $this->forcedInduction;
    }
    /**
     * Set forcedInduction value
     * @param \StructType\IdentifiedString $forcedInduction
     * @return \StructType\Engine
     */
    public function setForcedInduction(\StructType\IdentifiedString $forcedInduction = null)
    {
        $this->forcedInduction = $forcedInduction;
        return $this;
    }
    /**
     * Get installed value
     * @return \StructType\InstallationCause|null
     */
    public function getInstalled()
    {
        return $this->installed;
    }
    /**
     * Set installed value
     * @param \StructType\InstallationCause $installed
     * @return \StructType\Engine
     */
    public function setInstalled(\StructType\InstallationCause $installed = null)
    {
        $this->installed = $installed;
        return $this;
    }
    /**
     * Get highOutput value
     * @return bool|null
     */
    public function getHighOutput()
    {
        return $this->highOutput;
    }
    /**
     * Set highOutput value
     * @param bool $highOutput
     * @return \StructType\Engine
     */
    public function setHighOutput($highOutput = null)
    {
        // validation for constraint: boolean
        if (!is_null($highOutput) && !is_bool($highOutput)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($highOutput, true), gettype($highOutput)), __LINE__);
        }
        $this->highOutput = $highOutput;
        return $this;
    }
}
